/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.printer;

import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.printer.LabelPrinter;
import com.posics.pos.printer.escpos.CodesLabel;
import com.posics.pos.util.ReportUtils;
import com.posics.pos.util.SelectPrinter;
import java.awt.Component;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;

public class DeviceLabelPrinterPrinter
implements LabelPrinter {
    private static Logger logger = Logger.getLogger("com.posics.pos.printer.printer.DevicePrinterPrinter");
    private Component parent;
    private String m_sName;
    private PrintService printservice;
    private StringWriter m_sLabelCodes;
    private String m_sTextStyle;
    private String m_sBarcodeStyle;
    private CodesLabel m_codes;
    private static final HashMap<String, MediaSizeName> mediasizenamemap = new HashMap();

    public DeviceLabelPrinterPrinter(Component parent, String printername, CodesLabel cl) {
        this.parent = parent;
        this.m_sName = "Printer";
        this.printservice = ReportUtils.getPrintService(printername);
        this.m_codes = cl;
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public JComponent getPrinterComponent() {
        return null;
    }

    @Override
    public void beginLabel() {
        this.m_sLabelCodes = new StringWriter();
        this.m_sLabelCodes.append(this.m_codes.beginLabel());
    }

    @Override
    public void endLabel() {
        this.m_sLabelCodes.append(this.m_codes.endLabel());
        try {
            PrintService ps;
            if (this.printservice == null) {
                String[] printers = ReportUtils.getPrintNames();
                if (printers.length == 0) {
                    logger.warning(AppLocal.getIntString("message.noprinters"));
                    ps = null;
                } else {
                    SelectPrinter selectprinter = SelectPrinter.getSelectPrinter(this.parent, printers);
                    selectprinter.setVisible(true);
                    ps = selectprinter.isOK() ? ReportUtils.getPrintService(selectprinter.getPrintService()) : null;
                }
            } else {
                ps = this.printservice;
            }
            if (ps != null) {
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                aset.add(OrientationRequested.PORTRAIT);
                aset.add(new JobName("Saleculator PDA - Document", null));
                DocPrintJob printjob = ps.createPrintJob();
                byte[] by = this.m_sLabelCodes.toString().getBytes();
                DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
                SimpleDoc doc = new SimpleDoc(by, flavor, null);
                printjob.print(doc, aset);
            }
        }
        catch (PrintException ex) {
            logger.log(Level.WARNING, AppLocal.getIntString("message.printererror"), ex);
            JMessageDialog.showMessage(this.parent, new MessageInf(-33554432, AppLocal.getIntString("message.printererror"), ex));
        }
    }

    @Override
    public void setLabel(String width, String height, String gap, String cols, String direction) {
        this.m_sLabelCodes.append(this.m_codes.setLabel(width, height, gap, cols, direction));
    }

    @Override
    public void setTextStyle(String x, String y, String font, String rotation, String width, String height) {
        this.m_sTextStyle = this.m_codes.setTextStyle(x, y, font, rotation, width, height);
    }

    @Override
    public void setText(String text) {
        this.m_sLabelCodes.append(this.m_sTextStyle + "," + this.m_codes.setText(text));
    }

    @Override
    public void printLabel(int copies) {
        this.m_sLabelCodes.append(this.m_codes.printLabel(copies));
    }

    @Override
    public void setBarcodeStyle(String x, String y, String type, String height, String readable, String rotation, String narrow, String wide) {
        this.m_sBarcodeStyle = this.m_codes.setBarcodeStyle(x, y, type, height, readable, rotation, narrow, wide);
    }

    @Override
    public void setBarcode(String barcode) {
        this.m_sLabelCodes.append(this.m_sBarcodeStyle + "," + this.m_codes.setBarcode(barcode));
    }

    @Override
    public void reset() {
        this.m_sLabelCodes = null;
    }
}

