/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.screen;

import com.posics.data.gui.MessageInf;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.JRootApp;
import com.posics.pos.printer.DevicePrinter;
import com.posics.pos.printer.screen.JTicketContainer;
import com.posics.pos.printer.ticket.BasicTicketForKDS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DevicePrinterKDS
extends JPanel
implements DevicePrinter {
    private String m_sName;
    private String m_skdsid;
    private List<EstimateLine> m_aLines;
    private JTicketContainer m_jTicketContainer;
    private BasicTicketForKDS m_ticketcurrent;
    private JRootApp m_jrootapp;
    private JScrollPane m_jScrollView;

    public DevicePrinterKDS(Component jrootapp, String KDSID) {
        this.initComponents();
        this.m_skdsid = KDSID;
        this.m_sName = AppLocal.getIntString("Printer.KDS");
        this.m_jrootapp = (JRootApp)jrootapp;
        this.m_ticketcurrent = null;
        this.m_jTicketContainer = new JTicketContainer();
        this.m_jScrollView.setViewportView(this.m_jTicketContainer);
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public JComponent getPrinterComponent() {
        return this;
    }

    @Override
    public void reset() {
        this.m_ticketcurrent = null;
        this.m_jTicketContainer.removeAllTickets();
        this.m_jTicketContainer.repaint();
    }

    @Override
    public void beginReceipt() {
        this.m_ticketcurrent = new BasicTicketForKDS();
        this.m_aLines = new ArrayList<EstimateLine>();
    }

    @Override
    public void printImage(BufferedImage image) {
        this.m_ticketcurrent.printImage(image);
    }

    @Override
    public void printBarCode(String type, String position, String code) {
        this.m_ticketcurrent.printBarCode(type, position, code);
    }

    @Override
    public void beginLine(int iTextSize) {
        this.m_ticketcurrent.beginLine(iTextSize);
    }

    @Override
    public void printText(int iStyle, String sText) {
        this.m_ticketcurrent.printText(iStyle, sText);
    }

    @Override
    public void endLine() {
        this.m_ticketcurrent.endLine();
    }

    @Override
    public void endReceipt() {
        try {
            String m_sticketid = UUID.randomUUID().toString();
            Object[] values = new Object[]{m_sticketid, this.m_jrootapp.getActiveCashIndex(), this.m_skdsid, this.m_ticketcurrent, new Date(), this.m_jrootapp.getAppUserView().getUser().getId(), 0};
            Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.SERIALIZABLE, Datas.TIMESTAMP, Datas.STRING, Datas.INT};
            new PreparedSentence(this.m_jrootapp.getSession(), "INSERT INTO KDSTICKETS (ID, MONEY, DISPLAYID, CONTENT, DATESENT, USERNAME, STATUS) VALUES (?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(datas, new int[]{0, 1, 2, 3, 4, 5, 6})).exec(values);
            Datas[] linedatas = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.DOUBLE};
            for (int i = 0; i < this.m_aLines.size(); ++i) {
                Object[] linevalues = new Object[]{UUID.randomUUID().toString(), new Date(), m_sticketid, this.m_aLines.get(i).getProductName(), this.m_aLines.get(i).getUnits()};
                new PreparedSentence(this.m_jrootapp.getSession(), "INSERT INTO KDSLINES (ID, DATESENT, KDSID, PRODUCT, UNITS) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(linedatas, new int[]{0, 1, 2, 3, 4})).exec(linevalues);
            }
        }
        catch (Exception eData) {
            new MessageInf(eData).show(this);
        }
        this.m_ticketcurrent = null;
    }

    @Override
    public void openDrawer() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void playBuzzer() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void estimateLine(String product, double units) {
        this.m_aLines.add(new EstimateLine(product, units));
    }

    private void initComponents() {
        this.m_jScrollView = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jScrollView, "Center");
    }

    public class EstimateLine {
        private double multiply;
        private String productname;

        private EstimateLine(String name, double multiply) {
            this.productname = name;
            this.multiply = multiply;
        }

        private String getProductName() {
            return this.productname;
        }

        private double getUnits() {
            return this.multiply;
        }
    }
}

