/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.reports;

import com.posics.basic.BasicException;
import com.posics.beans.JCalendarDialog;
import com.posics.data.loader.Datas;
import com.posics.data.loader.QBFCompareEnum;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasic;
import com.posics.format.Formats;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.reports.ReportEditorCreator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JParamsDatesInterval
extends JPanel
implements ReportEditorCreator {
    boolean calOnly = false;
    private JButton btnDateEnd;
    private JButton btnDateStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTxtEndDate;
    private JTextField jTxtStartDate;

    public JParamsDatesInterval() {
        this.initComponents();
    }

    public JParamsDatesInterval(boolean calOnly) {
        this.initComponents();
        this.calOnly = calOnly;
    }

    public void setStartDate(Date d) {
        if (this.calOnly) {
            this.jTxtStartDate.setText(Formats.DATE.formatValue(d));
        } else {
            this.jTxtStartDate.setText(Formats.TIMESTAMP.formatValue(d));
        }
    }

    public void setEndDate(Date d) {
        if (this.calOnly) {
            this.jTxtEndDate.setText(Formats.DATE.formatValue(d));
        } else {
            this.jTxtEndDate.setText(Formats.TIMESTAMP.formatValue(d));
        }
    }

    public String getStartDate() {
        return this.jTxtStartDate.getText();
    }

    public String getEndDate() {
        return this.jTxtEndDate.getText();
    }

    @Override
    public void init(AppView app) {
    }

    @Override
    public void activate() throws BasicException {
    }

    @Override
    public SerializerWrite getSerializerWrite() {
        return new SerializerWriteBasic(Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.TIMESTAMP);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Object createValue() throws BasicException {
        Object startdate = Formats.TIMESTAMP.parseValue(this.jTxtStartDate.getText());
        Object enddate = Formats.TIMESTAMP.parseValue(this.jTxtEndDate.getText());
        return new Object[]{startdate == null ? QBFCompareEnum.COMP_NONE : QBFCompareEnum.COMP_GREATEROREQUALS, startdate, enddate == null ? QBFCompareEnum.COMP_NONE : QBFCompareEnum.COMP_LESS, enddate};
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTxtStartDate = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTxtEndDate = new JTextField();
        this.btnDateStart = new JButton();
        this.btnDateEnd = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(AppLocal.getIntString("label.bydates")));
        this.setPreferredSize(new Dimension(425, 100));
        this.setLayout(null);
        this.jLabel1.setText(AppLocal.getIntString("Label.StartDate"));
        this.add(this.jLabel1);
        this.jLabel1.setBounds(16, 25, 120, 14);
        this.add(this.jTxtStartDate);
        this.jTxtStartDate.setBounds(140, 20, 200, 25);
        this.jLabel2.setText(AppLocal.getIntString("Label.EndDate"));
        this.add(this.jLabel2);
        this.jLabel2.setBounds(16, 55, 120, 14);
        this.add(this.jTxtEndDate);
        this.jTxtEndDate.setBounds(140, 50, 200, 25);
        this.btnDateStart.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/date.png")));
        this.btnDateStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JParamsDatesInterval.this.btnDateStartActionPerformed(evt);
            }
        });
        this.add(this.btnDateStart);
        this.btnDateStart.setBounds(350, 20, 49, 25);
        this.btnDateEnd.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/date.png")));
        this.btnDateEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JParamsDatesInterval.this.btnDateEndActionPerformed(evt);
            }
        });
        this.add(this.btnDateEnd);
        this.btnDateEnd.setBounds(350, 50, 49, 25);
    }

    private void btnDateStartActionPerformed(ActionEvent evt) {
        Date date;
        try {
            date = (Date)Formats.TIMESTAMP.parseValue(this.jTxtStartDate.getText());
        }
        catch (BasicException e) {
            date = null;
        }
        if (this.calOnly) {
            if ((date = JCalendarDialog.showCalendar(this, date)) != null) {
                this.jTxtStartDate.setText(Formats.DATE.formatValue(date));
            }
        } else if ((date = JCalendarDialog.showCalendarTimeHours(this, date)) != null) {
            this.jTxtStartDate.setText(Formats.TIMESTAMP.formatValue(date));
        }
    }

    private void btnDateEndActionPerformed(ActionEvent evt) {
        Date date;
        try {
            date = (Date)Formats.TIMESTAMP.parseValue(this.jTxtEndDate.getText());
        }
        catch (BasicException e) {
            date = null;
        }
        if (this.calOnly) {
            if ((date = JCalendarDialog.showCalendar(this, date)) != null) {
                this.jTxtEndDate.setText(Formats.DATE.formatValue(date));
            }
        } else if ((date = JCalendarDialog.showCalendarTimeHours(this, date)) != null) {
            this.jTxtEndDate.setText(Formats.TIMESTAMP.formatValue(date));
        }
    }
}

