/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.reports;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.forms.AppView;
import com.posics.pos.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class POSReportsModel {
    private String m_sHost;
    private String m_sUser;
    private String m_sStartDate;
    private String m_sEndDate;
    private List<ProductSales> m_lproductsales;
    private List<SalesTickets> m_lsalestickets;

    private POSReportsModel() {
    }

    public static POSReportsModel loadProductSales(AppView app, String startDate, String endDate) throws BasicException {
        POSReportsModel p = new POSReportsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_sUser = app.getAppUserView().getUser().getName();
        p.m_sStartDate = startDate;
        p.m_sEndDate = endDate;
        List psales = new StaticSentence(app.getSession(), "SELECT CATEGORIES.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME,PRODUCTS.CODE, SUM(TICKETLINES.UNITS) AS UNITS, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL FROM RECEIPTS, TICKETS, TICKETLINES LEFT JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID LEFT JOIN CATEGORIES ON CATEGORIES.ID=PRODUCTS.CATEGORY WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND (RECEIPTS.DATENEW >= {ts '" + startDate + "'} AND RECEIPTS.DATENEW < {ts '" + endDate + "'}) GROUP BY PRODUCTS.ID ORDER BY CATEGORIES.NAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSales.class)).list();
        p.m_lproductsales = psales == null ? new ArrayList<ProductSales>() : psales;
        return p;
    }

    public static POSReportsModel loadReceipts(AppView app, String startDate, String endDate) throws BasicException {
        POSReportsModel p = new POSReportsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_sUser = app.getAppUserView().getUser().getName();
        List psales = new StaticSentence(app.getSession(), "SELECT TICKETS.TICKETID AS TICKET_NO, RECEIPTS.DATENEW AS TICKET_DATE, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS MONEY, SUM(TICKETLINES.UNITS) AS QTY, CUSTOMERS.NAME AS CUSTOMER FROM RECEIPTS LEFT JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID LEFT JOIN TICKETLINES ON TICKETLINES.TICKET = TICKETS.ID LEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID WHERE (RECEIPTS.DATENEW >= {ts '" + startDate + "'} AND RECEIPTS.DATENEW < {ts '" + endDate + "'}) GROUP BY TICKETLINES.TICKET ORDER BY RECEIPTS.DATENEW, TICKETS.TICKETID", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(SalesTickets.class)).list();
        p.m_lsalestickets = psales == null ? new ArrayList<SalesTickets>() : psales;
        return p;
    }

    public String printHost() {
        return StringUtils.encodeXML(this.m_sHost);
    }

    public String printUserName() {
        return StringUtils.encodeXML(this.m_sUser);
    }

    public String printStartDate() {
        return this.m_sStartDate;
    }

    public String printEndDate() {
        return this.m_sEndDate;
    }

    public List<ProductSales> getProductSales() {
        return this.m_lproductsales;
    }

    public List<SalesTickets> getSalesTickets() {
        return this.m_lsalestickets;
    }

    public String formatCurrency(Double val) {
        return Formats.CURRENCY.formatValue(val);
    }

    public static class SalesTickets
    implements SerializableRead {
        private String m_TicketId;
        private Date m_TicketDate;
        private Double m_Amount;
        private Double m_Qty;
        private String m_Customer;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_TicketId = dr.getString(1);
            this.m_TicketDate = dr.getTimestamp(2);
            this.m_Amount = dr.getDouble(3);
            this.m_Qty = dr.getDouble(4);
            this.m_Customer = dr.getString(5);
        }

        public String printTicketId() {
            if (this.m_TicketId != null) {
                return this.m_TicketId;
            }
            return "";
        }

        public String printDate() {
            return Formats.TIMESTAMP.formatValue(this.m_TicketDate);
        }

        public String printAmount() {
            return Formats.CURRENCY.formatValue(this.m_Amount);
        }

        public Double getAmount() {
            return this.m_Amount;
        }

        public String printUnits() {
            return Formats.DOUBLE.formatValue(this.m_Qty);
        }

        public Double getUnits() {
            return this.m_Qty;
        }

        public String printCustomerName() {
            return StringUtils.encodeXML(this.m_Customer);
        }
    }

    public static class ProductSales
    implements SerializableRead {
        private String m_category;
        private String m_productRef;
        private String m_productName;
        private String m_productCode;
        private Double m_units;
        private Double m_amount;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_category = dr.getString(1);
            this.m_productRef = dr.getString(2);
            this.m_productName = dr.getString(3);
            this.m_productCode = dr.getString(4);
            this.m_units = dr.getDouble(5);
            this.m_amount = dr.getDouble(6);
        }

        public String printCategory() {
            if (this.m_category == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.m_category);
        }

        public String printProductRef() {
            if (this.m_productRef == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.m_productRef);
        }

        public String printProductName() {
            if (this.m_productName == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.m_productName);
        }

        public String printProductCode() {
            if (this.m_productCode == null) {
                return "*";
            }
            return StringUtils.encodeXML(this.m_productCode);
        }

        public String printAmount() {
            return Formats.CURRENCY.formatValue(this.m_amount);
        }

        public Double getAmount() {
            return this.m_amount;
        }

        public String printUnits() {
            return Formats.DOUBLE.formatValue(this.m_units);
        }

        public Double getUnits() {
            return this.m_units;
        }
    }
}

