/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.reports;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.Datas;
import com.posics.data.loader.QBFBuilder;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasicComposed;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.forms.AppView;
import com.posics.pos.reports.CaselessProperties;
import com.posics.pos.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SalesByProperty {
    private List<SalesWithAttributes> m_lsaleswithattributes;
    private Double m_dPropertySalesTotal;

    private SalesByProperty() {
    }

    public static SalesByProperty loadInstance(AppView app, Object params) throws BasicException {
        SalesByProperty p = new SalesByProperty();
        List saleswithattributes = new StaticSentence(app.getSession(), new QBFBuilder("SELECT PAYMENTS.TOTAL, RECEIPTS.ATTRIBUTES FROM PAYMENTS, RECEIPTS WHERE PAYMENTS.RECEIPT = RECEIPTS.ID  AND ?(QBF_FILTER) ", new String[]{"RECEIPTS.DATENEW", "RECEIPTS.DATENEW"}), (SerializerWrite)new SerializerWriteBasicComposed(new Datas[][]{{Datas.OBJECT, Datas.TIMESTAMP, Datas.OBJECT, Datas.TIMESTAMP}}), (SerializerRead)new SerializerReadClass(SalesWithAttributes.class)).list(params);
        if (saleswithattributes == null) {
            p.m_lsaleswithattributes = new ArrayList<SalesWithAttributes>();
            p.m_dPropertySalesTotal = new Double(0.0);
        } else {
            p.m_lsaleswithattributes = saleswithattributes;
            p.m_dPropertySalesTotal = new Double(0.0);
        }
        return p;
    }

    public String printPropertySalesTotal() {
        return Formats.CURRENCY.formatValue(this.m_dPropertySalesTotal);
    }

    public ArrayList<SalesByPropertyItem> getSalesByProperty(String propertyName) {
        ArrayList<SalesByPropertyItem> salesbyproperty = new ArrayList<SalesByPropertyItem>();
        this.m_dPropertySalesTotal = new Double(0.0);
        if (this.m_lsaleswithattributes.size() > 0) {
            try {
                for (int i = 0; i < this.m_lsaleswithattributes.size(); ++i) {
                    SalesWithAttributes swa = this.m_lsaleswithattributes.get(i);
                    SalesByPropertyItem sp = new SalesByPropertyItem();
                    if (swa.getAttributes().getProperty(propertyName) != null) {
                        sp.setPropertyName(this.m_lsaleswithattributes.get(i).getAttributes().getProperty(propertyName));
                    } else {
                        sp.setPropertyName("Standard");
                    }
                    sp.setSaleAmount(this.m_lsaleswithattributes.get(i).getSaleAmount());
                    sp.setCount(1);
                    this.m_dPropertySalesTotal = this.m_dPropertySalesTotal + this.m_lsaleswithattributes.get(i).getSaleAmount();
                    Boolean blUpdate = false;
                    if (salesbyproperty.size() > 0) {
                        for (int j = 0; j < salesbyproperty.size(); ++j) {
                            SalesByPropertyItem sbp = salesbyproperty.get(j);
                            if (sp.getPropertyValue().compareToIgnoreCase(sbp.getPropertyValue()) == 0) {
                                sbp.setSaleAmount(sbp.getSaleAmount() + sp.getSaleAmount());
                                sbp.setCount(sbp.getCount() + 1);
                                salesbyproperty.set(j, sbp);
                                blUpdate = true;
                            }
                            if (!blUpdate.booleanValue()) continue;
                            j = salesbyproperty.size();
                        }
                        if (blUpdate.booleanValue()) continue;
                        salesbyproperty.add(sp);
                        continue;
                    }
                    salesbyproperty.add(sp);
                }
            }
            catch (Exception e) {
                System.out.println("Property Error " + e.toString());
            }
        }
        return salesbyproperty;
    }

    public static class SalesWithAttributes
    implements SerializableRead {
        private Double m_Amount;
        private CaselessProperties m_Properties;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_Amount = dr.getDouble(1);
            this.m_Properties = new CaselessProperties();
            try {
                byte[] img = dr.getBytes(2);
                if (img != null) {
                    this.m_Properties.loadFromXML(new ByteArrayInputStream(img));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Double getSaleAmount() {
            return this.m_Amount;
        }

        public Properties getAttributes() {
            return this.m_Properties;
        }
    }

    public static class SalesByPropertyItem {
        private String m_PropertyName;
        private Double m_Amount;
        private Integer m_Count;

        public void setPropertyName(String propertyName) {
            this.m_PropertyName = propertyName;
        }

        public void setCount(Integer count) {
            this.m_Count = count;
        }

        public void setSaleAmount(Double amount) {
            this.m_Amount = amount;
        }

        public String getPropertyValue() {
            return this.m_PropertyName;
        }

        public Integer getCount() {
            return this.m_Count;
        }

        public Double getSaleAmount() {
            return this.m_Amount;
        }

        public String printPropertyName() {
            return StringUtils.encodeXML(this.m_PropertyName);
        }

        public String printCount() {
            return Formats.INT.formatValue(this.m_Count);
        }

        public String printSaleAmount() {
            return Formats.CURRENCY.formatValue(this.m_Amount);
        }
    }
}

