/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadBasic;
import com.posics.data.loader.SerializerReadBytes;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.pos.forms.BeanFactoryDataSingle;
import com.posics.pos.kds.KDSTicketInfo;
import com.posics.pos.mant.AccountheadInfo;
import com.posics.pos.sales.SharedTicketInfo;
import com.posics.pos.sales.UnPaidTicketInfo;
import com.posics.pos.sales.delivery.DeliveryCall;
import com.posics.pos.sales.delivery.DriverInfo;
import com.posics.pos.sales.restaurant.Place;
import com.posics.pos.ticket.TicketInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Properties;

public class DataLogicReceipts
extends BeanFactoryDataSingle {
    private Session s;

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public final TicketInfo getSharedTicket(String Id) throws BasicException {
        if (Id == null) {
            return null;
        }
        Object[] record = (Object[])new StaticSentence(this.s, "SELECT CONTENT FROM SHAREDTICKETS WHERE ID = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.SERIALIZABLE})).find((Object)Id);
        return record == null ? null : (TicketInfo)record[0];
    }

    public final Properties getTicketProperties(String Id) {
        try {
            PreparedSentence m_resourcebytes = new PreparedSentence(this.s, "SELECT ATTRIBUTES FROM RECEIPTS WHERE ID LIKE ?", SerializerWriteString.INSTANCE, SerializerReadBytes.INSTANCE);
            byte[] resource = (byte[])m_resourcebytes.find((Object)Id);
            Properties properties = new Properties();
            properties.loadFromXML(new ByteArrayInputStream(resource));
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final List<SharedTicketInfo> getSharedTicketList(int bmode) throws BasicException {
        return new StaticSentence(this.s, "SELECT ID, NAME, LOCKED FROM SHAREDTICKETS WHERE BMODE=" + bmode + " ORDER BY ID", null, (SerializerRead)new SerializerReadClass(SharedTicketInfo.class)).list();
    }

    public final void setKdsAttended(String ticketid) throws BasicException {
        Object[] values = new Object[]{ticketid};
        Datas[] datas = new Datas[]{Datas.STRING};
        new PreparedSentence(this.s, "UPDATE KDSTICKETS SET STATUS = 2, DATEATTENDED=NOW()  WHERE ID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{0})).exec(values);
    }

    public final void setKdsClosed(String ticketid) throws BasicException {
        Object[] values = new Object[]{ticketid};
        Datas[] datas = new Datas[]{Datas.STRING};
        new PreparedSentence(this.s, "UPDATE KDSTICKETS SET STATUS = 3, DATECLOSED=NOW()  WHERE ID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{0})).exec(values);
        new PreparedSentence(this.s, "DELETE FROM KDSLINES WHERE KDSID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{0})).exec(values);
    }

    public final List<KDSTicketInfo> getKDSTickets(String money, String userid) throws BasicException {
        if (money == null) {
            return null;
        }
        if (userid.equals("")) {
            return new StaticSentence(this.s, "SELECT ID, MONEY, DISPLAYID, CONTENT, DATESENT, DATEATTENDED, DATECLOSED, STATUS FROM KDSTICKETS WHERE MONEY LIKE ? AND STATUS!=3 ORDER BY DATESENT", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(KDSTicketInfo.class)).list((Object)money);
        }
        return new StaticSentence(this.s, "SELECT ID, MONEY, DISPLAYID, CONTENT, DATESENT, DATEATTENDED, DATECLOSED, STATUS FROM KDSTICKETS WHERE MONEY LIKE '" + money + "' AND STATUS!=3 AND USERNAME LIKE '" + userid + "' ORDER BY DATESENT", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(KDSTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getUnPaidTicketList(String money) throws BasicException {
        String query = "";
        if (money != null) {
            query = money.length() <= 2 ? " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day))) " : " AND CC.MONEY LIKE '" + money + "'";
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, ExtractValue(CAST(ATTRIBUTES AS binary), \"//entry[@key=\\\"Place\\\"]\"), SUM(C.TOTAL), CS.NAME FROM TICKETS A JOIN RECEIPTS B LEFT JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0 AND A.STATUS=0 AND DC.RECEIPT IS NULL GROUP BY A.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getMyUnPaidTicketList(String money, String userid) throws BasicException {
        String query = " AND PERSON LIKE '" + userid + "' ";
        if (money != null) {
            query = money.length() <= 2 ? " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day)))" : " AND CC.MONEY LIKE '" + money + "'";
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, ExtractValue(CAST(ATTRIBUTES AS binary), \"//entry[@key=\\\"Place\\\"]\"), SUM(C.TOTAL), CS.NAME FROM TICKETS A JOIN RECEIPTS B LEFT JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0 AND A.STATUS=0 AND DC.RECEIPT IS NULL GROUP BY A.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getUnPaidDeliveryTicketList(String money) throws BasicException {
        String query = "";
        if (money != null) {
            if (money.length() <= 2) {
                query = " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day)))";
            } else if (money != null) {
                query = " AND CC.MONEY LIKE '" + money + "'";
            }
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL) AS TOTAL, CS.NAME FROM TICKETS A JOIN RECEIPTS B JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0 AND DC.DRIVERID IS NULL GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getUnPaidDeliveryTicketList2(String money, String customer) throws BasicException {
        String query = "";
        if (money != null) {
            if (money.length() <= 2) {
                query = " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day)))";
            } else if (money != null) {
                query = " AND CC.MONEY LIKE '" + money + "'";
            }
        }
        if (customer != null) {
            return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL) AS TOTAL, CS.NAME FROM TICKETS A JOIN RECEIPTS B LEFT JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID AND CS.ID LIKE '" + customer + "' WHERE A.TICKETTYPE=0  AND A.STATUS=0 AND DC.DRIVERID IS NULL GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL) AS TOTAL, CS.NAME FROM TICKETS A JOIN RECEIPTS B LEFT JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0  AND A.STATUS=0 AND DC.DRIVERID IS NULL GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getPaidDeliveryTicketList(String money) throws BasicException {
        String query = "";
        if (money != null) {
            if (money.length() <= 2) {
                query = " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day))) ";
            } else if (money != null) {
                query = " AND CC.MONEY LIKE '" + money + "'";
            }
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL), CS.NAME FROM TICKETS A JOIN RECEIPTS B JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0 AND DC.DRIVERID IS NOT NULL GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final List<UnPaidTicketInfo> getPaidDeliveryTicketListByDriver(String money, String driverid, String customerid) throws BasicException {
        String query = "";
        if (money != null) {
            query = money.length() <= 2 ? " AND CC.MONEY IN (SELECT MONEY FROM CLOSEDCASH WHERE DATESTART>=TIMESTAMP(DATE_SUB(NOW(), INTERVAL " + money + " day)))" : " AND CC.MONEY LIKE '" + money + "'";
        }
        if (customerid != null) {
            return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL), CS.NAME FROM TICKETS A JOIN RECEIPTS B JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID AND CS.ID LIKE '" + customerid + "' WHERE A.TICKETTYPE=0   AND A.STATUS=0 AND DC.DRIVERID LIKE '" + driverid + "' GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
        }
        return new StaticSentence(this.s, "SELECT A.ID, A.TICKETID, B.DATENEW, null, SUM(C.TOTAL), CS.NAME FROM TICKETS A JOIN RECEIPTS B JOIN DELIVERYORDERS DC ON B.ID=DC.RECEIPT JOIN CLOSEDCASH CC ON CC.MONEY = B.MONEY " + query + " AND A.ID=B.ID JOIN PAYMENTS C ON B.ID=C.RECEIPT LEFT JOIN CUSTOMERS CS ON A.CUSTOMER=CS.ID WHERE A.TICKETTYPE=0   AND A.STATUS=0 AND DC.DRIVERID LIKE '" + driverid + "' GROUP BY B.ID ORDER BY DATENEW", null, (SerializerRead)new SerializerReadClass(UnPaidTicketInfo.class)).list();
    }

    public final void setReceiptAttributes(String ticketid, ByteArrayOutputStream o) throws BasicException {
        Object[] values = new Object[]{ticketid, o.toByteArray()};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.BYTES};
        new PreparedSentence(this.s, "UPDATE RECEIPTS SET ATTRIBUTES = ? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{1, 0})).exec(values);
    }

    public final void setTicketStatus(String ticketid, int o) throws BasicException {
        Object[] values = new Object[]{ticketid, o};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.INT};
        new PreparedSentence(this.s, "UPDATE TICKETS SET STATUS = ? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{1, 0})).exec(values);
    }

    public final void updateSharedTicket(String id, TicketInfo ticket) throws BasicException {
        Object[] values = new Object[]{id, ticket.getName(), ticket};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.SERIALIZABLE};
        new PreparedSentence(this.s, "UPDATE SHAREDTICKETS SET NAME = ?, CONTENT = ?, LOCKED=null WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{1, 2, 0})).exec(values);
    }

    public final void lockTable(String id, String username) throws BasicException {
        Object[] values = new Object[]{id, username};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE SHAREDTICKETS SET LOCKED=? WHERE ID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{1, 0})).exec(values);
    }

    public final void unlockTable(String id) throws BasicException {
        Object[] values = new Object[]{id};
        Datas[] datas = new Datas[]{Datas.STRING};
        new PreparedSentence(this.s, "UPDATE SHAREDTICKETS SET LOCKED=null WHERE ID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{0})).exec(values);
    }

    public final void insertSharedTicket(String id, TicketInfo ticket, int bmode, String username) throws BasicException {
        Object[] values = new Object[]{id, ticket.getName(), ticket, bmode, username};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.SERIALIZABLE, Datas.INT, Datas.STRING};
        new PreparedSentence(this.s, "INSERT INTO SHAREDTICKETS (ID, NAME,CONTENT, BMODE, LOCKED) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(datas, new int[]{0, 1, 2, 3, 4})).exec(values);
    }

    public final String isTableLocked(String Id) throws BasicException {
        if (Id == null) {
            return null;
        }
        Object[] record = (Object[])new StaticSentence(this.s, "SELECT LOCKED FROM SHAREDTICKETS WHERE ID LIKE ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)Id);
        if (record == null || record[0] == null) {
            return null;
        }
        return record[0].toString();
    }

    public final void deleteSharedTicket(String id) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM SHAREDTICKETS WHERE ID LIKE ?", SerializerWriteString.INSTANCE).exec((Object)id);
    }

    public final void deleteDelivery(String id) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM DELIVERYORDERS WHERE ID LIKE ?", SerializerWriteString.INSTANCE).exec((Object)id);
    }

    public final void insertCall(DeliveryCall call) throws BasicException {
        Object[] values = new Object[]{call.getId(), call.getCallerId(), call.getDate(), call.getLine(), call.getMoney(), call.getCustomerId(), 0};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.STRING, Datas.INT};
        new PreparedSentence(this.s, "INSERT INTO CALLS (ID, CALLERID, DATENEW, LINEID, MONEY, CUSTOMER, STATUS) VALUES (?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(datas, new int[]{0, 1, 2, 3, 4, 5, 6})).exec(values);
    }

    public final void updateCallCustomer(DeliveryCall call) throws BasicException {
        Object[] values = new Object[]{call.getCustomer().getSearchkey(), call.getId()};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE CALLS SET CUSTOMER=? WHERE ID LIKE ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }

    public final void insertDeliveryOrder(String id, String callid) throws BasicException {
        Object[] values = new Object[]{id, callid};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "INSERT INTO DELIVERYORDERS (ID, CALLID) VALUES (?, ?);", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }

    public final void insertDeliveryOrderStandard(String id, String driver, String receipt) throws BasicException {
        Object[] values = new Object[]{id, driver, receipt};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "INSERT INTO DELIVERYORDERS (ID, DRIVERID, RECEIPT) VALUES (?, ?, ?);", new SerializerWriteBasicExt(datas, new int[]{0, 1, 2})).exec(values);
    }

    public final void updateCallStatus(int status, String callid) throws BasicException {
        Object[] values = new Object[]{status, callid};
        Datas[] datas = new Datas[]{Datas.INT, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE CALLS SET STATUS=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }

    public final List<DeliveryCall> getCallLog(String money, String deviceid) throws BasicException {
        return new StaticSentence(this.s, "SELECT C.ID, C.CALLERID, C.DATENEW, C.LINEID, C.MONEY, C.CUSTOMER, D.ID, D.RECEIPT, C.STATUS, DR.DRIVERNAME FROM CALLS C LEFT JOIN DELIVERYORDERS D ON D.CALLID=C.ID LEFT JOIN DRIVERS DR ON DR.ID=D.DRIVERID  WHERE C.MONEY LIKE '" + money + "' AND C.LINEID LIKE '" + deviceid + "' ORDER BY C.DATENEW DESC", null, (SerializerRead)new SerializerReadClass(DeliveryCall.class)).list();
    }

    public final List<DriverInfo> getDrivers() throws BasicException {
        return new StaticSentence(this.s, "SELECT ID, DRIVERNAME, CODE FROM DRIVERS ORDER BY DRIVERNAME", null, (SerializerRead)new SerializerReadClass(DriverInfo.class)).list();
    }

    public final List<AccountheadInfo> getAccountheads() throws BasicException {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM ACCOUNTHEADS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(AccountheadInfo.class)).list();
    }

    public final List<Place> getOpenTickets(int bmode) throws BasicException {
        if (bmode == 2) {
            return new StaticSentence(this.s, "SELECT S.ID, CONCAT(P.NAME, ' (', S.LOCKED,')'), P.X, P.Y, P.FLOOR, F.NAME FROM SHAREDTICKETS S JOIN PLACES P ON S.ID=P.ID JOIN FLOORS F ON P.FLOOR=F.ID WHERE S.LOCKED IS NOT NULL AND S.BMODE=" + bmode + " ORDER BY P.NAME", null, (SerializerRead)new SerializerReadClass(Place.class)).list();
        }
        if (bmode == 3) {
            return new StaticSentence(this.s, "SELECT S.ID, CONCAT(S.NAME, ' (', S.LOCKED,')'), 0, 0, NULL, NULL FROM SHAREDTICKETS S WHERE S.LOCKED IS NOT NULL AND S.BMODE=" + bmode + " ORDER BY S.NAME", null, (SerializerRead)new SerializerReadClass(Place.class)).list();
        }
        return null;
    }

    public final void updateDeliveryDriver(String driver, String deliveryid) throws BasicException {
        Object[] values = new Object[]{driver, deliveryid};
        Datas[] datas = new Datas[]{Datas.STRING, Datas.STRING};
        new PreparedSentence(this.s, "UPDATE DELIVERYORDERS SET DRIVERID=? WHERE ID = ?", new SerializerWriteBasicExt(datas, new int[]{0, 1})).exec(values);
    }
}

