/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.beans.DateUtils;
import com.posics.beans.JCalendarPanel;
import com.posics.beans.JTimePanel;
import com.posics.data.gui.JCounter;
import com.posics.data.gui.JLabelDirty;
import com.posics.data.gui.JListNavigator;
import com.posics.data.gui.JNavigator;
import com.posics.data.gui.JSaver;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.LocalRes;
import com.posics.data.user.BrowsableEditableData;
import com.posics.data.user.DirtyManager;
import com.posics.data.user.EditorCreator;
import com.posics.data.user.EditorRecord;
import com.posics.data.user.ListProviderCreator;
import com.posics.data.user.SaveProvider;
import com.posics.editor.JEditorKeys;
import com.posics.editor.JEditorString;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.customers.JCustomerFinder;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.payment.JPaymentSelect;
import com.posics.pos.payment.JPaymentSelectCustomer;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.sales.restaurant.JCalendarItemRenderer;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JBooking
extends JPanel
implements JPanelView,
EditorRecord,
BeanFactoryApp {
    private DataLogicCustomers dlCustomers = null;
    private DataLogicSales dlSales = null;
    private DataLogicSystem dlSystem = null;
    private DirtyManager m_Dirty;
    private Object m_sID;
    private CustomerInfo customer;
    private Date m_dCreated;
    private JTimePanel m_timereservation;
    private boolean m_bReceived;
    private BrowsableEditableData m_bd;
    private Date m_dcurrentday;
    private JCalendarPanel m_datepanel;
    private JTimePanel m_timepanel;
    private boolean m_bpaintlock = false;
    private JPaymentSelect paymentdialog;
    private AppView app;
    private TicketParser ttp;
    private JButton btnPay;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelDate;
    private JPanel jPanelTime;
    private JEditorKeys m_jKeys;
    private JPanel m_jPanelList;
    private JPanel m_jPanelTime;
    private JPanel m_jToolbar;
    private JPanel m_jToolbarContainer;
    private JButton m_jbtnReceive;
    private JButton m_jbtnTables;
    private JEditorString m_jtxtDescription;
    private JEditorString txtCustomer;

    @Override
    public void init(AppView oApp) throws BeanFactoryException {
        this.app = oApp;
        this.dlCustomers = (DataLogicCustomers)oApp.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.dlSales = (DataLogicSales)this.app.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlSystem = (DataLogicSystem)this.app.getBean("com.posics.pos.forms.DataLogicSystem");
        this.ttp = new TicketParser(this.app.getDeviceTicket(), this.dlSystem);
        this.m_dcurrentday = null;
        this.initComponents();
        this.m_datepanel = new JCalendarPanel();
        this.jPanelDate.add((Component)this.m_datepanel, "Center");
        this.m_datepanel.addPropertyChangeListener("Date", new DateChangeCalendarListener());
        this.m_timepanel = new JTimePanel(null, 1);
        this.m_timepanel.setPeriod(3600000L);
        this.jPanelTime.add((Component)this.m_timepanel, "Center");
        this.m_timepanel.addPropertyChangeListener("Date", new DateChangeTimeListener());
        this.m_timereservation = new JTimePanel(null, 2);
        this.m_jPanelTime.add((Component)this.m_timereservation, "Center");
        this.txtCustomer.addEditorKeys(this.m_jKeys);
        this.m_jtxtDescription.addEditorKeys(this.m_jKeys);
        this.m_Dirty = new DirtyManager();
        this.m_timereservation.addPropertyChangeListener("Date", this.m_Dirty);
        this.txtCustomer.addPropertyChangeListener("Text", this.m_Dirty);
        this.txtCustomer.addPropertyChangeListener("Text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JBooking.this.customer = new CustomerInfo(null);
                JBooking.this.customer.setTaxid(null);
                JBooking.this.customer.setSearchkey(null);
                JBooking.this.customer.setName(JBooking.this.txtCustomer.getText());
            }
        });
        this.m_jtxtDescription.addPropertyChangeListener("Text", this.m_Dirty);
        this.writeValueEOF();
        ListProviderCreator lpr = new ListProviderCreator(this.dlCustomers.getReservationsList(), new MyDateFilter());
        SaveProvider spr = new SaveProvider(this.dlCustomers.getReservationsUpdate(), this.dlCustomers.getReservationsInsert(), this.dlCustomers.getReservationsDelete());
        this.m_bd = new BrowsableEditableData(lpr, spr, new CompareReservations(), this, this.m_Dirty);
        JListNavigator nl = new JListNavigator(this.m_bd, true);
        nl.setCellRenderer(new JCalendarItemRenderer());
        this.m_jPanelList.add((Component)nl, "Center");
        this.m_jToolbar.add(new JLabelDirty(this.m_Dirty));
        this.m_jToolbar.add(new JCounter(this.m_bd));
        this.m_jToolbar.add(new JNavigator(this.m_bd));
        this.m_jToolbar.add(new JSaver(this.m_bd));
        this.btnPay.setEnabled(false);
    }

    @Override
    public void activate() {
        this.paymentdialog = JPaymentSelectCustomer.getDialog(this);
        this.paymentdialog.init(this.app);
        this.reload(DateUtils.getTodayHours(new Date()));
    }

    @Override
    public void refresh() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.Booking");
    }

    @Override
    public boolean deactivate() {
        try {
            return this.m_bd.actionClosingForm(this);
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.CannotMove"), eD);
            msg.show(this);
            return false;
        }
    }

    @Override
    public void writeValueEOF() {
        this.m_sID = null;
        this.m_dCreated = null;
        this.m_timereservation.setDate(null);
        this.assignCustomer(new CustomerInfo(null));
        this.m_bReceived = false;
        this.m_jtxtDescription.reset();
        this.m_timereservation.setEnabled(false);
        this.txtCustomer.setEnabled(false);
        this.m_jtxtDescription.setEnabled(false);
        this.m_jKeys.setEnabled(false);
        this.m_jbtnReceive.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_sID = null;
        this.m_dCreated = null;
        this.m_timereservation.setCheckDates(this.m_dcurrentday, new Date(this.m_dcurrentday.getTime() + 3600000L));
        this.m_timereservation.setDate(this.m_dcurrentday);
        this.assignCustomer(new CustomerInfo(null));
        this.m_bReceived = false;
        this.m_jtxtDescription.reset();
        this.m_timereservation.setEnabled(true);
        this.txtCustomer.setEnabled(true);
        this.m_jtxtDescription.setEnabled(true);
        this.m_jKeys.setEnabled(true);
        this.m_jbtnReceive.setEnabled(true);
        this.txtCustomer.activate();
    }

    @Override
    public void writeValueDelete(Object value) {
        Object[] res = (Object[])value;
        this.m_sID = res[0];
        this.m_dCreated = (Date)res[1];
        this.m_timereservation.setCheckDates(this.m_dcurrentday, new Date(this.m_dcurrentday.getTime() + 3600000L));
        this.m_timereservation.setDate((Date)res[2]);
        CustomerInfo c = new CustomerInfo((String)res[3]);
        c.setTaxid((String)res[4]);
        c.setSearchkey((String)res[5]);
        c.setName((String)res[6]);
        this.assignCustomer(c);
        this.m_bReceived = (Boolean)res[8];
        this.m_jtxtDescription.setText(Formats.STRING.formatValue(res[9]));
        this.m_timereservation.setEnabled(false);
        this.txtCustomer.setEnabled(false);
        this.m_jtxtDescription.setEnabled(false);
        this.m_jKeys.setEnabled(false);
        this.btnPay.setEnabled(false);
        this.m_jbtnReceive.setEnabled(false);
    }

    @Override
    public void writeValueEdit(Object value) {
        Object[] res = (Object[])value;
        this.m_sID = res[0];
        this.m_dCreated = (Date)res[1];
        this.m_timereservation.setCheckDates(this.m_dcurrentday, new Date(this.m_dcurrentday.getTime() + 3600000L));
        this.m_timereservation.setDate((Date)res[2]);
        CustomerInfo c = new CustomerInfo((String)res[3]);
        c.setTaxid((String)res[4]);
        c.setSearchkey((String)res[5]);
        c.setName((String)res[6]);
        this.assignCustomer(c);
        this.m_bReceived = (Boolean)res[8];
        this.m_jtxtDescription.setText(Formats.STRING.formatValue(res[9]));
        this.m_timereservation.setEnabled(true);
        this.txtCustomer.setEnabled(true);
        this.m_jtxtDescription.setEnabled(true);
        this.m_jKeys.setEnabled(true);
        this.btnPay.setEnabled(false);
        this.m_jbtnReceive.setEnabled(!this.m_bReceived);
        this.txtCustomer.activate();
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] res = new Object[]{this.m_sID == null ? UUID.randomUUID().toString() : this.m_sID, this.m_dCreated == null ? new Date() : this.m_dCreated, this.m_timereservation.getDate(), this.customer.getId(), this.customer.getTaxid(), this.customer.getSearchkey(), this.customer.getName(), 0, new Boolean(this.m_bReceived), this.m_jtxtDescription.getText()};
        return res;
    }

    private void reload(Date dDate) {
        if (!dDate.equals(this.m_dcurrentday)) {
            Date doldcurrentday = this.m_dcurrentday;
            this.m_dcurrentday = dDate;
            try {
                this.m_bd.actionLoad();
            }
            catch (BasicException eD) {
                MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.noreload"), eD);
                msg.show(this);
                this.m_dcurrentday = doldcurrentday;
            }
        }
        this.paintDate();
    }

    private void paintDate() {
        this.m_bpaintlock = true;
        this.m_datepanel.setDate(this.m_dcurrentday);
        this.m_timepanel.setDate(this.m_dcurrentday);
        this.m_bpaintlock = false;
    }

    private void assignCustomer(CustomerInfo c) {
        this.txtCustomer.setText(c.getName());
        this.customer = c;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jPanelDate = new JPanel();
        this.jPanelTime = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jToolbarContainer = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jbtnTables = new JButton();
        this.m_jbtnReceive = new JButton();
        this.m_jToolbar = new JPanel();
        this.m_jPanelList = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jPanelTime = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.m_jtxtDescription = new JEditorString();
        this.txtCustomer = new JEditorString();
        this.jButton1 = new JButton();
        this.btnPay = new JButton();
        this.jPanel5 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(10, 210));
        this.jPanelDate.setPreferredSize(new Dimension(410, 190));
        this.jPanelDate.setLayout(new BorderLayout());
        this.jPanel3.add(this.jPanelDate);
        this.jPanelTime.setPreferredSize(new Dimension(310, 190));
        this.jPanelTime.setLayout(new BorderLayout());
        this.jPanel3.add(this.jPanelTime);
        this.add((Component)this.jPanel3, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.m_jToolbarContainer.setLayout(new BorderLayout());
        this.m_jbtnTables.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/tablesmall.png")));
        this.m_jbtnTables.setText(AppLocal.getIntString("Menu.Products"));
        this.m_jbtnTables.setFocusPainted(false);
        this.m_jbtnTables.setFocusable(false);
        this.m_jbtnTables.setPreferredSize(new Dimension(83, 25));
        this.m_jbtnTables.setRequestFocusEnabled(false);
        this.m_jbtnTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBooking.this.m_jbtnTablesActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jbtnTables);
        this.m_jbtnReceive.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/mime.png")));
        this.m_jbtnReceive.setText(AppLocal.getIntString("button.receive"));
        this.m_jbtnReceive.setFocusPainted(false);
        this.m_jbtnReceive.setFocusable(false);
        this.m_jbtnReceive.setPreferredSize(new Dimension(90, 25));
        this.m_jbtnReceive.setRequestFocusEnabled(false);
        this.m_jbtnReceive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBooking.this.m_jbtnReceiveActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jbtnReceive);
        this.m_jToolbarContainer.add((Component)this.jPanel4, "Before");
        this.m_jToolbarContainer.add((Component)this.m_jToolbar, "Center");
        this.jPanel2.add((Component)this.m_jToolbarContainer, "North");
        this.m_jPanelList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanelList.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.m_jPanelList, "Before");
        this.jPanel1.setLayout(null);
        this.m_jPanelTime.setLayout(new BorderLayout());
        this.jPanel1.add(this.m_jPanelTime);
        this.m_jPanelTime.setBounds(90, 10, 240, 130);
        this.jLabel1.setText(AppLocal.getIntString("rest.label.date"));
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 80, 14);
        this.jLabel2.setText(AppLocal.getIntString("rest.label.customer"));
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(10, 150, 80, 14);
        this.jLabel4.setText(AppLocal.getIntString("rest.label.notes"));
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(10, 180, 80, 14);
        this.jPanel1.add(this.m_jtxtDescription);
        this.m_jtxtDescription.setBounds(90, 180, 220, 70);
        this.jPanel1.add(this.txtCustomer);
        this.txtCustomer.setBounds(90, 150, 220, 20);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/kuser.png")));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBooking.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton1.setBounds(310, 150, 40, 30);
        this.btnPay.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/greenled.png")));
        this.btnPay.setText(AppLocal.getIntString("button.receivedebt"));
        this.btnPay.setFocusPainted(false);
        this.btnPay.setFocusable(false);
        this.btnPay.setMargin(new Insets(8, 14, 8, 14));
        this.btnPay.setRequestFocusEnabled(false);
        this.btnPay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBooking.this.btnPayActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnPay);
        this.btnPay.setBounds(90, 270, 140, 34);
        this.jPanel2.add((Component)this.jPanel1, "Center");
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.add((Component)this.m_jKeys, "North");
        this.jPanel2.add((Component)this.jPanel5, "After");
        this.add((Component)this.jPanel2, "Center");
    }

    private void m_jbtnReceiveActionPerformed(ActionEvent evt) {
        this.m_bReceived = true;
        this.m_Dirty.setDirty(true);
        try {
            this.m_bd.saveData();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nosaveticket"), eD);
            msg.show(this);
        }
    }

    private void m_jbtnTablesActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlCustomers);
        finder.search(this.customer);
        finder.setVisible(true);
        CustomerInfo c = finder.getSelectedCustomer();
        if (c == null) {
            this.assignCustomer(new CustomerInfo(null));
            this.btnPay.setEnabled(false);
        } else {
            this.assignCustomer(c);
            this.btnPay.setEnabled(true);
        }
    }

    private void printTicket(String resname, TicketInfo ticket, CustomerInfoExt customer) {
        String resource = this.dlSystem.getResourceAsXML(resname);
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", ticket);
                script.put("customer", customer);
                this.ttp.printTicket(script.eval(resource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    private void btnPayActionPerformed(ActionEvent evt) {
        if (this.customer != null) {
            this.paymentdialog.setPrintSelected(true);
            if (this.paymentdialog.showDialog(100.0, null, "customer")) {
                CustomerInfoExt c;
                MessageInf msg;
                TicketInfo ticket = new TicketInfo();
                ticket.setTicketType(2);
                List<PaymentInfo> payments = this.paymentdialog.getSelectedPayments();
                double total = 0.0;
                for (PaymentInfo p : payments) {
                    total += p.getTotal();
                }
                payments.add(new PaymentInfoTicket(-total, "advancepaid"));
                ticket.setPayments(payments);
                ticket.setUser(this.app.getAppUserView().getUser().getUserInfo());
                ticket.setActiveCash(this.app.getActiveCashIndex());
                ticket.setDate(new Date());
                try {
                    this.dlSales.saveTicket(ticket, this.app.getInventoryLocation(), this.app.getReceiptHost());
                }
                catch (BasicException eData) {
                    msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosaveticket"), eData);
                    msg.show(this);
                }
                try {
                    c = this.dlSales.loadCustomerExt(this.customer.getId());
                    if (c == null) {
                        msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"));
                        msg.show(this);
                    }
                }
                catch (BasicException ex) {
                    c = null;
                    MessageInf msg2 = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), ex);
                    msg2.show(this);
                }
                this.printTicket(this.paymentdialog.isPrintSelected() ? "Printer.CustomerPaid" : "Printer.CustomerPaid2", ticket, c);
            }
        }
    }

    private class DateChangeTimeListener
    implements PropertyChangeListener {
        private DateChangeTimeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!JBooking.this.m_bpaintlock) {
                JBooking.this.reload(DateUtils.getTodayHours(DateUtils.getDate(JBooking.this.m_datepanel.getDate(), JBooking.this.m_timepanel.getDate())));
            }
        }
    }

    private class DateChangeCalendarListener
    implements PropertyChangeListener {
        private DateChangeCalendarListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!JBooking.this.m_bpaintlock) {
                JBooking.this.reload(DateUtils.getTodayHours(DateUtils.getDate(JBooking.this.m_datepanel.getDate(), JBooking.this.m_timepanel.getDate())));
            }
        }
    }

    private static class CompareReservations
    implements Comparator {
        private CompareReservations() {
        }

        public int compare(Object o1, Object o2) {
            Object[] a1 = (Object[])o1;
            Date d1 = (Date)a1[2];
            Object[] a2 = (Object[])o2;
            Date d2 = (Date)a2[2];
            int c = d1.compareTo(d2);
            if (c == 0) {
                d1 = (Date)a1[1];
                d2 = (Date)a2[1];
                return d1.compareTo(d2);
            }
            return c;
        }
    }

    private class MyDateFilter
    implements EditorCreator {
        private MyDateFilter() {
        }

        @Override
        public Object createValue() throws BasicException {
            return new Object[]{JBooking.this.m_dcurrentday, new Date(JBooking.this.m_dcurrentday.getTime() + 3600000L)};
        }
    }
}

