/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.data.loader.LocalRes;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppUser;
import com.posics.pos.forms.AppView;
import com.posics.pos.sales.JPanelTicket;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JPanelButtons
extends JPanel {
    private static Logger logger = Logger.getLogger("com.posics.pos.sales.JPanelButtons");
    private static SAXParser m_sp = null;
    private Properties props;
    private Map<String, String> events;
    private ThumbNailBuilder tnbmacro;
    private JPanelTicket panelticket;
    private AppView appview;

    public JPanelButtons(String sConfigKey, JPanelTicket panelticket, AppView app) {
        this.initComponents();
        this.tnbmacro = new ThumbNailBuilder(16, 16, "com/posics/images/greenled.png");
        this.panelticket = panelticket;
        this.appview = app;
        this.props = new Properties();
        this.events = new HashMap<String, String>();
        String sConfigRes = panelticket.getResourceAsXML(sConfigKey);
        if (sConfigRes != null) {
            try {
                if (m_sp == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    m_sp = spf.newSAXParser();
                }
                m_sp.parse(new InputSource(new StringReader(sConfigRes)), (DefaultHandler)new ConfigurationHandler());
            }
            catch (ParserConfigurationException ePC) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.parserconfig"), ePC);
            }
            catch (SAXException eSAX) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.xmlfile"), eSAX);
            }
            catch (IOException eIO) {
                logger.log(Level.WARNING, LocalRes.getIntString("exception.iofile"), eIO);
            }
        }
    }

    public void setPermissions(AppUser user) {
        for (Component c : this.getComponents()) {
            String sKey = c.getName();
            if (sKey == null || sKey.equals("")) {
                c.setEnabled(true);
                continue;
            }
            c.setVisible(user.hasPermission(c.getName()));
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultvalue) {
        return this.props.getProperty(key, defaultvalue);
    }

    public String getEvent(String key) {
        return this.events.get(key);
    }

    private void initComponents() {
    }

    private class JButtonFunc
    extends JButton {
        public JButtonFunc(String sKey, String sImage, String title) {
            this.setName(sKey);
            this.setText(title);
            this.setIcon(new ImageIcon(JPanelButtons.this.tnbmacro.getThumbNail(JPanelButtons.this.panelticket.getResourceAsImage(sImage))));
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(8, 14, 8, 14));
        }
    }

    private class ConfigurationHandler
    extends DefaultHandler {
        private ConfigurationHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("button".equals(qName)) {
                String template;
                String titlekey = attributes.getValue("titlekey");
                if (titlekey == null) {
                    titlekey = attributes.getValue("name");
                }
                String title = titlekey == null ? attributes.getValue("title") : AppLocal.getIntString(titlekey);
                JButtonFunc btn = new JButtonFunc(attributes.getValue("key"), attributes.getValue("image"), title);
                btn.setToolTipText(title);
                String sc = attributes.getValue("shortcut");
                if (sc != null) {
                    if (sc.equals("F9")) {
                        btn.setMnemonic(120);
                        btn.setToolTipText(title + " (F9)");
                    } else if (sc.equals("F10")) {
                        btn.setMnemonic(121);
                        btn.setToolTipText(title + " (F10)");
                    } else if (sc.equals("F11")) {
                        btn.setMnemonic(122);
                        btn.setToolTipText(title + " (F11)");
                    } else if (sc.equals("F12")) {
                        btn.setMnemonic(123);
                        btn.setToolTipText(title + " (F12)");
                    }
                }
                if ((template = attributes.getValue("template")) == null) {
                    final String code = attributes.getValue("code");
                    if (code == null) {
                        final String task = attributes.getValue("task");
                        if (task != null) {
                            if (task.equals("Print.LastTicket")) {
                                btn.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent evt) {
                                        JPanelButtons.this.panelticket.printLastTicket("Printer.TicketPreview");
                                    }
                                });
                            } else if (task.equals("Payment.Cash")) {
                                btn.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent evt) {
                                        JPanelButtons.this.panelticket.payCash();
                                    }
                                });
                            } else {
                                btn.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent evt) {
                                        JPanelButtons.this.appview.getAppUserView().showTask(task);
                                    }
                                });
                            }
                        }
                    } else {
                        btn.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                JPanelButtons.this.panelticket.evalScriptAndRefresh(code, new JPanelTicket.ScriptArg[0]);
                            }
                        });
                    }
                } else {
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            JPanelButtons.this.panelticket.printTicket(template);
                        }
                    });
                }
                JPanelButtons.this.add(btn);
            } else if ("event".equals(qName)) {
                JPanelButtons.this.events.put(attributes.getValue("key"), attributes.getValue("code"));
            } else {
                String value = attributes.getValue("value");
                if (value != null) {
                    JPanelButtons.this.props.setProperty(qName, attributes.getValue("value"));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }
}

