/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.beans.JFlowPanel;
import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorIntegerPositive;
import com.posics.editor.JEditorKeys;
import com.posics.format.Formats;
import com.posics.pos.catalog.JCatalogTab;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JPanelButtons;
import com.posics.pos.sales.JProductAttEdit;
import com.posics.pos.sales.UnPaidTicketInfo;
import com.posics.pos.sales.delivery.JOrderHistory;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;

public class JPanelMyTicketTracking
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private DataLogicSales m_dlSales = null;
    private DataLogicSystem m_dlSystem = null;
    protected DataLogicCustomers dlCustomers = null;
    private DataLogicReceipts dlReceipts = null;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private TicketParser m_TTP2;
    private AppView m_App;
    protected JPanelButtons m_jbtnconfig;
    private JCatalogTab jcurrTab;
    private ThumbNailBuilder tnbbutton;
    List<UnPaidTicketInfo> unpaidtickets = new ArrayList<UnPaidTicketInfo>();
    List<UnPaidTicketInfo> unpaidticketsSelected = new ArrayList<UnPaidTicketInfo>();
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRadioButton jradioAll;
    private JRadioButton jradioCurrent;
    private JPanel m_jButtons;
    private JEditorKeys m_jKeys;
    private JLabel m_jLblTotalEuros1;
    private JLabel m_jLblTotalEuros3;
    private JPanel m_jOptions;
    private JPanel m_jPanTotals;
    private JPanel m_jPanelTicket;
    private JButton m_jSearch;
    private JLabel m_jSelected;
    private JButton m_jSettlePayment1;
    private JButton m_jShowReceipt;
    private JEditorIntegerPositive m_jTicketEditor;
    private JLabel m_jTotal;

    public JPanelMyTicketTracking() {
        this.initComponents();
        this.m_jTicketEditor.addEditorKeys(this.m_jKeys);
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.m_dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlReceipts = (DataLogicReceipts)this.m_App.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.m_TP = new DeviceTicket();
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.Settlement");
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public void activate() throws BasicException {
        this.m_jTicketEditor.reset();
        this.m_jTicketEditor.activate();
        this.loadData();
        ButtonGroup group = new ButtonGroup();
        group.add(this.jradioCurrent);
        group.add(this.jradioAll);
    }

    private void loadData() {
        try {
            this.tnbbutton = new ThumbNailBuilder(170, 70, "com/posics/images/settlement.png");
            this.m_jPanelTicket.removeAll();
            this.jcurrTab = new JCatalogTab();
            this.jcurrTab.applyComponentOrientation(this.getComponentOrientation());
            this.m_jPanelTicket.add((Component)this.jcurrTab, "Center");
            this.unpaidtickets = new ArrayList<UnPaidTicketInfo>();
            this.unpaidticketsSelected = new ArrayList<UnPaidTicketInfo>();
            this.unpaidtickets = this.jradioCurrent.isSelected() ? this.dlReceipts.getMyUnPaidTicketList(this.m_App.getActiveCashIndex(), this.m_App.getAppUserView().getUser().getId()) : this.dlReceipts.getMyUnPaidTicketList(null, this.m_App.getAppUserView().getUser().getId());
            if (!this.unpaidtickets.isEmpty()) {
                for (int i = 0; i < this.unpaidtickets.size(); ++i) {
                    this.jcurrTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(null, this.unpaidtickets.get(i).getName())), new SelectedAction(this.unpaidtickets.get(i)), this.unpaidtickets.get(i).getName());
                    this.updateTotals();
                }
                this.m_jPanelTicket.add(this.jcurrTab);
                this.m_jPanelTicket.revalidate();
                this.m_jTicketEditor.reset();
                this.m_jTicketEditor.activate();
            }
        }
        catch (BasicException basicException) {
            // empty catch block
        }
        this.updateTotals();
    }

    private void printTicket(TicketInfo ticket) {
        this.m_TP.getDevicePrinter("1").reset();
        if (ticket != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", ticket);
                this.m_TTP.printTicket(script.eval(this.m_dlSystem.getResourceAsXML("Printer.TicketPreview")).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException eTP) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), eTP);
                msg.show(this);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.m_jOptions = new JPanel();
        this.m_jButtons = new JPanel();
        this.m_jSettlePayment1 = new JButton();
        this.m_jShowReceipt = new JButton();
        this.m_jSearch = new JButton();
        this.jradioCurrent = new JRadioButton();
        this.jradioAll = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.m_jPanelTicket = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel5 = new JPanel();
        this.jButton1 = new JButton();
        this.m_jTicketEditor = new JEditorIntegerPositive();
        this.jPanel1 = new JPanel();
        this.m_jPanTotals = new JPanel();
        this.m_jSelected = new JLabel();
        this.m_jLblTotalEuros1 = new JLabel();
        this.m_jTotal = new JLabel();
        this.m_jLblTotalEuros3 = new JLabel();
        this.setLayout(new BorderLayout());
        this.m_jOptions.setLayout(new BorderLayout());
        this.m_jButtons.setLayout(new FlowLayout(0));
        this.m_jSettlePayment1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/properties16.png")));
        this.m_jSettlePayment1.setText(AppLocal.getIntString("label.prodproperties"));
        this.m_jSettlePayment1.setFocusPainted(false);
        this.m_jSettlePayment1.setFocusable(false);
        this.m_jSettlePayment1.setMargin(new Insets(8, 14, 8, 14));
        this.m_jSettlePayment1.setRequestFocusEnabled(false);
        this.m_jSettlePayment1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelMyTicketTracking.this.m_jSettlePayment1ActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jSettlePayment1);
        this.m_jShowReceipt.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/orderhistory.png")));
        this.m_jShowReceipt.setText(AppLocal.getIntString("label.showreceipt"));
        this.m_jShowReceipt.setFocusPainted(false);
        this.m_jShowReceipt.setFocusable(false);
        this.m_jShowReceipt.setMargin(new Insets(8, 14, 8, 14));
        this.m_jShowReceipt.setRequestFocusEnabled(false);
        this.m_jShowReceipt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelMyTicketTracking.this.m_jShowReceiptActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jShowReceipt);
        this.m_jSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reload.png")));
        this.m_jSearch.setText(AppLocal.getIntString("button.reloadticket"));
        this.m_jSearch.setFocusPainted(false);
        this.m_jSearch.setFocusable(false);
        this.m_jSearch.setMargin(new Insets(8, 14, 8, 14));
        this.m_jSearch.setRequestFocusEnabled(false);
        this.m_jSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelMyTicketTracking.this.m_jSearchActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jSearch);
        this.jradioCurrent.setSelected(true);
        this.jradioCurrent.setText(AppLocal.getIntString("radio.currentsequence"));
        this.m_jButtons.add(this.jradioCurrent);
        this.jradioAll.setText(AppLocal.getIntString("radio.allsequence"));
        this.m_jButtons.add(this.jradioAll);
        this.m_jOptions.add((Component)this.m_jButtons, "West");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.m_jOptions.add((Component)this.jPanel2, "Center");
        this.add((Component)this.m_jOptions, "North");
        this.m_jPanelTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanelTicket.setLayout(new BorderLayout());
        this.add((Component)this.m_jPanelTicket, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.m_jKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelMyTicketTracking.this.m_jKeysActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jKeys);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setMargin(new Insets(8, 14, 8, 14));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelMyTicketTracking.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel5.add((Component)this.jButton1, gridBagConstraints);
        this.m_jTicketEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelMyTicketTracking.this.m_jTicketEditorKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.m_jTicketEditor, gridBagConstraints);
        this.jPanel4.add(this.jPanel5);
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.m_jPanTotals.setPreferredSize(new Dimension(200, 72));
        this.m_jSelected.setFont(new Font("Dialog", 1, 18));
        this.m_jSelected.setForeground(new Color(204, 0, 0));
        this.m_jSelected.setHorizontalAlignment(11);
        this.m_jSelected.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jSelected.setOpaque(true);
        this.m_jSelected.setPreferredSize(new Dimension(150, 25));
        this.m_jSelected.setRequestFocusEnabled(false);
        this.m_jLblTotalEuros1.setText(AppLocal.getIntString("label.totalcash"));
        this.m_jTotal.setHorizontalAlignment(11);
        this.m_jTotal.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotal.setOpaque(true);
        this.m_jTotal.setPreferredSize(new Dimension(150, 25));
        this.m_jTotal.setRequestFocusEnabled(false);
        this.m_jLblTotalEuros3.setText(AppLocal.getIntString("label.subtotalcash"));
        GroupLayout m_jPanTotalsLayout = new GroupLayout((Container)this.m_jPanTotals);
        this.m_jPanTotals.setLayout((LayoutManager)m_jPanTotalsLayout);
        m_jPanTotalsLayout.setHorizontalGroup((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros3).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.m_jSelected, -2, -1, -2)).add(2, (GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros1).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.m_jTotal, -2, -1, -2))).addContainerGap()));
        m_jPanTotalsLayout.setVerticalGroup((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((Component)this.m_jTotal, -2, -1, -2).add((Component)this.m_jLblTotalEuros1)).addPreferredGap(0).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((Component)this.m_jSelected, -2, -1, -2).add((Component)this.m_jLblTotalEuros3)).addContainerGap()));
        this.jPanel1.add(this.m_jPanTotals);
        this.jPanel3.add((Component)this.jPanel1, "Center");
        this.add((Component)this.jPanel3, "East");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.readTicket(this.m_jTicketEditor.getValueInteger(), 0);
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), e);
            msg.show(this);
            this.m_jTicketEditor.reset();
            this.m_jTicketEditor.activate();
        }
    }

    private void m_jKeysActionPerformed(ActionEvent evt) {
        try {
            this.readTicket(this.m_jTicketEditor.getValueInteger(), 0);
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), e);
            msg.show(this);
            this.m_jTicketEditor.reset();
            this.m_jTicketEditor.activate();
        }
    }

    private void m_jSearchActionPerformed(ActionEvent evt) {
        this.loadData();
    }

    private void m_jTicketEditorKeyTyped(KeyEvent evt) {
    }

    private void m_jSettlePayment1ActionPerformed(ActionEvent evt) {
        if (StringUtils.m_blTicketProperties && this.unpaidticketsSelected.size() > 0) {
            for (int i = 0; i < this.unpaidticketsSelected.size(); ++i) {
                try {
                    TicketInfo ticket = this.m_dlSales.loadTicket(0, this.unpaidticketsSelected.get(i).getTicketId());
                    JProductAttEdit attedit = JProductAttEdit.getAttributesEditor(this, this.m_App.getSession());
                    attedit.editTicketAttributes("-1", ticket);
                    attedit.setVisible(true);
                    if (!attedit.isOK()) continue;
                    try {
                        ByteArrayOutputStream o = new ByteArrayOutputStream();
                        ticket.getProperties().storeToXML((OutputStream)o, "Saleculator PDA", "UTF-8");
                        this.dlReceipts.setReceiptAttributes(this.unpaidticketsSelected.get(i).getId(), o);
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                catch (BasicException ex) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindattributes"), ex);
                    msg.show(this);
                }
            }
        }
    }

    private void m_jShowReceiptActionPerformed(ActionEvent evt) {
        try {
            for (int i = 0; i < this.unpaidticketsSelected.size(); ++i) {
                if (this.unpaidticketsSelected.get(i).getTicketId() <= 0) continue;
                JOrderHistory lastorder = JOrderHistory.getOrderHistory(this, this.m_dlSystem, this.m_dlSales.loadTicket(0, this.unpaidticketsSelected.get(i).getTicketId()));
                lastorder.setVisible(true);
            }
        }
        catch (Exception ex) {
            MessageInf msg = new MessageInf(-33554432, "Error loading receipt.", ex);
            msg.show(this);
            System.err.println(ex.getMessage());
        }
    }

    private void readTicket(int iTicketid, int iTickettype) {
        Boolean blFound = false;
        for (int j = 0; j < this.unpaidtickets.size(); ++j) {
            if (this.unpaidtickets.get(j).getTicketId() != iTicketid) continue;
            blFound = true;
            JScrollPane jct = (JScrollPane)this.jcurrTab.getComponent(0);
            JViewport jwt = (JViewport)jct.getComponent(0);
            JFlowPanel jfp = (JFlowPanel)jwt.getComponent(0);
            for (int i = 0; i < jfp.getComponentCount(); ++i) {
                JButton jb = (JButton)jfp.getComponent(i);
                if (!jb.getToolTipText().contains("<html><center>" + iTicketid + "<br>")) continue;
                if (jb.getBackground() != Color.ORANGE) {
                    this.unpaidticketsSelected.add(this.unpaidtickets.get(j));
                    jb.setBackground(Color.ORANGE);
                    jb.requestFocus();
                    jb.scrollRectToVisible(jb.getBounds());
                } else {
                    this.unpaidticketsSelected.remove(this.unpaidtickets.get(j));
                    jb.setBackground(null);
                    jb.requestFocus();
                    jb.scrollRectToVisible(jb.getBounds());
                }
                this.updateTotals();
            }
        }
        if (!blFound.booleanValue()) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), null);
            msg.show(this);
        }
        this.m_jTicketEditor.reset();
        this.m_jTicketEditor.activate();
    }

    private void updateTotals() {
        int i;
        this.m_jTotal.setText("");
        this.m_jSelected.setText("");
        if (this.unpaidtickets != null && this.unpaidtickets.size() > 0) {
            Double total = 0.0;
            for (i = 0; i < this.unpaidtickets.size(); ++i) {
                total = total + this.unpaidtickets.get(i).getAmount();
            }
            this.m_jTotal.setText(Formats.CURRENCY.formatValue(total));
        }
        if (this.unpaidticketsSelected != null && this.unpaidticketsSelected.size() > 0) {
            Double totalSelected = 0.0;
            for (i = 0; i < this.unpaidticketsSelected.size(); ++i) {
                totalSelected = totalSelected + this.unpaidticketsSelected.get(i).getAmount();
            }
            this.m_jSelected.setText(Formats.CURRENCY.formatValue(totalSelected));
        }
    }

    private class SelectedAction
    implements ActionListener {
        private UnPaidTicketInfo ticket;

        public SelectedAction(UnPaidTicketInfo ticket) {
            this.ticket = ticket;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton jb = (JButton)e.getSource();
            if (jb.getBackground() != Color.ORANGE) {
                JPanelMyTicketTracking.this.unpaidticketsSelected.add(this.ticket);
                JScrollPane jct = (JScrollPane)JPanelMyTicketTracking.this.jcurrTab.getComponent(0);
                JViewport jwt = (JViewport)jct.getComponent(0);
                JFlowPanel jfp = (JFlowPanel)jwt.getComponent(0);
                jb.setBackground(Color.ORANGE);
            } else {
                JPanelMyTicketTracking.this.unpaidticketsSelected.remove(this.ticket);
                jb.setBackground(null);
                jb.requestFocus();
                jb.scrollRectToVisible(jb.getBounds());
            }
            JPanelMyTicketTracking.this.updateTotals();
        }
    }
}

