/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.beans.JAlphabetKeys;
import com.posics.beans.JNumberDialog;
import com.posics.beans.JNumberEvent;
import com.posics.beans.JNumberEventListener;
import com.posics.beans.JNumberKeys;
import com.posics.beans.JTextDialog;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.gui.ListKeyed;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.SentenceList;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.customers.JCustomerFinder;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.BeanFactoryApp;
import com.posics.pos.forms.BeanFactoryException;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.JPanelView;
import com.posics.pos.inventory.TaxCategoryInfo;
import com.posics.pos.panels.JProductFinder;
import com.posics.pos.payment.JPaymentSelect;
import com.posics.pos.payment.JPaymentSelectReceipt;
import com.posics.pos.payment.JPaymentSelectRefund;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.sales.JPanelButtons;
import com.posics.pos.sales.JProductAttEdit;
import com.posics.pos.sales.JProductLineEdit;
import com.posics.pos.sales.JTicketLines;
import com.posics.pos.sales.JTicketsBag;
import com.posics.pos.sales.JTicketsBagTicketBag;
import com.posics.pos.sales.ReceiptSplit;
import com.posics.pos.sales.SelectTariff;
import com.posics.pos.sales.TaxesException;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.TicketsEditor;
import com.posics.pos.sales.delivery.DriverInfo;
import com.posics.pos.sales.delivery.SelectDriver;
import com.posics.pos.sales.shared.JTicketsBagShared;
import com.posics.pos.sales.simple.JTicketsBagSimple;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.ProductInfoBasic;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TariffInfo;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.util.JRPrinterAWT300;
import com.posics.pos.util.ReportUtils;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.jdesktop.layout.GroupLayout;

public abstract class JPanelTicketP
extends JPanel
implements JPanelView,
BeanFactoryApp,
TicketsEditor {
    private static final int NUMBERZERO = 0;
    private static final int NUMBERVALID = 1;
    private static final int NUMBER_INPUTZERO = 0;
    private static final int NUMBER_INPUTZERODEC = 1;
    private static final int NUMBER_INPUTINT = 2;
    private static final int NUMBER_INPUTDEC = 3;
    private static final int NUMBER_PORZERO = 4;
    private static final int NUMBER_PORZERODEC = 5;
    private static final int NUMBER_PORINT = 6;
    private static final int NUMBER_PORDEC = 7;
    protected JTicketLines m_ticketlines;
    private TicketParser m_TTP;
    protected TicketInfo m_oTicket;
    protected Object m_oTicketExt;
    private int m_iNumberStatus;
    private int m_iNumberStatusInput;
    private int m_iNumberStatusPor;
    private StringBuffer m_sBarcode;
    private JTicketsBag m_ticketsbag;
    private SentenceList senttax;
    private SentenceList senttaxcategories;
    private ListKeyed taxcategoriescollection;
    private ComboBoxValModel taxcategoriesmodel;
    private ListKeyed taxcollection;
    private TaxesLogic taxeslogic;
    protected JPanelButtons m_jbtnconfig;
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    protected DataLogicSales dlSales;
    protected DataLogicCustomers dlCustomers;
    private JPaymentSelect paymentdialogreceipt;
    private JPaymentSelect paymentdialogrefund;
    private ComboBoxValModel m_TariffModel;
    private boolean m_PriceEmbedded;
    private boolean m_WeightEmbedded;
    private boolean m_QtyEmbedded;
    private boolean m_CustomerEmbedded;
    private String m_PriceEmbeddedCode;
    private String m_WeightEmbeddedCode;
    private String m_QtyEmbeddedCode;
    private String m_CustomerCode;
    private boolean m_EditClosedTicket = false;
    private boolean m_ShowProductsPopup = false;
    private List plist;
    SelectDriver selectdriver;
    private JButton btnCustomer;
    private JButton btnSplit;
    private JButton btnTariff;
    private JPanel catcontainer;
    private JPanel catcontainer2;
    private JAlphabetKeys jAlphabetKeys1;
    private JButton jEditAttributes;
    private JLabel jLabel5;
    private JPanel jLblPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel jlblStatus;
    private JButton m_Equal;
    private JPanel m_jButtons;
    private JPanel m_jButtonsExt;
    private JPanel m_jContEntries;
    private JButton m_jDelete;
    private JButton m_jDown;
    private JButton m_jEditLine;
    private JButton m_jEnter;
    private JLabel m_jItems;
    private JTextField m_jKeyFactory;
    private JLabel m_jLblTotalEuros1;
    private JLabel m_jLblTotalEuros2;
    private JLabel m_jLblTotalEuros3;
    private JLabel m_jLblTotalEuros4;
    private JButton m_jList;
    private JNumberKeys m_jNumberKeys;
    private JPanel m_jOptions;
    private JPanel m_jPanContainer;
    private JPanel m_jPanEntries;
    private JPanel m_jPanTicket;
    private JPanel m_jPanTotals;
    private JPanel m_jPanelBag;
    private JPanel m_jPanelCentral;
    private JPanel m_jPanelScripts;
    private JLabel m_jPor;
    private JLabel m_jPrice;
    private JLabel m_jSubtotalEuros;
    private JPanel m_jTariffPanel;
    private JComboBox m_jTax;
    private JLabel m_jTaxesEuros;
    private JLabel m_jTicketId;
    private JLabel m_jTotalDiscounts;
    private JLabel m_jTotalEuros;
    private JButton m_jUp;
    private JToggleButton m_jaddtax;
    private JButton m_jbtnScale;

    public JPanelTicketP() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.m_ticketsbag = this.getJTicketsBag();
        this.m_jPanelBag.add((Component)this.m_ticketsbag.getBagComponent(), "Before");
        this.add((Component)this.m_ticketsbag.getNullComponent(), "null");
        this.m_ticketlines = new JTicketLines(this.dlSystem.getResourceAsXML("Ticket.Line"));
        this.m_jPanelCentral.add((Component)this.m_ticketlines, "Center");
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.dlSystem);
        this.m_jbtnconfig = new JPanelButtons("Ticket.Buttons", null, this.m_App);
        this.m_jButtonsExt.add(this.m_jbtnconfig);
        this.catcontainer2.add(this.getSouthComponent(), "Center");
        this.senttax = this.dlSales.getTaxList();
        this.senttaxcategories = this.dlSales.getTaxCategoriesList();
        this.taxcategoriesmodel = new ComboBoxValModel();
        this.stateToZero();
        this.m_oTicket = null;
        this.m_oTicketExt = null;
        this.m_jDelete.setMnemonic(127);
        this.m_jTicketId.setVisible(false);
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        this.paymentdialogreceipt = JPaymentSelectReceipt.getDialog(this);
        this.paymentdialogreceipt.init(this.m_App);
        this.paymentdialogrefund = JPaymentSelectRefund.getDialog(this);
        this.paymentdialogrefund.init(this.m_App);
        this.m_jaddtax.setSelected("true".equals(this.m_jbtnconfig.getProperty("taxesincluded")));
        List taxlist = this.senttax.list();
        this.taxcollection = new ListKeyed(taxlist);
        List taxcategorieslist = this.senttaxcategories.list();
        this.taxcategoriescollection = new ListKeyed(taxcategorieslist);
        this.taxcategoriesmodel = new ComboBoxValModel(taxcategorieslist);
        this.m_jTax.setModel(this.taxcategoriesmodel);
        String taxesid = this.m_jbtnconfig.getProperty("taxcategoryid");
        if (taxesid == null) {
            if (this.m_jTax.getItemCount() > 0) {
                this.m_jTax.setSelectedIndex(0);
            }
        } else {
            this.taxcategoriesmodel.setSelectedKey(taxesid);
        }
        this.taxeslogic = new TaxesLogic(taxlist);
        if (this.m_App.getAppUserView().getUser().hasPermission("sales.ChangeTaxOptions")) {
            this.m_jTax.setVisible(true);
            this.m_jaddtax.setVisible(true);
        } else {
            this.m_jTax.setVisible(false);
            this.m_jaddtax.setVisible(false);
        }
        if (this.dlSales.getTariffAreaList().size() > 0) {
            this.m_jTariffPanel.setVisible(true);
            this.btnTariff.setVisible(true);
        } else {
            this.m_jTariffPanel.setVisible(false);
            this.btnTariff.setVisible(false);
        }
        String priceembedded = this.m_jbtnconfig.getProperty("priceembedded");
        if (priceembedded == null) {
            this.m_PriceEmbedded = false;
            this.m_PriceEmbeddedCode = null;
        } else {
            this.m_PriceEmbedded = true;
            this.m_PriceEmbeddedCode = priceembedded;
        }
        String weightembedded = this.m_jbtnconfig.getProperty("weightembedded");
        if (weightembedded == null) {
            this.m_WeightEmbedded = false;
            this.m_WeightEmbeddedCode = null;
        } else {
            this.m_WeightEmbedded = true;
            this.m_WeightEmbeddedCode = weightembedded;
        }
        String qtyembedded = this.m_jbtnconfig.getProperty("quantityembedded");
        if (qtyembedded == null) {
            this.m_QtyEmbedded = false;
            this.m_QtyEmbeddedCode = null;
        } else {
            this.m_QtyEmbedded = true;
            this.m_QtyEmbeddedCode = qtyembedded;
        }
        String customerembedded = this.m_jbtnconfig.getProperty("customerembedded");
        if (customerembedded == null) {
            this.m_CustomerEmbedded = false;
            this.m_CustomerCode = null;
        } else {
            this.m_CustomerEmbedded = true;
            this.m_CustomerCode = customerembedded;
        }
        if ("true".equals(this.m_jbtnconfig.getProperty("showproductspopup"))) {
            this.m_ShowProductsPopup = true;
            this.plist = this.dlSales.getProductsList().list();
        }
        this.btnSplit.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.Split"));
        this.m_jDelete.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.DeleteLines"));
        this.m_jEditLine.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines"));
        this.m_jNumberKeys.setMinusEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines"));
        this.m_jNumberKeys.setEqualsEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.Total"));
        this.m_jbtnconfig.setPermissions(this.m_App.getAppUserView().getUser());
        this.m_ticketsbag.activate();
    }

    @Override
    public boolean deactivate() {
        return this.m_ticketsbag.deactivate();
    }

    protected abstract JTicketsBag getJTicketsBag();

    protected abstract Component getSouthComponent();

    protected abstract void resetSouthComponent();

    public void setEditClosedticket(boolean blValue) {
        this.m_EditClosedTicket = blValue;
    }

    @Override
    public void setActiveTicket(TicketInfo oTicket, Object oTicketExt) {
        this.m_oTicket = oTicket;
        this.m_oTicketExt = oTicketExt;
        this.selectdriver = null;
        if (this.m_oTicket != null) {
            this.m_oTicket.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
            this.m_oTicket.setHost(this.m_App.getProperties().getMachineName());
            if (!this.m_EditClosedTicket) {
                this.m_oTicket.setActiveCash(this.m_App.getActiveCashIndex());
                this.m_oTicket.setDate(new Date());
            }
        }
        this.executeEvent(this.m_oTicket, this.m_oTicketExt, "ticket.show", new ScriptArg[0]);
        this.refreshTicket();
    }

    @Override
    public TicketInfo getActiveTicket() {
        return this.m_oTicket;
    }

    private void refreshTicket() {
        CardLayout cl = (CardLayout)this.getLayout();
        if (this.m_oTicket == null) {
            this.m_jTicketId.setText(null);
            this.m_ticketlines.clearTicketLines();
            this.m_jSubtotalEuros.setText(null);
            this.m_jTaxesEuros.setText(null);
            this.m_jTotalEuros.setText(null);
            this.m_jTotalDiscounts.setText(null);
            this.m_jItems.setText(AppLocal.getIntString("label.linescount") + ": 0");
            this.stateToZero();
            cl.show(this, "null");
            this.resetSouthComponent();
        } else {
            if (this.m_oTicket.getTicketType() == 1) {
                this.m_jEditLine.setVisible(false);
                this.m_jList.setVisible(false);
            }
            for (TicketLineInfo line : this.m_oTicket.getLines()) {
                line.setTaxInfo(this.taxeslogic.getTaxInfo(line.getProductTaxCategoryID(), this.m_oTicket.getCustomer()));
            }
            this.m_jTicketId.setText(this.m_oTicket.getName(this.m_oTicketExt));
            this.m_ticketlines.clearTicketLines();
            for (int i = 0; i < this.m_oTicket.getLinesCount(); ++i) {
                this.m_ticketlines.addTicketLine(this.m_oTicket.getLine(i));
            }
            if (this.m_oTicket.getProperty("TariffArea") != null) {
                this.btnTariff.setText(AppLocal.getIntString("Menu.TariffArea") + " - " + this.m_oTicket.getProperty("TariffArea"));
            } else {
                this.btnTariff.setText(AppLocal.getIntString("Menu.TariffArea"));
            }
            this.printPartialTotals();
            this.stateToZero();
            cl.show(this, "ticket");
            this.resetSouthComponent();
            this.m_jKeyFactory.setText(null);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPanelTicketP.this.m_jKeyFactory.requestFocus();
                }
            });
        }
    }

    private void printPartialTotals() {
        if (this.m_oTicket.getLinesCount() == 0) {
            this.m_jSubtotalEuros.setText(null);
            this.m_jTaxesEuros.setText(null);
            this.m_jTotalEuros.setText(null);
            this.m_jTotalDiscounts.setText(null);
            this.m_jItems.setText(AppLocal.getIntString("label.linescount") + ": 0");
        } else {
            this.m_jSubtotalEuros.setText(this.m_oTicket.printSubTotal());
            this.m_jTaxesEuros.setText(this.m_oTicket.printTax());
            if (this.m_oTicket.getTotalDiscount() > 0.0) {
                this.m_jTotalDiscounts.setText(this.m_oTicket.printTotalDiscount());
            } else {
                this.m_jTotalDiscounts.setText(Formats.CURRENCY.formatValue(0));
            }
            this.m_jTotalEuros.setText(this.m_oTicket.printTotal());
            this.m_jItems.setText(AppLocal.getIntString("label.linescount") + ": " + this.m_oTicket.getLinesCount());
        }
        super.repaint();
    }

    private void paintTicketLine(int index, TicketLineInfo oLine) {
        if (this.executeEventAndRefresh("ticket.setline", new ScriptArg("index", index), new ScriptArg("line", oLine)) == null) {
            this.m_oTicket.setLine(index, oLine);
            this.m_ticketlines.setTicketLine(index, oLine);
            this.m_ticketlines.setSelectedIndex(index);
            this.visorTicketLine(oLine);
            this.printPartialTotals();
            this.stateToZero();
            this.executeEventAndRefresh("ticket.change", new ScriptArg[0]);
        }
    }

    private void addTicketLine(ProductInfoExt oProduct, double dMul, double dPrice) {
        TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
        this.addTicketLine(new TicketLineInfo(oProduct, dMul, dPrice, tax, (Properties)oProduct.getProperties().clone()));
    }

    protected void addTicketLine(TicketLineInfo oLine) {
        int i = this.m_ticketlines.getSelectedIndex();
        if (this.executeEventAndRefresh("ticket.addline", new ScriptArg("line", oLine), new ScriptArg("index", i)) == null) {
            Double tariffPrice;
            if (this.m_oTicket.getProperty("TariffID") != null && oLine.getProductID() != null && (tariffPrice = this.getProductTariffPrice(this.m_oTicket.getProperty("TariffID"), oLine.getProductID())) != null) {
                oLine.setSalePrice(tariffPrice);
            }
            if (oLine.isProductCom()) {
                if (i >= 0 && !this.m_oTicket.getLine(i).isProductCom()) {
                    ++i;
                }
                while (i >= 0 && i < this.m_oTicket.getLinesCount() && this.m_oTicket.getLine(i).isProductCom()) {
                    ++i;
                }
                if (i >= 0) {
                    this.m_oTicket.insertLine(i, oLine);
                    this.m_ticketlines.insertTicketLine(i, oLine);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                this.m_oTicket.addLine(oLine);
                this.m_ticketlines.addTicketLine(oLine);
            }
            this.visorTicketLine(oLine);
            this.printPartialTotals();
            this.stateToZero();
            this.executeEventAndRefresh("ticket.change", new ScriptArg[0]);
        }
    }

    private void removeTicketLine(int i) {
        if (this.executeEventAndRefresh("ticket.removeline", new ScriptArg("index", i)) == null) {
            if (this.m_oTicket.getLine(i).isProductCom()) {
                this.m_oTicket.removeLine(i);
                this.m_ticketlines.removeTicketLine(i);
            } else {
                this.m_oTicket.removeLine(i);
                this.m_ticketlines.removeTicketLine(i);
                while (i < this.m_oTicket.getLinesCount() && this.m_oTicket.getLine(i).isProductCom()) {
                    this.m_oTicket.removeLine(i);
                    this.m_ticketlines.removeTicketLine(i);
                }
            }
            this.visorTicketLine(null);
            this.printPartialTotals();
            this.stateToZero();
            this.executeEventAndRefresh("ticket.change", new ScriptArg[0]);
        }
    }

    private ProductInfoExt getInputProduct() {
        ProductInfoExt oProduct = new ProductInfoExt();
        oProduct.setReference(null);
        oProduct.setCode(null);
        oProduct.setName("");
        oProduct.setTaxCategoryID(((TaxCategoryInfo)this.taxcategoriesmodel.getSelectedItem()).getID());
        oProduct.setPriceSell(this.includeTaxes(oProduct.getTaxCategoryID(), this.getInputValue()));
        return oProduct;
    }

    private double includeTaxes(String tcid, double dValue) {
        if (this.m_jaddtax.isSelected()) {
            TaxInfo tax = this.taxeslogic.getTaxInfo(tcid, this.m_oTicket.getCustomer());
            double dTaxRate = tax == null ? 0.0 : tax.getRate();
            return dValue / (1.0 + dTaxRate);
        }
        return dValue;
    }

    private double getInputValue() {
        try {
            return Double.parseDouble(this.m_jPrice.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double getPorValue() {
        try {
            return Double.parseDouble(this.m_jPor.getText().substring(1));
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
        catch (StringIndexOutOfBoundsException e) {
            return 1.0;
        }
    }

    private void stateToZero() {
        this.m_jPor.setText("");
        this.m_jPrice.setText("");
        this.m_sBarcode = new StringBuffer();
        this.m_iNumberStatus = 0;
        this.m_iNumberStatusInput = 0;
        this.m_iNumberStatusPor = 0;
    }

    private void incProductByCode(String sCode) {
        try {
            ProductInfoExt oProduct = this.dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noproduct")).show(this);
                this.stateToZero();
            } else if (oProduct.inCatlog()) {
                this.incProduct(oProduct);
            } else {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noproductincatalog")).show(this);
                this.stateToZero();
            }
        }
        catch (BasicException eData) {
            this.stateToZero();
            new MessageInf(eData).show(this);
        }
    }

    private void incProductByCodePrice(String sCode, double dPriceSell) {
        try {
            ProductInfoExt oProduct = this.dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noproduct")).show(this);
                this.stateToZero();
            } else if (this.m_jaddtax.isSelected()) {
                TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
                this.addTicketLine(oProduct, 1.0, dPriceSell / (1.0 + tax.getRate()));
            } else {
                this.addTicketLine(oProduct, 1.0, dPriceSell);
            }
        }
        catch (BasicException eData) {
            this.stateToZero();
            new MessageInf(eData).show(this);
        }
    }

    private void incProductByCodeWeight(String sCode, double dWeight) {
        try {
            ProductInfoExt oProduct = this.dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noproduct")).show(this);
                this.stateToZero();
            } else {
                this.addTicketLine(oProduct, dWeight, oProduct.getPriceSell());
            }
        }
        catch (BasicException eData) {
            this.stateToZero();
            new MessageInf(eData).show(this);
        }
    }

    private void incProduct(ProductInfoExt prod) {
        this.incProduct(1.0, prod);
    }

    private void incProduct(double dPor, ProductInfoExt prod) {
        this.addTicketLine(prod, dPor, prod.getPriceSell());
    }

    protected void buttonTransition(ProductInfoExt prod) {
        if (this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
            this.incProduct(prod);
        } else if (this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0) {
            this.incProduct(this.getInputValue(), prod);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void stateTransition(char cTrans) {
        if (cTrans == '\n') {
            if (this.m_sBarcode.length() > 0) {
                String sCode = this.m_sBarcode.toString();
                if (this.m_CustomerEmbedded && sCode.startsWith(this.m_CustomerCode)) {
                    try {
                        CustomerInfoExt newcustomer = this.dlSales.findCustomerExt(sCode);
                        if (newcustomer == null) {
                            Toolkit.getDefaultToolkit().beep();
                            new MessageInf(-33554432, AppLocal.getIntString("message.nocustomer")).show(this);
                        } else {
                            this.m_oTicket.setCustomer(newcustomer);
                            this.m_jTicketId.setText(this.m_oTicket.getName(this.m_oTicketExt));
                            this.executeEventAndRefresh("ticket.customerchanged", new ScriptArg[0]);
                            this.refreshTicket();
                        }
                    }
                    catch (BasicException e) {
                        Toolkit.getDefaultToolkit().beep();
                        new MessageInf(-33554432, AppLocal.getIntString("message.nocustomer"), e).show(this);
                    }
                    this.stateToZero();
                } else if (sCode.length() >= 12 && this.m_PriceEmbedded && sCode.startsWith(this.m_PriceEmbeddedCode)) {
                    this.incProductByCodePrice(sCode.substring(0, 7), Double.parseDouble(sCode.substring(7, 12)) / 100.0);
                } else if (sCode.length() >= 12 && this.m_WeightEmbedded && sCode.startsWith(this.m_WeightEmbeddedCode)) {
                    this.incProductByCodeWeight(sCode.substring(0, 7), Double.parseDouble(sCode.substring(7, 12)) / 1000.0);
                } else if (sCode.length() >= 12 && this.m_QtyEmbedded && sCode.startsWith(this.m_QtyEmbeddedCode)) {
                    this.incProductByCodeWeight(sCode.substring(0, 7), Double.parseDouble(sCode.substring(7, 12)));
                } else {
                    this.incProductByCode(sCode);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            this.m_sBarcode.append(cTrans);
            if (this.m_ShowProductsPopup) {
                this.showProductPopup(this.m_sBarcode.toString());
            }
            if (!this.m_WeightEmbedded || !this.m_WeightEmbeddedCode.contains(String.valueOf(cTrans)) || this.m_iNumberStatusInput == 0) {
                if (cTrans == '\u007f') {
                    this.stateToZero();
                } else if (cTrans == '0' && this.m_iNumberStatus == 0) {
                    this.m_jPrice.setText("0");
                } else if ((cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 0) {
                    this.m_jPrice.setText(Character.toString(cTrans));
                    this.m_iNumberStatus = 2;
                    this.m_iNumberStatusInput = 1;
                } else if ((cTrans == '0' || cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 2) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                } else if (cTrans == '.' && this.m_iNumberStatus == 0) {
                    this.m_jPrice.setText("0.");
                    this.m_iNumberStatus = 1;
                } else if (cTrans == '.' && this.m_iNumberStatus == 2) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + ".");
                    this.m_iNumberStatus = 3;
                } else if (cTrans == '0' && (this.m_iNumberStatus == 1 || this.m_iNumberStatus == 3)) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                } else if (!(cTrans != '1' && cTrans != '2' && cTrans != '3' && cTrans != '4' && cTrans != '5' && cTrans != '6' && cTrans != '7' && cTrans != '8' && cTrans != '9' || this.m_iNumberStatus != 1 && this.m_iNumberStatus != 3)) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    this.m_iNumberStatus = 3;
                    this.m_iNumberStatusInput = 1;
                } else if (cTrans == '*' && (this.m_iNumberStatus == 2 || this.m_iNumberStatus == 3)) {
                    this.m_jPor.setText("x");
                    this.m_iNumberStatus = 4;
                } else if (cTrans == '*' && (this.m_iNumberStatus == 0 || this.m_iNumberStatus == 1)) {
                    this.m_jPrice.setText("0");
                    this.m_jPor.setText("x");
                    this.m_iNumberStatus = 4;
                } else if (cTrans == '0' && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x0");
                } else if ((cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x" + Character.toString(cTrans));
                    this.m_iNumberStatus = 6;
                    this.m_iNumberStatusPor = 1;
                } else if ((cTrans == '0' || cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 6) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                } else if (cTrans == '.' && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x0.");
                    this.m_iNumberStatus = 5;
                } else if (cTrans == '.' && this.m_iNumberStatus == 6) {
                    this.m_jPor.setText(this.m_jPor.getText() + ".");
                    this.m_iNumberStatus = 7;
                } else if (cTrans == '0' && (this.m_iNumberStatus == 5 || this.m_iNumberStatus == 7)) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                } else if (!(cTrans != '1' && cTrans != '2' && cTrans != '3' && cTrans != '4' && cTrans != '5' && cTrans != '6' && cTrans != '7' && cTrans != '8' && cTrans != '9' || this.m_iNumberStatus != 5 && this.m_iNumberStatus != 7)) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                    this.m_iNumberStatus = 7;
                    this.m_iNumberStatusPor = 1;
                } else if (cTrans != '\u00a7' || this.m_iNumberStatusInput != 1 || this.m_iNumberStatusPor != 0) {
                    if (cTrans == '\u00a7' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
                        int i = this.m_ticketlines.getSelectedIndex();
                        if (i < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else if (cTrans == '+' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
                        int i = this.m_ticketlines.getSelectedIndex();
                        if (i < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                            if (this.m_oTicket.getTicketType() == 1) {
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(newline.getMultiply() + 1.0);
                                this.paintTicketLine(i, newline);
                            }
                        }
                    } else if (cTrans == '-' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        int i = this.m_ticketlines.getSelectedIndex();
                        if (i < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                            if (this.m_oTicket.getTicketType() == 1) {
                                newline.setMultiply(newline.getMultiply() + 1.0);
                                if (newline.getMultiply() >= 0.0) {
                                    this.removeTicketLine(i);
                                } else {
                                    this.paintTicketLine(i, newline);
                                }
                            } else {
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                if (newline.getMultiply() <= 0.0) {
                                    this.removeTicketLine(i);
                                } else {
                                    this.paintTicketLine(i, newline);
                                }
                            }
                        }
                    } else if (cTrans == '+' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 1) {
                        int i = this.m_ticketlines.getSelectedIndex();
                        if (i < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            double dPor = this.getPorValue();
                            TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                            if (this.m_oTicket.getTicketType() == 1) {
                                newline.setMultiply(-dPor);
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(dPor);
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        }
                    } else if (cTrans == '-' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        int i = this.m_ticketlines.getSelectedIndex();
                        if (i < 0) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            double dPor = this.getPorValue();
                            TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                            if (this.m_oTicket.getTicketType() == 0) {
                                newline.setSalePrice(Math.abs(dPor));
                                this.paintTicketLine(i, newline);
                            }
                        }
                    } else if (cTrans == '+' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        ProductInfoExt product = this.getInputProduct();
                        this.addTicketLine(product, 1.0, product.getPriceSell());
                    } else if (cTrans == '-' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        ProductInfoExt product = this.getInputProduct();
                        this.addTicketLine(product, 1.0, -product.getPriceSell());
                    } else if (cTrans == '+' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        ProductInfoExt product = this.getInputProduct();
                        this.addTicketLine(product, this.getPorValue(), product.getPriceSell());
                    } else if (cTrans == '-' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        ProductInfoExt product = this.getInputProduct();
                        this.addTicketLine(product, this.getPorValue(), -product.getPriceSell());
                    } else if (cTrans == ' ' || cTrans == '=') {
                        if (this.m_oTicket.getLinesCount() > 0) {
                            if (this.closeTicket(this.m_oTicket, this.m_oTicketExt, false, "")) {
                                this.m_ticketsbag.deleteTicket();
                            } else {
                                this.refreshTicket();
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else {
                        this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    }
                }
            }
        }
    }

    private void showProductPopup(String pcode) {
        JPopupMenu popmenu = new JPopupMenu();
        ActionListener popupListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String[] itemcode = event.getActionCommand().split(" #");
                if (itemcode.length == 2) {
                    JPanelTicketP.this.incProductByCode(itemcode[1]);
                }
            }
        };
        for (int i = 0; i < this.plist.size(); ++i) {
            ProductInfoBasic pitem = (ProductInfoBasic)this.plist.get(i);
            if (!pitem.getCode().startsWith(pcode)) continue;
            JMenuItem item = new JMenuItem(pitem.getName());
            popmenu.add(item);
            item.addActionListener(popupListener);
            item.setBackground(Color.white);
        }
        popmenu.setFocusable(false);
        popmenu.show(this.m_jPrice, 0, 30);
    }

    private boolean closeTicket(TicketInfo ticket, Object ticketext, boolean isFastPay, String fastPayType) {
        boolean resultok = false;
        if (this.m_App.getAppUserView().getUser().hasPermission("sales.Total")) {
            try {
                this.taxeslogic.calculateTaxes(ticket);
                if (ticket.getTotal() >= 0.0) {
                    ticket.resetPayments();
                }
                if (this.executeEvent(ticket, ticketext, "ticket.total", new ScriptArg[0]) == null) {
                    String paymentFor;
                    JPaymentSelect paymentdialog;
                    this.printTicket("Printer.TicketTotal", ticket, ticketext);
                    if (ticket.getTicketType() == 0) {
                        paymentdialog = this.paymentdialogreceipt;
                        paymentFor = "receipt";
                    } else {
                        paymentdialog = this.paymentdialogrefund;
                        paymentFor = "refund";
                    }
                    paymentdialog.setPrintSelected("true".equals(this.m_jbtnconfig.getProperty("printselected", "true")));
                    paymentdialog.setTransactionID(ticket.getTransactionID());
                    if (isFastPay) {
                        paymentdialog.addFastPayment(ticket.getTotal(), fastPayType);
                    }
                    if (isFastPay || paymentdialog.showDialog(ticket.getTotal(), ticket.getCustomer(), paymentFor)) {
                        if (!isFastPay) {
                            ticket.setCustomer(paymentdialog.getCustomer());
                        }
                        ticket.setPayments(paymentdialog.getSelectedPayments());
                        ticket.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
                        if (!this.m_EditClosedTicket) {
                            ticket.setActiveCash(this.m_App.getActiveCashIndex());
                            ticket.setDate(new Date());
                        }
                        if (this.executeEvent(ticket, ticketext, "ticket.save", new ScriptArg[0]) == null) {
                            if (this.selectdriver != null && this.selectdriver.getDriver() != null || ticket.getProperty("DeliveryOrder") != null) {
                                String deliveryid = "";
                                boolean isDelivery = false;
                                if (ticket.getProperty("DeliveryOrder") != null) {
                                    deliveryid = ticket.getProperty("DeliveryOrder");
                                    isDelivery = true;
                                } else {
                                    deliveryid = UUID.randomUUID().toString();
                                    ticket.setProperty("DeliveryOrder", deliveryid);
                                }
                                if (ticket.getProperty("Driver") != null && this.selectdriver != null && this.selectdriver.getDriver() != null) {
                                    ticket.setProperty("Driver", this.selectdriver.getDriver().getName());
                                }
                                this.dlSales.saveTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getReceiptHost());
                                if (this.selectdriver != null && this.selectdriver.getDriver() != null) {
                                    if (!isDelivery) {
                                        this.dlSales.insertDeliveryOrderStandard(deliveryid, this.selectdriver.getDriver().getID(), ticket.getId());
                                    } else {
                                        this.dlSales.updateDeliveryDriverAndReceipt(deliveryid, this.selectdriver.getDriver().getID(), ticket.getId());
                                    }
                                } else if (ticket.getProperty("DeliveryOrder") != null) {
                                    this.dlSales.updateDeliveryAndReceipt(deliveryid, ticket.getId());
                                }
                                if (ticket.getProperty("Call") != null && this.selectdriver != null && this.selectdriver.getDriver() != null) {
                                    this.dlSales.updateCallStatus(3, ticket.getProperty("Call"));
                                }
                            } else {
                                this.dlSales.saveTicket(ticket, this.m_App.getInventoryLocation(), this.m_App.getReceiptHost());
                            }
                            this.executeEvent(ticket, ticketext, "ticket.close", new ScriptArg("print", paymentdialog.isPrintSelected()));
                            this.printTicket(paymentdialog.isPrintSelected() ? "Printer.Ticket" : "Printer.Ticket2", ticket, ticketext);
                            resultok = true;
                        }
                    }
                }
            }
            catch (TaxesException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotcalculatetaxes"));
                msg.show(this);
                resultok = false;
            }
            catch (BasicException e) {
                MessageInf msg = new MessageInf(-33554432, e.getMessage());
                msg.show(this);
                resultok = false;
            }
            catch (Exception e) {
                MessageInf msg = new MessageInf(-33554432, e.getMessage());
                msg.show(this);
                resultok = false;
            }
            this.m_oTicket.resetTaxes();
            this.m_oTicket.resetPayments();
        }
        return resultok;
    }

    private void printTicket(String sresourcename, TicketInfo ticket, Object ticketext) {
        String sresource = this.dlSystem.getResourceAsXML(sresourcename);
        if (sresource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("taxes", this.taxcollection);
                script.put("taxeslogic", this.taxeslogic);
                script.put("ticket", ticket);
                script.put("place", ticketext);
                this.m_TTP.printTicket(script.eval(sresource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    private Double getProductTariffPrice(String tariffid, String productid) {
        try {
            List<ProductInfoExt> tprods = this.dlSales.getTariffByProdIds(tariffid, "'" + productid + "'");
            if (tprods.size() > 0) {
                return tprods.get(0).getPriceSell();
            }
            return null;
        }
        catch (BasicException ex) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.errorchangetariff"), ex);
            msg.show(this);
            return null;
        }
    }

    private void setTariffPrice(String tariffid) {
        TicketLineInfo l;
        List<ProductInfoExt> tprods = null;
        try {
            String prodIds = "";
            for (int j = 0; j < this.m_oTicket.getLinesCount(); ++j) {
                l = this.m_oTicket.getLine(j);
                if (l.getProductID() == null) continue;
                prodIds = prodIds + ", '" + l.getProductID() + "'";
            }
            if (prodIds.length() > 0) {
                prodIds = prodIds.substring(1);
                tprods = this.dlSales.getTariffByProdIds(tariffid, prodIds);
            }
        }
        catch (BasicException ex) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.errorchangetariff"), ex);
            msg.show(this);
        }
        for (int i = 0; i < this.m_oTicket.getLinesCount(); ++i) {
            boolean founded = false;
            l = this.m_oTicket.getLine(i);
            if (l.getPrice() >= 0.0) {
                Iterator<ProductInfoExt> it = tprods.iterator();
                while (it.hasNext() && !founded) {
                    ProductInfoExt p = it.next();
                    if (!p.getID().equals(l.getProductID())) continue;
                    l.setSalePrice(p.getPriceSell());
                    founded = true;
                }
                if (!founded) {
                    l.setSalePrice(l.getPrice());
                }
            }
            this.paintTicketLine(i, l);
        }
    }

    private void setTariff(String tariff, TicketInfo ticket, Object ticketext) {
        if (ticket != null) {
            try {
                List<TariffInfo> tariffs = this.dlSales.getTariffAreaList();
                for (int i = 0; i < tariffs.size(); ++i) {
                    TariffInfo obj = tariffs.get(i);
                    if (!obj.getName().equals(tariff)) continue;
                    this.setTariffPrice(obj.getID());
                    this.m_oTicket.setProperty("TariffArea", obj.getName());
                    this.m_oTicket.setProperty("TariffID", obj.getID());
                    this.btnTariff.setText(AppLocal.getIntString("Menu.TariffArea") + " - " + obj.getName());
                }
            }
            catch (Exception e) {
                new MessageInf(e).show(this);
            }
        }
    }

    private void setDriver(String driver, TicketInfo ticket) {
        if (ticket != null) {
            try {
                List<DriverInfo> drivers = this.dlSales.getDrivers();
                this.selectdriver = SelectDriver.getSelectDriver(this, drivers, this.dlSystem, null);
                this.selectdriver.setDriver(null);
                for (DriverInfo drv : drivers) {
                    if (!drv.getName().equals(driver)) continue;
                    this.selectdriver.setDriver(drv);
                    this.m_oTicket.setProperty("Driver", drv.getName());
                }
                if (this.selectdriver.getDriver() == null) {
                    MessageInf msg = new MessageInf(-33554432, "Driver not found.");
                    msg.show(this);
                }
            }
            catch (Exception e) {
                new MessageInf(e).show(this);
            }
        }
    }

    private void printReport(String resourcefile, TicketInfo ticket, Object ticketext) {
        try {
            JasperReport jr;
            InputStream in = this.getClass().getResourceAsStream(resourcefile + ".ser");
            if (in == null) {
                JasperDesign jd = JRXmlLoader.load((InputStream)this.getClass().getResourceAsStream(resourcefile + ".jrxml"));
                jr = JasperCompileManager.compileReport((JasperDesign)jd);
            } else {
                ObjectInputStream oin = new ObjectInputStream(in);
                jr = (JasperReport)oin.readObject();
                oin.close();
            }
            HashMap<String, Object> reportparams = new HashMap<String, Object>();
            try {
                reportparams.put("REPORT_RESOURCE_BUNDLE", ResourceBundle.getBundle(resourcefile + ".properties"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            reportparams.put("TAXESLOGIC", this.taxeslogic);
            HashMap<String, Object> reportfields = new HashMap<String, Object>();
            reportfields.put("TICKET", ticket);
            reportfields.put("PLACE", ticketext);
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, reportparams, (JRDataSource)new JRMapArrayDataSource(new Object[]{reportfields}));
            PrintService service = ReportUtils.getPrintService(this.m_App.getProperties().getProperty("machine.printername"));
            JRPrinterAWT300.printPages(jp, 0, jp.getPages().size() - 1, service);
        }
        catch (Exception e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadreport"), e);
            msg.show(this);
        }
    }

    private void visorTicketLine(TicketLineInfo oLine) {
        if (oLine == null) {
            this.m_App.getDeviceTicket().getDeviceDisplay().clearVisor();
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticketline", oLine);
                script.put("total", this.m_oTicket.printTotal());
                this.m_TTP.printTicket(script.eval(this.dlSystem.getResourceAsXML("Printer.TicketLine")).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintline"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintline"), e);
                msg.show(this);
            }
        }
    }

    private Object evalScript(ScriptObject scr, String resource, ScriptArg ... args) {
        try {
            scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
            return scr.evalScript(this.dlSystem.getResourceAsXML(resource), args);
        }
        catch (ScriptException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e);
            msg.show(this);
            return msg;
        }
    }

    public void evalScriptAndRefresh(String resource, ScriptArg ... args) {
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"));
            msg.show(this);
        } else {
            ScriptObject scr = new ScriptObject(this.m_oTicket, this.m_oTicketExt);
            scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
            this.evalScript(scr, resource, args);
            this.refreshTicket();
            this.setSelectedIndex(scr.getSelectedIndex());
        }
    }

    public void printTicket(String resource) {
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"));
            msg.show(this);
        } else {
            try {
                this.taxeslogic.calculateTaxes(this.m_oTicket);
                this.printTicket(resource, this.m_oTicket, this.m_oTicketExt);
            }
            catch (TaxesException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotcalculatetaxes"));
                msg.show(this);
            }
        }
    }

    public void printLastTicket(String resource) {
        try {
            TicketInfo ticket = this.dlSales.loadLastTicket();
            if (ticket == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.notexiststicket"));
                msg.show(this);
            } else if (resource == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"));
                msg.show(this);
            } else {
                try {
                    this.taxeslogic.calculateTaxes(ticket);
                    this.printTicket(resource, ticket, null);
                }
                catch (TaxesException e) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotcalculatetaxes"));
                    msg.show(this);
                }
            }
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), e);
            msg.show(this);
        }
    }

    public void payCash() {
        try {
            this.closeTicket(this.m_oTicket, this.m_oTicketExt, true, "cash");
            this.m_ticketsbag.deleteTicket();
        }
        catch (Exception e) {
            MessageInf msg = new MessageInf(-33554432, "Payment error.", e);
            msg.show(this);
        }
    }

    private Object executeEventAndRefresh(String eventkey, ScriptArg ... args) {
        String resource = this.m_jbtnconfig.getEvent(eventkey);
        if (resource == null) {
            return null;
        }
        ScriptObject scr = new ScriptObject(this.m_oTicket, this.m_oTicketExt);
        scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
        Object result = this.evalScript(scr, resource, args);
        this.refreshTicket();
        this.setSelectedIndex(scr.getSelectedIndex());
        return result;
    }

    private Object executeEvent(TicketInfo ticket, Object ticketext, String eventkey, ScriptArg ... args) {
        String resource = this.m_jbtnconfig.getEvent(eventkey);
        if (resource == null) {
            return null;
        }
        ScriptObject scr = new ScriptObject(ticket, ticketext);
        return this.evalScript(scr, resource, args);
    }

    public String getResourceAsXML(String sresourcename) {
        return this.dlSystem.getResourceAsXML(sresourcename);
    }

    public BufferedImage getResourceAsImage(String sresourcename) {
        return this.dlSystem.getResourceAsImage(sresourcename);
    }

    private void setSelectedIndex(int i) {
        if (i >= 0 && i < this.m_oTicket.getLinesCount()) {
            this.m_ticketlines.setSelectedIndex(i);
        } else if (this.m_oTicket.getLinesCount() > 0) {
            this.m_ticketlines.setSelectedIndex(this.m_oTicket.getLinesCount() - 1);
        }
    }

    private void initComponents() {
        this.m_jPanContainer = new JPanel();
        this.m_jOptions = new JPanel();
        this.m_jButtons = new JPanel();
        this.m_jTicketId = new JLabel();
        this.btnCustomer = new JButton();
        this.btnSplit = new JButton();
        this.m_jPanelBag = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.m_jPanTicket = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jUp = new JButton();
        this.m_jDown = new JButton();
        this.m_Equal = new JButton();
        this.m_jDelete = new JButton();
        this.m_jList = new JButton();
        this.m_jEditLine = new JButton();
        this.jEditAttributes = new JButton();
        this.m_jPanelCentral = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jPanTotals = new JPanel();
        this.m_jTotalEuros = new JLabel();
        this.m_jLblTotalEuros1 = new JLabel();
        this.m_jSubtotalEuros = new JLabel();
        this.m_jTaxesEuros = new JLabel();
        this.m_jLblTotalEuros2 = new JLabel();
        this.m_jLblTotalEuros3 = new JLabel();
        this.m_jTotalDiscounts = new JLabel();
        this.m_jLblTotalEuros4 = new JLabel();
        this.m_jKeyFactory = new JTextField();
        this.jLblPanel = new JPanel();
        this.m_jItems = new JLabel();
        this.m_jTariffPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.btnTariff = new JButton();
        this.catcontainer2 = new JPanel();
        this.m_jPanelScripts = new JPanel();
        this.m_jButtonsExt = new JPanel();
        this.jPanel1 = new JPanel();
        this.jlblStatus = new JLabel();
        this.m_jbtnScale = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.catcontainer = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jAlphabetKeys1 = new JAlphabetKeys();
        this.m_jContEntries = new JPanel();
        this.m_jPanEntries = new JPanel();
        this.jPanel9 = new JPanel();
        this.m_jPrice = new JLabel();
        this.m_jPor = new JLabel();
        this.m_jEnter = new JButton();
        this.m_jTax = new JComboBox();
        this.m_jaddtax = new JToggleButton();
        this.m_jNumberKeys = new JNumberKeys();
        this.setBackground(new Color(255, 204, 153));
        this.setLayout(new CardLayout());
        this.m_jPanContainer.setLayout(new BorderLayout());
        this.m_jOptions.setLayout(new BorderLayout());
        this.m_jTicketId.setHorizontalAlignment(0);
        this.m_jTicketId.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTicketId.setOpaque(true);
        this.m_jTicketId.setPreferredSize(new Dimension(160, 25));
        this.m_jTicketId.setRequestFocusEnabled(false);
        this.m_jButtons.add(this.m_jTicketId);
        this.btnCustomer.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/kuser.png")));
        this.btnCustomer.setToolTipText("Select Customer (F1)");
        this.btnCustomer.setFocusPainted(false);
        this.btnCustomer.setFocusable(false);
        this.btnCustomer.setMargin(new Insets(8, 14, 8, 14));
        this.btnCustomer.setRequestFocusEnabled(false);
        this.btnCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.btnCustomerActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.btnCustomer);
        this.btnSplit.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/editcut.png")));
        this.btnSplit.setToolTipText("Split Bill (F2)");
        this.btnSplit.setFocusPainted(false);
        this.btnSplit.setFocusable(false);
        this.btnSplit.setMargin(new Insets(8, 14, 8, 14));
        this.btnSplit.setRequestFocusEnabled(false);
        this.btnSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.btnSplitActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.btnSplit);
        this.m_jOptions.add((Component)this.m_jButtons, "Before");
        this.m_jPanelBag.setLayout(new BorderLayout());
        this.m_jOptions.add((Component)this.m_jPanelBag, "Center");
        this.m_jPanContainer.add((Component)this.m_jOptions, "North");
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(15);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setMinimumSize(new Dimension(19, 42));
        this.jSplitPane1.setPreferredSize(new Dimension(19, 42));
        this.m_jPanTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanTicket.setLayout(new BorderLayout());
        this.jPanel5.setMinimumSize(new Dimension(0, 0));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanel2.setMinimumSize(new Dimension(6, 33));
        this.jPanel2.setLayout(new GridLayout(0, 1, 5, 5));
        this.m_jUp.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/plus.png")));
        this.m_jUp.setToolTipText("Select Line Up (Up Arrow)");
        this.m_jUp.setFocusPainted(false);
        this.m_jUp.setFocusable(false);
        this.m_jUp.setMargin(new Insets(8, 14, 8, 14));
        this.m_jUp.setRequestFocusEnabled(false);
        this.m_jUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jUpActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jUp);
        this.m_jDown.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/minus.png")));
        this.m_jDown.setToolTipText("Select Line Down (Down Arrow)");
        this.m_jDown.setFocusPainted(false);
        this.m_jDown.setFocusable(false);
        this.m_jDown.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDown.setRequestFocusEnabled(false);
        this.m_jDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jDownActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jDown);
        this.m_Equal.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/btnequals.png")));
        this.m_Equal.setToolTipText("Select Line Up (Up Arrow)");
        this.m_Equal.setFocusPainted(false);
        this.m_Equal.setFocusable(false);
        this.m_Equal.setMargin(new Insets(8, 14, 8, 14));
        this.m_Equal.setRequestFocusEnabled(false);
        this.m_Equal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_EqualActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_Equal);
        this.m_jDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/removeline.png")));
        this.m_jDelete.setToolTipText("Delete Line (Alt+Del)");
        this.m_jDelete.setFocusPainted(false);
        this.m_jDelete.setFocusable(false);
        this.m_jDelete.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDelete.setRequestFocusEnabled(false);
        this.m_jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jDeleteActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jDelete);
        this.m_jList.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/search22.png")));
        this.m_jList.setToolTipText("Search Product (F6)");
        this.m_jList.setFocusPainted(false);
        this.m_jList.setFocusable(false);
        this.m_jList.setMargin(new Insets(8, 14, 8, 14));
        this.m_jList.setRequestFocusEnabled(false);
        this.m_jList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jListActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jList);
        this.m_jEditLine.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/editline.png")));
        this.m_jEditLine.setToolTipText("Edit Line (F7)");
        this.m_jEditLine.setFocusPainted(false);
        this.m_jEditLine.setFocusable(false);
        this.m_jEditLine.setMargin(new Insets(8, 14, 8, 14));
        this.m_jEditLine.setRequestFocusEnabled(false);
        this.m_jEditLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jEditLineActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jEditLine);
        this.jEditAttributes.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/properties.png")));
        this.jEditAttributes.setToolTipText("Attributes (F8)");
        this.jEditAttributes.setFocusPainted(false);
        this.jEditAttributes.setFocusable(false);
        this.jEditAttributes.setMargin(new Insets(8, 14, 8, 14));
        this.jEditAttributes.setRequestFocusEnabled(false);
        this.jEditAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.jEditAttributesActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jEditAttributes);
        this.jPanel5.add((Component)this.jPanel2, "North");
        this.m_jPanTicket.add((Component)this.jPanel5, "After");
        this.m_jPanelCentral.setAutoscrolls(true);
        this.m_jPanelCentral.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BorderLayout());
        this.m_jPanTotals.setPreferredSize(new Dimension(400, 72));
        this.m_jTotalEuros.setFont(new Font("Dialog", 1, 18));
        this.m_jTotalEuros.setForeground(new Color(204, 0, 0));
        this.m_jTotalEuros.setHorizontalAlignment(11);
        this.m_jTotalEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotalEuros.setOpaque(true);
        this.m_jTotalEuros.setPreferredSize(new Dimension(130, 25));
        this.m_jTotalEuros.setRequestFocusEnabled(false);
        this.m_jLblTotalEuros1.setHorizontalAlignment(4);
        this.m_jLblTotalEuros1.setText(AppLocal.getIntString("label.totalcash"));
        this.m_jSubtotalEuros.setHorizontalAlignment(11);
        this.m_jSubtotalEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jSubtotalEuros.setOpaque(true);
        this.m_jSubtotalEuros.setPreferredSize(new Dimension(130, 25));
        this.m_jSubtotalEuros.setRequestFocusEnabled(false);
        this.m_jTaxesEuros.setHorizontalAlignment(11);
        this.m_jTaxesEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTaxesEuros.setOpaque(true);
        this.m_jTaxesEuros.setPreferredSize(new Dimension(100, 25));
        this.m_jTaxesEuros.setRequestFocusEnabled(false);
        this.m_jLblTotalEuros2.setHorizontalAlignment(4);
        this.m_jLblTotalEuros2.setText(AppLocal.getIntString("label.taxcash"));
        this.m_jLblTotalEuros3.setHorizontalAlignment(4);
        this.m_jLblTotalEuros3.setText(AppLocal.getIntString("label.subtotalcash"));
        this.m_jTotalDiscounts.setHorizontalAlignment(11);
        this.m_jTotalDiscounts.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotalDiscounts.setOpaque(true);
        this.m_jTotalDiscounts.setPreferredSize(new Dimension(100, 25));
        this.m_jTotalDiscounts.setRequestFocusEnabled(false);
        this.m_jLblTotalEuros4.setHorizontalAlignment(4);
        this.m_jLblTotalEuros4.setText(AppLocal.getIntString("label.totaldiscount"));
        this.m_jKeyFactory.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setBorder(null);
        this.m_jKeyFactory.setCaretColor(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setPreferredSize(new Dimension(1, 1));
        this.m_jKeyFactory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelTicketP.this.m_jKeyFactoryKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelTicketP.this.m_jKeyFactoryKeyTyped(evt);
            }
        });
        GroupLayout m_jPanTotalsLayout = new GroupLayout((Container)this.m_jPanTotals);
        this.m_jPanTotals.setLayout((LayoutManager)m_jPanTotalsLayout);
        m_jPanTotalsLayout.setHorizontalGroup((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().addContainerGap(52, Short.MAX_VALUE).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(2).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros4).addPreferredGap(0).add((Component)this.m_jTotalDiscounts, -2, 110, -2)).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros2).addPreferredGap(0).add((Component)this.m_jTaxesEuros, -2, 110, -2))).add(20, 20, 20).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(2, false).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.m_jTotalEuros, -2, 110, -2)).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add((Component)this.m_jLblTotalEuros3).add(5, 5, 5).add((Component)this.m_jSubtotalEuros, -2, 109, -2))).add(21, 21, 21)).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add(0, 77, Short.MAX_VALUE).add((Component)this.m_jKeyFactory, -2, 245, -2).add(0, 78, Short.MAX_VALUE))));
        m_jPanTotalsLayout.setVerticalGroup((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((Component)this.m_jLblTotalEuros2).add((Component)this.m_jLblTotalEuros3).add((Component)this.m_jSubtotalEuros, -2, -1, -2).add((Component)this.m_jTaxesEuros, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((Component)this.m_jTotalDiscounts, -2, -1, -2).add((Component)this.m_jLblTotalEuros1).add((Component)this.m_jTotalEuros, -2, -1, -2).add((Component)this.m_jLblTotalEuros4, -2, 14, -2)).add(0, 0, 0)).add((GroupLayout.Group)m_jPanTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)m_jPanTotalsLayout.createSequentialGroup().add(0, 4, Short.MAX_VALUE).add((Component)this.m_jKeyFactory, -2, -1, -2).add(0, 67, Short.MAX_VALUE))));
        this.jPanel4.add((Component)this.m_jPanTotals, "After");
        this.jLblPanel.setLayout(new BorderLayout());
        this.m_jItems.setHorizontalAlignment(2);
        this.m_jItems.setText(" ");
        this.m_jItems.setAlignmentX(0.5f);
        this.m_jItems.setHorizontalTextPosition(4);
        this.jLblPanel.add((Component)this.m_jItems, "First");
        this.jPanel4.add((Component)this.jLblPanel, "Center");
        this.m_jPanelCentral.add((Component)this.jPanel4, "South");
        this.m_jTariffPanel.setLayout(new GridLayout(1, 0));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(" ");
        this.m_jTariffPanel.add(this.jLabel5);
        this.btnTariff.setText(AppLocal.getIntString("Menu.TariffArea"));
        this.btnTariff.setToolTipText("Select Tariff");
        this.btnTariff.setFocusPainted(false);
        this.btnTariff.setFocusable(false);
        this.btnTariff.setMargin(new Insets(8, 14, 8, 14));
        this.btnTariff.setRequestFocusEnabled(false);
        this.btnTariff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.btnTariffActionPerformed(evt);
            }
        });
        this.m_jTariffPanel.add(this.btnTariff);
        this.m_jPanelCentral.add((Component)this.m_jTariffPanel, "North");
        this.m_jPanTicket.add((Component)this.m_jPanelCentral, "Center");
        this.jSplitPane1.setLeftComponent(this.m_jPanTicket);
        this.catcontainer2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.catcontainer2.setAutoscrolls(true);
        this.catcontainer2.setPreferredSize(new Dimension(255, 354));
        this.catcontainer2.setLayout(new BorderLayout());
        this.m_jPanelScripts.setPreferredSize(new Dimension(870, 50));
        this.m_jPanelScripts.setLayout(new BoxLayout(this.m_jPanelScripts, 2));
        this.m_jButtonsExt.setLayout(new BoxLayout(this.m_jButtonsExt, 2));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.jlblStatus.setHorizontalAlignment(0);
        this.jlblStatus.setText(" ");
        this.jlblStatus.setHorizontalTextPosition(0);
        this.jPanel1.add(this.jlblStatus);
        this.m_jbtnScale.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/scale.png")));
        this.m_jbtnScale.setText(AppLocal.getIntString("button.scale"));
        this.m_jbtnScale.setFocusPainted(false);
        this.m_jbtnScale.setFocusable(false);
        this.m_jbtnScale.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnScale.setRequestFocusEnabled(false);
        this.m_jbtnScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jbtnScaleActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jbtnScale);
        this.m_jButtonsExt.add(this.jPanel1);
        this.m_jPanelScripts.add(this.m_jButtonsExt);
        this.catcontainer2.add((Component)this.m_jPanelScripts, "First");
        this.jScrollPane1.setFocusable(false);
        this.jScrollPane1.setMinimumSize(new Dimension(245, 308));
        this.jScrollPane1.setPreferredSize(new Dimension(245, 308));
        this.jScrollPane1.setRequestFocusEnabled(false);
        this.jTabbedPane1.setFocusable(false);
        this.jTabbedPane1.setRequestFocusEnabled(false);
        this.catcontainer.setPreferredSize(new Dimension(245, 308));
        this.catcontainer.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Catalog", this.catcontainer);
        this.jPanel3.setMinimumSize(new Dimension(0, 0));
        this.jPanel3.setPreferredSize(new Dimension(0, 0));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.jPanel6.setMaximumSize(new Dimension(Short.MAX_VALUE, 295));
        this.jPanel6.setMinimumSize(new Dimension(0, 295));
        this.jPanel6.setPreferredSize(new Dimension(646, 295));
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel7.setMaximumSize(new Dimension(245, 308));
        this.jPanel7.setMinimumSize(new Dimension(245, 308));
        this.jPanel7.setPreferredSize(new Dimension(245, 308));
        this.jAlphabetKeys1.setMaximumSize(new Dimension(500, 150));
        this.jAlphabetKeys1.setMinimumSize(new Dimension(500, 150));
        this.jAlphabetKeys1.setPreferredSize(new Dimension(500, 150));
        this.jAlphabetKeys1.addJNumberEventListener(new JNumberEventListener(){

            @Override
            public void keyPerformed(JNumberEvent evt) {
                JPanelTicketP.this.jAlphabetKeys1KeyPerformed(evt);
            }
        });
        this.jPanel7.add(this.jAlphabetKeys1);
        this.jPanel6.add((Component)this.jPanel7, "Center");
        this.jPanel3.add(this.jPanel6);
        this.m_jContEntries.setMaximumSize(new Dimension(245, 308));
        this.m_jContEntries.setMinimumSize(new Dimension(245, 308));
        this.m_jContEntries.setPreferredSize(new Dimension(245, 308));
        this.m_jContEntries.setLayout(new BorderLayout());
        this.m_jPanEntries.setMinimumSize(new Dimension(245, 308));
        this.m_jPanEntries.setLayout(new BoxLayout(this.m_jPanEntries, 1));
        this.jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel9.setLayout(new GridBagLayout());
        this.m_jPrice.setHorizontalAlignment(4);
        this.m_jPrice.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jPrice.setOpaque(true);
        this.m_jPrice.setPreferredSize(new Dimension(100, 25));
        this.m_jPrice.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.m_jPrice, gridBagConstraints);
        this.m_jPor.setHorizontalAlignment(4);
        this.m_jPor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jPor.setOpaque(true);
        this.m_jPor.setPreferredSize(new Dimension(22, 25));
        this.m_jPor.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.m_jPor, gridBagConstraints);
        this.m_jEnter.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/barcode.png")));
        this.m_jEnter.setFocusPainted(false);
        this.m_jEnter.setFocusable(false);
        this.m_jEnter.setRequestFocusEnabled(false);
        this.m_jEnter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicketP.this.m_jEnterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.m_jEnter, gridBagConstraints);
        this.m_jTax.setFocusable(false);
        this.m_jTax.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel9.add((Component)this.m_jTax, gridBagConstraints);
        this.m_jaddtax.setText("+");
        this.m_jaddtax.setFocusPainted(false);
        this.m_jaddtax.setFocusable(false);
        this.m_jaddtax.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel9.add((Component)this.m_jaddtax, gridBagConstraints);
        this.m_jPanEntries.add(this.jPanel9);
        this.m_jNumberKeys.addJNumberEventListener(new JNumberEventListener(){

            @Override
            public void keyPerformed(JNumberEvent evt) {
                JPanelTicketP.this.m_jNumberKeysKeyPerformed(evt);
            }
        });
        this.m_jPanEntries.add(this.m_jNumberKeys);
        this.m_jContEntries.add((Component)this.m_jPanEntries, "North");
        this.jPanel3.add(this.m_jContEntries);
        this.jTabbedPane1.addTab("Keyboard", this.jPanel3);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        this.catcontainer2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setRightComponent(this.catcontainer2);
        this.m_jPanContainer.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.m_jPanContainer, "ticket");
    }

    private void m_jEnterActionPerformed(ActionEvent evt) {
        this.stateTransition('\n');
        this.m_jKeyFactory.requestFocus();
    }

    private void m_jKeyFactoryKeyTyped(KeyEvent evt) {
        this.m_jKeyFactory.setText(null);
        this.stateTransition(evt.getKeyChar());
    }

    private void btnCustomerActionPerformed(ActionEvent evt) {
        JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlCustomers);
        finder.search(this.m_oTicket.getCustomer());
        finder.setVisible(true);
        try {
            this.m_oTicket.setCustomer(finder.getSelectedCustomer() == null ? null : this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()));
            this.executeEventAndRefresh("ticket.customerchanged", new ScriptArg[0]);
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), e);
            msg.show(this);
        }
        this.refreshTicket();
    }

    private void btnSplitActionPerformed(ActionEvent evt) {
        if (this.m_oTicket.getLinesCount() > 0) {
            ReceiptSplit splitdialog = ReceiptSplit.getDialog(this, this.dlSystem.getResourceAsXML("Ticket.Line"), this.dlSales, this.dlCustomers, this.taxeslogic);
            TicketInfo ticket1 = this.m_oTicket.copyTicket();
            TicketInfo ticket2 = new TicketInfo();
            ticket2.setCustomer(this.m_oTicket.getCustomer());
            this.executeEventAndRefresh("ticket.customerchanged", new ScriptArg[0]);
            if (splitdialog.showDialog(ticket1, ticket2, this.m_oTicketExt) && this.closeTicket(ticket2, this.m_oTicketExt, false, "")) {
                this.setActiveTicket(ticket1, this.m_oTicketExt);
            }
        }
    }

    private void m_jKeyFactoryKeyPressed(KeyEvent evt) {
        block25: {
            Component[] btnCmps;
            int key;
            block32: {
                JPanel jpnlbtn;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        key = evt.getKeyCode();
                                        if (key != 38 && key != 40 && (key < 112 || key > 123)) break block25;
                                        btnCmps = this.m_jbtnconfig.getComponents();
                                        if (this.m_jPanelBag.getComponents()[0].getClass().getName().equals("com.posics.pos.sales.shared.JTicketsBagShared")) {
                                            JTicketsBagShared pnlCtrls1 = (JTicketsBagShared)this.m_jPanelBag.getComponents()[0];
                                            jpnlbtn = (JPanel)pnlCtrls1.getComponents()[0];
                                        } else if (this.m_jPanelBag.getComponents()[0].getClass().getName().equals("com.posics.pos.sales.restaurant.JTicketsBagRestaurant")) {
                                            jpnlbtn = (JPanel)this.m_jPanelBag.getComponents()[0];
                                        } else if (this.m_jPanelBag.getComponents()[0].getClass().getName().equals("com.posics.pos.sales.delivery.JTicketsBagDeliveryMenu")) {
                                            jpnlbtn = (JPanel)this.m_jPanelBag.getComponents()[0];
                                        } else if (this.m_jPanelBag.getComponents()[0].getClass().getName().equals("com.posics.pos.sales.JTicketsBagTicketBag")) {
                                            JTicketsBagTicketBag pnlCtrls2 = (JTicketsBagTicketBag)this.m_jPanelBag.getComponents()[0];
                                            jpnlbtn = (JPanel)pnlCtrls2.getComponents()[0];
                                        } else {
                                            jpnlbtn = (JTicketsBagSimple)this.m_jPanelBag.getComponents()[0];
                                        }
                                        if (key != 40) break block26;
                                        this.m_ticketlines.selectionDown();
                                        break block25;
                                    }
                                    if (key != 38) break block27;
                                    this.m_ticketlines.selectionUp();
                                    break block25;
                                }
                                if (key != 112) break block28;
                                this.btnCustomerActionPerformed(null);
                                break block25;
                            }
                            if (key != 113) break block29;
                            this.btnSplitActionPerformed(null);
                            break block25;
                        }
                        if (key != 114) break block30;
                        if (jpnlbtn.getComponents()[0] == null) break block25;
                        JButton btnCtrl = (JButton)jpnlbtn.getComponents()[0];
                        btnCtrl.doClick();
                        break block25;
                    }
                    if (key != 115) break block31;
                    if (jpnlbtn.getComponentCount() < 2 || jpnlbtn.getComponents()[1] == null) break block25;
                    JButton btnCtrl = (JButton)jpnlbtn.getComponents()[1];
                    btnCtrl.doClick();
                    break block25;
                }
                if (key != 116) break block32;
                if (jpnlbtn.getComponentCount() < 3 || jpnlbtn.getComponents()[2] == null) break block25;
                JButton btnCtrl = (JButton)jpnlbtn.getComponents()[2];
                btnCtrl.doClick();
                break block25;
            }
            if (key == 117) {
                this.m_jListActionPerformed(null);
            } else if (key == 118) {
                this.m_jEditLineActionPerformed(null);
            } else if (key == 119) {
                this.jEditAttributesActionPerformed(null);
            } else if (key == 120) {
                for (int i = 0; i < btnCmps.length; ++i) {
                    JButton btn = (JButton)btnCmps[i];
                    if (btn.getMnemonic() != 120) continue;
                    btn.doClick();
                    break;
                }
            } else if (key == 121) {
                for (int i = 0; i < btnCmps.length; ++i) {
                    JButton btn = (JButton)btnCmps[i];
                    if (btn.getMnemonic() != 121) continue;
                    btn.doClick();
                    break;
                }
            } else if (key == 122) {
                for (int i = 0; i < btnCmps.length; ++i) {
                    JButton btn = (JButton)btnCmps[i];
                    if (btn.getMnemonic() != 122) continue;
                    btn.doClick();
                    break;
                }
            } else if (key == 123) {
                for (int i = 0; i < btnCmps.length; ++i) {
                    JButton btn = (JButton)btnCmps[i];
                    if (btn.getMnemonic() != 123) continue;
                    btn.doClick();
                    break;
                }
            }
        }
    }

    private void m_jNumberKeysKeyPerformed(JNumberEvent evt) {
        this.stateTransition(evt.getKey());
    }

    private void jAlphabetKeys1KeyPerformed(JNumberEvent evt) {
        try {
            Robot robot = new Robot();
            Class<KeyEvent> cl = KeyEvent.class;
            robot.keyPress(evt.getKey());
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    private void m_jbtnScaleActionPerformed(ActionEvent evt) {
        this.stateTransition('\u00a7');
    }

    private void m_jUpActionPerformed(ActionEvent evt) {
        this.stateTransition('+');
    }

    private void m_jDownActionPerformed(ActionEvent evt) {
        this.stateTransition('-');
    }

    private void m_jDeleteActionPerformed(ActionEvent evt) {
        int i = this.m_ticketlines.getSelectedIndex();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.removeTicketLine(i);
        }
    }

    private void m_jListActionPerformed(ActionEvent evt) {
        ProductInfoExt prod = JProductFinder.showMessage(this, this.dlSales);
        if (prod != null) {
            this.buttonTransition(prod);
        }
    }

    private void m_jEditLineActionPerformed(ActionEvent evt) {
        int i = this.m_ticketlines.getSelectedIndex();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                TicketLineInfo newline = JProductLineEdit.showMessage(this, this.m_App, this.m_oTicket.getLine(i));
                if (newline != null) {
                    this.paintTicketLine(i, newline);
                }
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jEditAttributesActionPerformed(ActionEvent evt) {
        if (StringUtils.m_blTicketProperties) {
            try {
                JProductAttEdit attedit = JProductAttEdit.getAttributesEditor(this, this.m_App.getSession());
                attedit.editTicketAttributes("-1", this.m_oTicket);
                attedit.setVisible(true);
                if (!attedit.isOK()) return;
            }
            catch (BasicException ex) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindattributes"), ex);
                msg.show(this);
            }
            return;
        }
        int i = this.m_ticketlines.getSelectedIndex();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            TicketLineInfo line = this.m_oTicket.getLine(i);
            JProductAttEdit attedit = JProductAttEdit.getAttributesEditor(this, this.m_App.getSession());
            attedit.editAttributes(line.getProductAttSetId(), line.getProductAttSetInstId());
            attedit.setVisible(true);
            if (!attedit.isOK()) return;
            line.setProductAttSetInstId(attedit.getAttributeSetInst());
            line.setProductAttSetInstDesc(attedit.getAttributeSetInstDescription());
            this.paintTicketLine(i, line);
            return;
        }
        catch (BasicException ex) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindattributes"), ex);
            msg.show(this);
        }
        {
            // empty if block
        }
    }

    private void btnDrivers() {
        try {
            List<DriverInfo> drivers = this.dlSales.getDrivers();
            this.selectdriver = SelectDriver.getSelectDriver(this, drivers, this.dlSystem, null);
            this.selectdriver.setVisible(true);
            if (this.selectdriver.isOK()) {
                if (this.selectdriver.getDriver() != null) {
                    this.m_oTicket.setProperty("Driver", this.selectdriver.getDriver().getName());
                }
            } else {
                this.selectdriver = null;
            }
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    private void btnTariffActionPerformed(ActionEvent evt) {
        try {
            List<TariffInfo> tariffs = this.dlSales.getTariffAreaList();
            SelectTariff selecttariff = SelectTariff.getSelectTariff(this, tariffs);
            selecttariff.setVisible(true);
            if (selecttariff.isOK() && selecttariff.getTariff() != null) {
                this.m_oTicket.setProperty("TariffArea", selecttariff.getTariff().getName());
                this.m_oTicket.setProperty("TariffID", selecttariff.getTariff().getID());
                this.setTariffPrice(selecttariff.getTariff().getID());
                this.btnTariff.setText(AppLocal.getIntString("Menu.TariffArea") + " - " + selecttariff.getTariff().getName());
            }
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    private void m_EqualActionPerformed(ActionEvent evt) {
        this.stateTransition('=');
    }

    private void showhidekeyboard(boolean showhidekb) {
        if (showhidekb) {
            this.jTabbedPane1.getTabComponentAt(0).setVisible(false);
            this.jTabbedPane1.getTabComponentAt(1).setVisible(true);
        } else {
            this.jTabbedPane1.getTabComponentAt(0).setVisible(true);
            this.jTabbedPane1.getTabComponentAt(1).setVisible(false);
        }
    }

    public class ScriptObject {
        private TicketInfo ticket;
        private Object ticketext;
        private int selectedindex;

        private ScriptObject(TicketInfo ticket, Object ticketext) {
            this.ticket = ticket;
            this.ticketext = ticketext;
        }

        public double getInputValue() {
            if (JPanelTicketP.this.m_iNumberStatusInput == 1 && JPanelTicketP.this.m_iNumberStatusPor == 0) {
                return JPanelTicketP.this.getInputValue();
            }
            return 0.0;
        }

        public int getSelectedIndex() {
            return this.selectedindex;
        }

        public void setSelectedIndex(int i) {
            this.selectedindex = i;
        }

        public void printReport(String resourcefile) {
            JPanelTicketP.this.printReport(resourcefile, this.ticket, this.ticketext);
        }

        public void printTicket(String sresourcename) {
            JPanelTicketP.this.printTicket(sresourcename, this.ticket, this.ticketext);
        }

        public void keepLine(TicketLineInfo l) {
            try {
                JPanelTicketP.this.dlSystem.execLineRemoved(new Object[]{UUID.randomUUID().toString(), JPanelTicketP.this.m_oTicket.getDate(), JPanelTicketP.this.m_oTicket.getTicketId(), l.getProductName(), l.getMultiply(), l.getSalePrice(), l.getProperties(), JPanelTicketP.this.m_App.getAppUserView().getUser().getName(), JPanelTicketP.this.m_App.getActiveCashIndex()});
            }
            catch (BasicException e) {
                System.err.println(e.getMessage());
            }
        }

        public void setTariff(String tariff, int i) {
            if (i == 0) {
                JPanelTicketP.this.setTariff(tariff, this.ticket, this.ticketext);
            } else if (this.ticket != null && this.ticket.getProperty("TariffArea") == null) {
                JPanelTicketP.this.setTariff(tariff, this.ticket, this.ticketext);
            }
        }

        public void setDriver(String driver) {
            JPanelTicketP.this.setDriver(driver, this.ticket);
        }

        public void addItemByQuantity(String sCode, double qty) {
            JPanelTicketP.this.incProductByCodeWeight(sCode, qty);
        }

        public void addItemByPrice(String sCode, double price) {
            JPanelTicketP.this.incProductByCodePrice(sCode, price);
        }

        public Double readNumber(String title) {
            return JNumberDialog.showEditNumber(JPanelTicketP.this, "Input", title, new ImageIcon(this.getClass().getResource("/com/posics/images/scale2.png")));
        }

        public String readText(String title) {
            return JTextDialog.showEditText(JPanelTicketP.this, "Input", title, new ImageIcon(this.getClass().getResource("/com/posics/images/scale2.png")));
        }

        public void showTariff() {
            JPanelTicketP.this.btnTariffActionPerformed(null);
        }

        public void selectDriver() {
            JPanelTicketP.this.btnDrivers();
        }

        public void setInventoryLocation(String location) {
            JPanelTicketP.this.m_App.setInventoryLocation(location);
        }

        public void showStatus(String status) {
            JPanelTicketP.this.jlblStatus.setText(status);
        }

        public String getInventoryLocation() {
            return JPanelTicketP.this.m_App.getInventoryLocation();
        }

        public Object evalScript(String code, ScriptArg ... args) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            script.put("ticket", this.ticket);
            script.put("place", this.ticketext);
            script.put("taxes", JPanelTicketP.this.taxcollection);
            script.put("taxeslogic", JPanelTicketP.this.taxeslogic);
            script.put("user", JPanelTicketP.this.m_App.getAppUserView().getUser());
            script.put("sales", this);
            for (ScriptArg arg : args) {
                script.put(arg.getKey(), arg.getValue());
            }
            return script.eval(code);
        }
    }

    public static class ScriptArg {
        private String key;
        private Object value;

        public ScriptArg(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

