/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SentenceExec;
import com.posics.data.loader.SentenceFind;
import com.posics.data.loader.SentenceList;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadString;
import com.posics.data.loader.SerializerWriteBasic;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.editor.JEditorKeys;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.inventory.AttributeSetInfo;
import com.posics.pos.sales.JProductAttEditI;
import com.posics.pos.sales.JProductAttEditItem;
import com.posics.pos.sales.JProductAttListItem;
import com.posics.pos.sales.JProductAttSelectItem;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class JProductAttEdit
extends JDialog {
    private SentenceFind attsetSent;
    private SentenceList attvaluesSent;
    private SentenceList attinstSent;
    private SentenceList attinstSent2;
    private SentenceFind attsetinstExistsSent;
    private SentenceExec attsetSave;
    private SentenceExec attinstSave;
    private List<JProductAttEditI> itemslist;
    private String attsetid;
    private String attInstanceId;
    private String attInstanceDescription;
    private TicketInfo m_oTicket;
    private boolean ok;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JButton m_jButtonCancel;
    private JButton m_jButtonOK;
    private JEditorKeys m_jKeys;

    private JProductAttEdit(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JProductAttEdit(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private void init(Session s) {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.attsetSave = new PreparedSentence(s, "INSERT INTO ATTRIBUTESETINSTANCE (ID, ATTRIBUTESET_ID, DESCRIPTION) VALUES (?, ?, ?)", new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING));
        this.attinstSave = new PreparedSentence(s, "INSERT INTO ATTRIBUTEINSTANCE(ID, ATTRIBUTESETINSTANCE_ID, ATTRIBUTE_ID, VALUE) VALUES (?, ?, ?, ?)", new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING));
        this.attsetSent = new PreparedSentence(s, "SELECT ID, NAME FROM ATTRIBUTESET WHERE ID = ?", SerializerWriteString.INSTANCE, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new AttributeSetInfo(dr.getString(1), dr.getString(2));
            }
        });
        this.attsetinstExistsSent = new PreparedSentence(s, "SELECT ID FROM ATTRIBUTESETINSTANCE WHERE ATTRIBUTESET_ID = ? AND DESCRIPTION = ?", new SerializerWriteBasic(Datas.STRING, Datas.STRING), SerializerReadString.INSTANCE);
        this.attinstSent = new PreparedSentence(s, "SELECT A.ID, A.NAME, " + s.DB.CHAR_NULL() + ", " + s.DB.CHAR_NULL() + ", A.ATYPE FROM ATTRIBUTEUSE AU JOIN ATTRIBUTE A ON AU.ATTRIBUTE_ID = A.ID WHERE AU.ATTRIBUTESET_ID = ? ORDER BY AU.LINENO", SerializerWriteString.INSTANCE, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new AttributeInstInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getString(4), dr.getInt(5));
            }
        });
        this.attinstSent2 = new PreparedSentence(s, "SELECT A.ID, A.NAME, AI.ID, AI.VALUE, A.ATYPE FROM ATTRIBUTEUSE AU JOIN ATTRIBUTE A ON AU.ATTRIBUTE_ID = A.ID LEFT OUTER JOIN ATTRIBUTEINSTANCE AI ON AI.ATTRIBUTE_ID = A.ID WHERE AU.ATTRIBUTESET_ID = ? AND AI.ATTRIBUTESETINSTANCE_ID = ?ORDER BY AU.LINENO", new SerializerWriteBasic(Datas.STRING, Datas.STRING), new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new AttributeInstInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getString(4), dr.getInt(5));
            }
        });
        this.attvaluesSent = new PreparedSentence(s, "SELECT VALUE FROM ATTRIBUTEVALUE WHERE ATTRIBUTE_ID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.getRootPane().setDefaultButton(this.m_jButtonOK);
    }

    public static JProductAttEdit getAttributesEditor(Component parent, Session s) {
        Window window = SwingUtilities.getWindowAncestor(parent);
        JProductAttEdit myMsg = window instanceof Frame ? new JProductAttEdit((Frame)window, true) : new JProductAttEdit((Dialog)window, true);
        myMsg.init(s);
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        return myMsg;
    }

    public void editAttributes(String attsetid, String attsetinstid) throws BasicException {
        if (attsetid == null) {
            throw new BasicException(AppLocal.getIntString("message.cannotfindattributes"));
        }
        this.attsetid = attsetid;
        this.attInstanceId = null;
        this.attInstanceDescription = null;
        this.ok = false;
        AttributeSetInfo asi = (AttributeSetInfo)this.attsetSent.find((Object)attsetid);
        if (asi == null) {
            throw new BasicException(AppLocal.getIntString("message.cannotfindattributes"));
        }
        this.setTitle(asi.getName());
        List attinstinfo = attsetinstid == null ? this.attinstSent.list((Object)attsetid) : this.attinstSent2.list(attsetid, attsetinstid);
        this.itemslist = new ArrayList<JProductAttEditI>();
        this.jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.top = 10;
        int pos = 2;
        for (AttributeInstInfo aii : attinstinfo) {
            JPanel item;
            gridBagConstraints.gridy = pos++;
            List values = this.attvaluesSent.list((Object)aii.getAttid());
            if (values.isEmpty()) {
                item = new JProductAttEditItem(aii.getAttid(), aii.getAttname(), aii.getValue(), this.m_jKeys, aii.getAttType());
                this.itemslist.add((JProductAttEditI)((Object)item));
                this.jPanel2.add(item.getComponent(), gridBagConstraints);
                continue;
            }
            if (aii.getAttType() != null && aii.getAttType() == 5) {
                item = new JProductAttSelectItem(aii.getAttid(), aii.getAttname(), aii.getValue(), values);
                this.itemslist.add((JProductAttEditI)((Object)item));
                this.jPanel2.add(item.getComponent(), gridBagConstraints);
                continue;
            }
            item = new JProductAttListItem(aii.getAttid(), aii.getAttname(), aii.getValue(), values);
            this.itemslist.add((JProductAttEditI)((Object)item));
            this.jPanel2.add(item.getComponent(), gridBagConstraints);
        }
        if (this.itemslist.size() > 0) {
            this.itemslist.get(0).assignSelection();
        }
    }

    public void editTicketAttributes(String attsetid, TicketInfo tkt) throws BasicException {
        if (tkt != null) {
            this.m_oTicket = tkt;
        }
        this.attsetid = attsetid;
        this.attInstanceId = null;
        this.attInstanceDescription = null;
        this.ok = false;
        AttributeSetInfo asi = (AttributeSetInfo)this.attsetSent.find((Object)attsetid);
        if (asi == null) {
            throw new BasicException(AppLocal.getIntString("message.cannotfindattributes"));
        }
        this.setTitle(asi.getName());
        List attinstinfo = this.attinstSent.list((Object)attsetid);
        this.itemslist = new ArrayList<JProductAttEditI>();
        this.jPanel2.setLayout(new GridLayout(attinstinfo.size(), 0));
        for (AttributeInstInfo aii : attinstinfo) {
            List values = this.attvaluesSent.list((Object)aii.getAttid());
            String attval = "";
            attval = this.m_oTicket.getProperty(aii.getAttname()) != null ? this.m_oTicket.getProperty(aii.getAttname()) : aii.getValue();
            JPanel item = values.isEmpty() ? new JProductAttEditItem(aii.getAttid(), aii.getAttname(), attval, this.m_jKeys, aii.getAttType()) : (aii.getAttType() != null && aii.getAttType() == 5 ? new JProductAttSelectItem(aii.getAttid(), aii.getAttname(), attval, values) : new JProductAttListItem(aii.getAttid(), aii.getAttname(), attval, values));
            this.itemslist.add((JProductAttEditI)((Object)item));
            this.jPanel2.add(item.getComponent());
            if (this.itemslist.size() <= 0) continue;
            this.itemslist.get(0).assignSelection();
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getAttributeSetInst() {
        return this.attInstanceId;
    }

    public String getAttributeSetInstDescription() {
        return this.attInstanceDescription;
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jButtonOK = new JButton();
        this.m_jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.setDefaultCloseOperation(2);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(2));
        this.m_jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.m_jButtonOK.setText(AppLocal.getIntString("Button.OK"));
        this.m_jButtonOK.setFocusPainted(false);
        this.m_jButtonOK.setFocusable(false);
        this.m_jButtonOK.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonOK.setRequestFocusEnabled(false);
        this.m_jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProductAttEdit.this.m_jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jButtonOK);
        this.m_jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.m_jButtonCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.m_jButtonCancel.setFocusPainted(false);
        this.m_jButtonCancel.setFocusable(false);
        this.m_jButtonCancel.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonCancel.setRequestFocusEnabled(false);
        this.m_jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProductAttEdit.this.m_jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jButtonCancel);
        this.jPanel5.add((Component)this.jPanel1, "South");
        this.jScrollPane1.setBorder(null);
        this.jPanel2.setAutoscrolls(true);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel2);
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel5, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel4.add(this.m_jKeys);
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.getContentPane().add((Component)this.jPanel3, "East");
        this.setSize(new Dimension(649, 388));
        this.setLocationRelativeTo(null);
    }

    private void m_jButtonOKActionPerformed(ActionEvent evt) {
        String id;
        StringBuilder description = new StringBuilder();
        for (JProductAttEditI item : this.itemslist) {
            String value = item.getValue();
            if (value == null || value.length() <= 0) continue;
            if (description.length() > 0) {
                description.append(", ");
            }
            description.append(value.trim());
        }
        if (description.length() == 0) {
            id = null;
        } else {
            try {
                id = (String)this.attsetinstExistsSent.find(this.attsetid, description.toString());
            }
            catch (BasicException ex) {
                return;
            }
            if (id == null) {
                id = UUID.randomUUID().toString();
                try {
                    if (StringUtils.m_blTicketProperties) {
                        for (JProductAttEditI item : this.itemslist) {
                            this.m_oTicket.setProperty(item.getAttName(), item.getValue() == null ? "" : item.getValue());
                        }
                    } else {
                        this.attsetSave.exec(id, this.attsetid, description.toString());
                        for (JProductAttEditI item : this.itemslist) {
                            this.attinstSave.exec(UUID.randomUUID().toString(), id, item.getAttribute(), item.getValue());
                        }
                    }
                }
                catch (BasicException ex) {
                    return;
                }
            }
        }
        this.ok = true;
        this.attInstanceId = id;
        this.attInstanceDescription = description.toString();
        this.dispose();
    }

    private void m_jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static class AttributeInstInfo {
        private String attid;
        private String attname;
        private String id;
        private String value;
        private Integer atype;

        public AttributeInstInfo(String attid, String attname, String id, String value, Integer atype) {
            this.attid = attid;
            this.attname = attname;
            this.id = id;
            this.value = value;
            this.atype = atype;
        }

        public String getAttid() {
            return this.attid;
        }

        public String getAttname() {
            return this.attname;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getAttType() {
            return this.atype;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private class JButtonAtt
    extends JButton {
        private String m_attvalue;

        public JButtonAtt(String att) {
            this.m_attvalue = att;
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(8, 14, 8, 14));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JProductAttEdit.this.ok = true;
                    JProductAttEdit.this.dispose();
                }
            });
            this.setText(att);
        }
    }
}

