/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.editor.JEditorCurrency;
import com.posics.editor.JEditorDouble;
import com.posics.editor.JEditorKeys;
import com.posics.editor.JEditorString;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.ticket.TicketLineInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JProductLineEdit
extends JDialog {
    private TicketLineInfo returnLine;
    private TicketLineInfo m_oLine;
    private boolean m_bunitsok;
    private boolean m_bpriceok;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton m_jButtonCancel;
    private JButton m_jButtonOK;
    private JEditorKeys m_jKeys;
    private JEditorString m_jName;
    private JEditorCurrency m_jPrice;
    private JEditorCurrency m_jPriceTax;
    private JLabel m_jSubtotal;
    private JLabel m_jTaxrate;
    private JLabel m_jTotal;
    private JEditorDouble m_jUnits;

    private JProductLineEdit(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JProductLineEdit(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private TicketLineInfo init(AppView app, TicketLineInfo oLine) throws BasicException {
        this.initComponents();
        if (oLine.getTaxInfo() == null) {
            throw new BasicException(AppLocal.getIntString("message.cannotcalculatetaxes"));
        }
        this.m_oLine = new TicketLineInfo(oLine);
        this.m_bunitsok = true;
        this.m_bpriceok = true;
        this.m_jName.setEnabled(this.m_oLine.getProductID() == null && app.getAppUserView().getUser().hasPermission("com.posics.pos.sales.JPanelTicketEdits"));
        this.m_jPrice.setEnabled(app.getAppUserView().getUser().hasPermission("com.posics.pos.sales.JPanelTicketEdits"));
        this.m_jPriceTax.setEnabled(app.getAppUserView().getUser().hasPermission("com.posics.pos.sales.JPanelTicketEdits"));
        this.m_jName.setText(this.m_oLine.getProperty("product.name"));
        this.m_jUnits.setDoubleValue(oLine.getMultiply());
        this.m_jPrice.setDoubleValue(oLine.getSalePrice());
        this.m_jPriceTax.setDoubleValue(oLine.getPriceTax());
        this.m_jTaxrate.setText(oLine.getTaxInfo().getName());
        this.m_jName.addPropertyChangeListener("Edition", new RecalculateName());
        this.m_jUnits.addPropertyChangeListener("Edition", new RecalculateUnits());
        this.m_jPrice.addPropertyChangeListener("Edition", new RecalculatePrice());
        this.m_jPriceTax.addPropertyChangeListener("Edition", new RecalculatePriceTax());
        this.m_jName.addEditorKeys(this.m_jKeys);
        this.m_jUnits.addEditorKeys(this.m_jKeys);
        this.m_jPrice.addEditorKeys(this.m_jKeys);
        this.m_jPriceTax.addEditorKeys(this.m_jKeys);
        if (this.m_jName.isEnabled()) {
            this.m_jName.activate();
        } else {
            this.m_jUnits.activate();
        }
        this.printTotals();
        this.getRootPane().setDefaultButton(this.m_jButtonOK);
        this.returnLine = null;
        this.setVisible(true);
        return this.returnLine;
    }

    private void printTotals() {
        if (this.m_bunitsok && this.m_bpriceok) {
            this.m_jSubtotal.setText(this.m_oLine.printSubValue());
            this.m_jTotal.setText(this.m_oLine.printValue());
            this.m_jButtonOK.setEnabled(true);
        } else {
            this.m_jSubtotal.setText(null);
            this.m_jTotal.setText(null);
            this.m_jButtonOK.setEnabled(false);
        }
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JProductLineEdit.getWindow(parent.getParent());
    }

    public static TicketLineInfo showMessage(Component parent, AppView app, TicketLineInfo oLine) throws BasicException {
        Window window = JProductLineEdit.getWindow(parent);
        JProductLineEdit myMsg = window instanceof Frame ? new JProductLineEdit((Frame)window, true) : new JProductLineEdit((Dialog)window, true);
        return myMsg.init(app, oLine);
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.m_jName = new JEditorString();
        this.m_jUnits = new JEditorDouble();
        this.m_jPrice = new JEditorCurrency();
        this.m_jPriceTax = new JEditorCurrency();
        this.m_jTaxrate = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.m_jTotal = new JLabel();
        this.jLabel7 = new JLabel();
        this.m_jSubtotal = new JLabel();
        this.jPanel1 = new JPanel();
        this.m_jButtonOK = new JButton();
        this.m_jButtonCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("label.editline"));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel2.setLayout(null);
        this.jLabel1.setText(AppLocal.getIntString("label.price"));
        this.jPanel2.add(this.jLabel1);
        this.jLabel1.setBounds(10, 80, 90, 15);
        this.jLabel2.setText(AppLocal.getIntString("label.units"));
        this.jPanel2.add(this.jLabel2);
        this.jLabel2.setBounds(10, 50, 90, 15);
        this.jLabel3.setText(AppLocal.getIntString("label.pricetax"));
        this.jPanel2.add(this.jLabel3);
        this.jLabel3.setBounds(10, 110, 90, 15);
        this.jLabel4.setText(AppLocal.getIntString("label.item"));
        this.jPanel2.add(this.jLabel4);
        this.jLabel4.setBounds(10, 20, 90, 15);
        this.jPanel2.add(this.m_jName);
        this.m_jName.setBounds(100, 20, 270, 25);
        this.jPanel2.add(this.m_jUnits);
        this.m_jUnits.setBounds(100, 50, 240, 25);
        this.jPanel2.add(this.m_jPrice);
        this.m_jPrice.setBounds(100, 80, 240, 25);
        this.jPanel2.add(this.m_jPriceTax);
        this.m_jPriceTax.setBounds(100, 110, 240, 25);
        this.m_jTaxrate.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.m_jTaxrate.setHorizontalAlignment(4);
        this.m_jTaxrate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTaxrate.setOpaque(true);
        this.m_jTaxrate.setPreferredSize(new Dimension(150, 25));
        this.m_jTaxrate.setRequestFocusEnabled(false);
        this.jPanel2.add(this.m_jTaxrate);
        this.m_jTaxrate.setBounds(100, 140, 210, 25);
        this.jLabel5.setText(AppLocal.getIntString("label.tax"));
        this.jPanel2.add(this.jLabel5);
        this.jLabel5.setBounds(10, 140, 90, 15);
        this.jLabel6.setText(AppLocal.getIntString("label.totalcash"));
        this.jPanel2.add(this.jLabel6);
        this.jLabel6.setBounds(10, 200, 90, 15);
        this.m_jTotal.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.m_jTotal.setHorizontalAlignment(4);
        this.m_jTotal.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotal.setOpaque(true);
        this.m_jTotal.setPreferredSize(new Dimension(150, 25));
        this.m_jTotal.setRequestFocusEnabled(false);
        this.jPanel2.add(this.m_jTotal);
        this.m_jTotal.setBounds(100, 200, 210, 25);
        this.jLabel7.setText(AppLocal.getIntString("label.subtotalcash"));
        this.jPanel2.add(this.jLabel7);
        this.jLabel7.setBounds(10, 170, 90, 15);
        this.m_jSubtotal.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
        this.m_jSubtotal.setHorizontalAlignment(4);
        this.m_jSubtotal.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jSubtotal.setOpaque(true);
        this.m_jSubtotal.setPreferredSize(new Dimension(150, 25));
        this.m_jSubtotal.setRequestFocusEnabled(false);
        this.jPanel2.add(this.m_jSubtotal);
        this.m_jSubtotal.setBounds(100, 170, 210, 25);
        this.jPanel5.add((Component)this.jPanel2, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.m_jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.m_jButtonOK.setText(AppLocal.getIntString("Button.OK"));
        this.m_jButtonOK.setFocusPainted(false);
        this.m_jButtonOK.setFocusable(false);
        this.m_jButtonOK.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonOK.setRequestFocusEnabled(false);
        this.m_jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProductLineEdit.this.m_jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jButtonOK);
        this.m_jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.m_jButtonCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.m_jButtonCancel.setFocusPainted(false);
        this.m_jButtonCancel.setFocusable(false);
        this.m_jButtonCancel.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonCancel.setRequestFocusEnabled(false);
        this.m_jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProductLineEdit.this.m_jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jButtonCancel);
        this.jPanel5.add((Component)this.jPanel1, "South");
        this.getContentPane().add((Component)this.jPanel5, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel4.add(this.m_jKeys);
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.getContentPane().add((Component)this.jPanel3, "East");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 580) / 2, (screenSize.height - 362) / 2, 580, 362);
    }

    private void m_jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void m_jButtonOKActionPerformed(ActionEvent evt) {
        this.returnLine = this.m_oLine;
        this.dispose();
    }

    private class RecalculateName
    implements PropertyChangeListener {
        private RecalculateName() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JProductLineEdit.this.m_oLine.setProperty("product.name", JProductLineEdit.this.m_jName.getText());
        }
    }

    private class RecalculatePriceTax
    implements PropertyChangeListener {
        private RecalculatePriceTax() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Double value = JProductLineEdit.this.m_jPriceTax.getDoubleValue();
            if (value == null) {
                JProductLineEdit.this.m_bpriceok = false;
            } else {
                JProductLineEdit.this.m_oLine.setPriceTax(value);
                JProductLineEdit.this.m_jPrice.setDoubleValue(JProductLineEdit.this.m_oLine.getSalePrice());
                JProductLineEdit.this.m_bpriceok = true;
            }
            JProductLineEdit.this.printTotals();
        }
    }

    private class RecalculatePrice
    implements PropertyChangeListener {
        private RecalculatePrice() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Double value = JProductLineEdit.this.m_jPrice.getDoubleValue();
            if (value == null) {
                JProductLineEdit.this.m_bpriceok = false;
            } else {
                JProductLineEdit.this.m_oLine.setSalePrice(value);
                JProductLineEdit.this.m_jPriceTax.setDoubleValue(JProductLineEdit.this.m_oLine.getPriceTax());
                JProductLineEdit.this.m_bpriceok = true;
            }
            JProductLineEdit.this.printTotals();
        }
    }

    private class RecalculateUnits
    implements PropertyChangeListener {
        private RecalculateUnits() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Double value = JProductLineEdit.this.m_jUnits.getDoubleValue();
            if (value == null || value == 0.0) {
                JProductLineEdit.this.m_bunitsok = false;
            } else {
                JProductLineEdit.this.m_oLine.setMultiply(value);
                JProductLineEdit.this.m_bunitsok = true;
            }
            JProductLineEdit.this.printTotals();
        }
    }
}

