/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.data.gui.JMessageDialog;
import com.posics.data.gui.MessageInf;
import com.posics.editor.JEditorIntegerPositive;
import com.posics.editor.JEditorKeys;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.panels.JTicketsFinder;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.reports.PanelReportBean;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JPanelButtons;
import com.posics.pos.sales.JPanelTicketEdits;
import com.posics.pos.sales.JTicketsBag;
import com.posics.pos.sales.JTicketsBagTicketBag;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.FindTicketsInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.util.JRViewer300;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class JTicketsBagTicket
extends JTicketsBag {
    private DataLogicSystem m_dlSystem = null;
    protected DataLogicCustomers dlCustomers = null;
    private DataLogicReceipts dlReceipts = null;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private TicketParser m_TTP2;
    private TicketInfo m_ticket;
    private TicketInfo m_ticketCopy;
    private JTicketsBagTicketBag m_TicketsBagTicketBag;
    private JPanelTicketEdits m_panelticketedit;
    private JRViewer300 reportviewer = null;
    private AppView m_app;
    protected JPanelButtons m_jbtnconfig;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRadioButton jrbRefunds;
    private JRadioButton jrbSales;
    private JPanel m_jButtons;
    private JButton m_jEdit;
    private JEditorKeys m_jKeys;
    private JPanel m_jOptions;
    private JPanel m_jPanelTicket;
    private JButton m_jPrint;
    private JButton m_jPrintInvoice;
    private JButton m_jRefund;
    private JButton m_jSearch;
    private JEditorIntegerPositive m_jTicketEditor;
    private JLabel m_jTicketId;

    public JTicketsBagTicket(AppView app, JPanelTicketEdits panelticket) {
        super(app, panelticket);
        this.m_panelticketedit = panelticket;
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.m_app = app;
        this.m_TP = new DeviceTicket();
        this.m_TTP = new TicketParser(this.m_TP, this.m_dlSystem);
        this.m_TTP2 = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
        this.initComponents();
        this.m_TicketsBagTicketBag = new JTicketsBagTicketBag(this);
        this.m_jTicketEditor.addEditorKeys(this.m_jKeys);
    }

    @Override
    public void activate() {
        this.m_ticket = null;
        this.m_ticketCopy = null;
        this.printTicket();
        this.m_jTicketEditor.reset();
        this.m_jTicketEditor.activate();
        this.m_panelticketedit.setActiveTicket(null, null);
        this.jrbSales.setSelected(true);
        this.m_jEdit.setVisible(this.m_App.getAppUserView().getUser().hasPermission("sales.EditTicket"));
        this.m_jRefund.setVisible(this.m_App.getAppUserView().getUser().hasPermission("sales.RefundTicket"));
        this.m_jPrint.setVisible(this.m_App.getAppUserView().getUser().hasPermission("sales.PrintTicket"));
        this.m_jPrintInvoice.setVisible(this.m_App.getAppUserView().getUser().hasPermission("sales.PrintInvoice"));
    }

    @Override
    public boolean deactivate() {
        this.m_ticket = null;
        this.m_ticketCopy = null;
        return true;
    }

    @Override
    public int getBillingMode() {
        return 0;
    }

    @Override
    public void deleteTicket() {
        if (this.m_ticketCopy != null) {
            try {
                this.m_dlSales.deleteTicket(this.m_ticketCopy, this.m_App.getInventoryLocation());
            }
            catch (BasicException eData) {
                MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosaveticket"), eData);
                msg.show(this);
            }
        }
        this.m_ticket = null;
        this.m_ticketCopy = null;
        this.resetToTicket();
    }

    public void canceleditionTicket() {
        this.m_ticketCopy = null;
        this.resetToTicket();
    }

    private void resetToTicket() {
        this.printTicket();
        this.m_jTicketEditor.reset();
        this.m_jTicketEditor.activate();
        this.m_panelticketedit.setActiveTicket(null, null);
    }

    @Override
    protected JComponent getBagComponent() {
        return this.m_TicketsBagTicketBag;
    }

    @Override
    protected JComponent getNullComponent() {
        return this;
    }

    private void readTicket(int iTicketid, int iTickettype) {
        try {
            TicketInfo ticket;
            TicketInfo ticketInfo = ticket = iTicketid == -1 ? this.m_dlSales.loadTicket(iTickettype, this.m_jTicketEditor.getValueInteger()) : this.m_dlSales.loadTicket(iTickettype, iTicketid);
            if (ticket == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.notexiststicket"));
                msg.show(this);
            } else {
                this.m_ticket = ticket;
                this.m_ticketCopy = null;
                this.printTicket();
            }
        }
        catch (BasicException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), e);
            msg.show(this);
        }
        this.m_jTicketEditor.reset();
        this.m_jTicketEditor.activate();
    }

    private void printTicket() {
        if (this.m_App.getAppUserView().getUser().hasPermission("editsales.EditClosedTicket")) {
            try {
                this.m_jEdit.setEnabled(this.m_ticket != null && (this.m_ticket.getTicketType() == 0 || this.m_ticket.getTicketType() == 1));
            }
            catch (Exception e) {
                this.m_jEdit.setEnabled(false);
            }
        } else {
            try {
                this.m_jEdit.setEnabled(this.m_ticket != null && (this.m_ticket.getTicketType() == 0 || this.m_ticket.getTicketType() == 1) && this.m_dlSales.isCashActive(this.m_ticket.getActiveCash()));
            }
            catch (BasicException e) {
                this.m_jEdit.setEnabled(false);
            }
        }
        this.m_jRefund.setEnabled(this.m_ticket != null && this.m_ticket.getTicketType() == 0);
        this.m_jPrint.setEnabled(this.m_ticket != null);
        this.m_jPrintInvoice.setEnabled(this.m_ticket != null);
        this.m_TP.getDevicePrinter("1").reset();
        this.m_jPanelTicket.removeAll();
        this.m_jPanelTicket.add((Component)this.m_TP.getDevicePrinter("1").getPrinterComponent(), "Center");
        this.m_jPanelTicket.repaint();
        if (this.m_ticket == null) {
            this.m_jTicketId.setText(null);
        } else {
            this.m_jTicketId.setText(this.m_ticket.getName());
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", this.m_ticket);
                this.m_TTP.printTicket(script.eval(this.m_dlSystem.getResourceAsXML("Printer.TicketPreview")).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException eTP) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), eTP);
                msg.show(this);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.m_jOptions = new JPanel();
        this.m_jButtons = new JPanel();
        this.m_jTicketId = new JLabel();
        this.m_jSearch = new JButton();
        this.m_jEdit = new JButton();
        this.m_jRefund = new JButton();
        this.m_jPrint = new JButton();
        this.m_jPrintInvoice = new JButton();
        this.jPanel2 = new JPanel();
        this.m_jPanelTicket = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel5 = new JPanel();
        this.jButton1 = new JButton();
        this.m_jTicketEditor = new JEditorIntegerPositive();
        this.jPanel1 = new JPanel();
        this.jrbSales = new JRadioButton();
        this.jrbRefunds = new JRadioButton();
        this.setLayout(new BorderLayout());
        this.m_jOptions.setLayout(new BorderLayout());
        this.m_jButtons.setLayout(new FlowLayout(0));
        this.m_jTicketId.setBackground(Color.white);
        this.m_jTicketId.setHorizontalAlignment(0);
        this.m_jTicketId.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTicketId.setOpaque(true);
        this.m_jTicketId.setPreferredSize(new Dimension(160, 25));
        this.m_jTicketId.setRequestFocusEnabled(false);
        this.m_jButtons.add(this.m_jTicketId);
        this.m_jSearch.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/search.png")));
        this.m_jSearch.setText(AppLocal.getIntString("label.search"));
        this.m_jSearch.setFocusPainted(false);
        this.m_jSearch.setFocusable(false);
        this.m_jSearch.setMargin(new Insets(8, 14, 8, 14));
        this.m_jSearch.setRequestFocusEnabled(false);
        this.m_jSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jSearchActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jSearch);
        this.m_jEdit.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/edit.png")));
        this.m_jEdit.setText(AppLocal.getIntString("button.edit"));
        this.m_jEdit.setFocusPainted(false);
        this.m_jEdit.setFocusable(false);
        this.m_jEdit.setMargin(new Insets(8, 14, 8, 14));
        this.m_jEdit.setRequestFocusEnabled(false);
        this.m_jEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jEditActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jEdit);
        this.m_jRefund.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/refund16.png")));
        this.m_jRefund.setText(AppLocal.getIntString("button.refund"));
        this.m_jRefund.setFocusPainted(false);
        this.m_jRefund.setFocusable(false);
        this.m_jRefund.setMargin(new Insets(8, 14, 8, 14));
        this.m_jRefund.setRequestFocusEnabled(false);
        this.m_jRefund.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jRefundActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jRefund);
        this.m_jPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer.png")));
        this.m_jPrint.setText(AppLocal.getIntString("button.print"));
        this.m_jPrint.setFocusPainted(false);
        this.m_jPrint.setFocusable(false);
        this.m_jPrint.setMargin(new Insets(8, 14, 8, 14));
        this.m_jPrint.setRequestFocusEnabled(false);
        this.m_jPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jPrintActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jPrint);
        this.m_jPrintInvoice.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/mime.png")));
        this.m_jPrintInvoice.setText(AppLocal.getIntString("button.printinvoice"));
        this.m_jPrintInvoice.setFocusPainted(false);
        this.m_jPrintInvoice.setFocusable(false);
        this.m_jPrintInvoice.setMargin(new Insets(8, 14, 8, 14));
        this.m_jPrintInvoice.setRequestFocusEnabled(false);
        this.m_jPrintInvoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jPrintInvoiceActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jPrintInvoice);
        this.m_jOptions.add((Component)this.m_jButtons, "West");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.m_jOptions.add((Component)this.jPanel2, "Center");
        this.add((Component)this.m_jOptions, "North");
        this.m_jPanelTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanelTicket.setLayout(new BorderLayout());
        this.add((Component)this.m_jPanelTicket, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.m_jKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.m_jKeysActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.m_jKeys);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setMargin(new Insets(8, 14, 8, 14));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagTicket.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel5.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.m_jTicketEditor, gridBagConstraints);
        this.jPanel4.add(this.jPanel5);
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.buttonGroup1.add(this.jrbSales);
        this.jrbSales.setText(AppLocal.getIntString("label.sales"));
        this.jrbSales.setFocusPainted(false);
        this.jrbSales.setFocusable(false);
        this.jrbSales.setRequestFocusEnabled(false);
        this.jPanel1.add(this.jrbSales);
        this.buttonGroup1.add(this.jrbRefunds);
        this.jrbRefunds.setText(AppLocal.getIntString("label.refunds"));
        this.jrbRefunds.setFocusPainted(false);
        this.jrbRefunds.setFocusable(false);
        this.jrbRefunds.setRequestFocusEnabled(false);
        this.jPanel1.add(this.jrbRefunds);
        this.jPanel3.add((Component)this.jPanel1, "Center");
        this.add((Component)this.jPanel3, "East");
    }

    private void m_jEditActionPerformed(ActionEvent evt) {
        this.m_ticketCopy = this.m_ticket;
        this.m_TicketsBagTicketBag.showEdit();
        if (this.m_App.getAppUserView().getUser().hasPermission("editsales.EditClosedTicket")) {
            this.m_panelticketedit.setEditClosedticket(true);
        } else {
            this.m_panelticketedit.setEditClosedticket(false);
        }
        this.m_panelticketedit.showCatalog();
        this.m_panelticketedit.setActiveTicket(this.m_ticket.copyTicket(), null);
    }

    private void m_jPrintActionPerformed(ActionEvent evt) {
        if (this.m_ticket != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", this.m_ticket);
                this.m_TTP2.printTicket(script.eval(this.m_dlSystem.getResourceAsXML("Printer.TicketPreview")).toString());
            }
            catch (ScriptException e) {
                JMessageDialog.showMessage(this, new MessageInf(-67108864, AppLocal.getIntString("message.cannotprint"), e));
            }
            catch (TicketPrinterException e) {
                JMessageDialog.showMessage(this, new MessageInf(-67108864, AppLocal.getIntString("message.cannotprint"), e));
            }
        }
    }

    private void m_jRefundActionPerformed(ActionEvent evt) {
        ArrayList<TicketLineInfo> aRefundLines = new ArrayList<TicketLineInfo>();
        for (int i = 0; i < this.m_ticket.getLinesCount(); ++i) {
            TicketLineInfo newline = new TicketLineInfo(this.m_ticket.getLine(i));
            aRefundLines.add(newline);
        }
        this.m_ticketCopy = null;
        this.m_TicketsBagTicketBag.showRefund();
        this.m_panelticketedit.showRefundLines(aRefundLines);
        TicketInfo refundticket = new TicketInfo();
        refundticket.setTicketType(1);
        refundticket.setCustomer(this.m_ticket.getCustomer());
        refundticket.setProperty("RECEIPT", this.m_ticket.printId());
        refundticket.setPayments(this.m_ticket.getPayments());
        this.m_panelticketedit.setActiveTicket(refundticket, null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.readTicket(-1, this.jrbSales.isSelected() ? 0 : 1);
    }

    private void m_jKeysActionPerformed(ActionEvent evt) {
        this.readTicket(-1, this.jrbSales.isSelected() ? 0 : 1);
    }

    private void m_jSearchActionPerformed(ActionEvent evt) {
        JTicketsFinder finder = JTicketsFinder.getReceiptFinder(this, this.m_dlSales, this.dlCustomers);
        finder.setVisible(true);
        FindTicketsInfo selectedTicket = finder.getSelectedCustomer();
        if (selectedTicket == null) {
            this.m_jTicketEditor.reset();
            this.m_jTicketEditor.activate();
        } else {
            this.readTicket(selectedTicket.getTicketId(), selectedTicket.getTicketType());
        }
    }

    private void m_jPrintInvoiceActionPerformed(ActionEvent evt) {
        this.m_App.waitCursorBegin();
        String resourcefile = "/com/posics/reports/ticketinvoice";
        PanelReportBean report = new PanelReportBean();
        report.setReport(resourcefile);
        try {
            JasperReport jr;
            InputStream in = this.getClass().getResourceAsStream(resourcefile + ".ser");
            if (in == null) {
                JasperDesign jd = JRXmlLoader.load((InputStream)this.getClass().getResourceAsStream(resourcefile + ".jrxml"));
                jr = JasperCompileManager.compileReport((JasperDesign)jd);
            } else {
                ObjectInputStream oin = new ObjectInputStream(in);
                jr = (JasperReport)oin.readObject();
                oin.close();
            }
            HashMap<String, Double> reportparams = new HashMap<String, Double>();
            reportparams.put("TAXESLOGIC", this.m_ticket.getTax());
            HashMap<String, Object> reportfields = new HashMap<String, Object>();
            reportfields.put("TICKET", this.m_ticket);
            reportfields.put("PLACE", new File(System.getProperty("user.home")).toURI().toURL() + "invoice.png");
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, reportparams, (JRDataSource)new JRMapArrayDataSource(new Object[]{reportfields}));
            this.reportviewer = new JRViewer300(null);
            this.reportviewer.isOnline = this.m_App.isOnline();
            this.m_jPanelTicket.removeAll();
            this.m_jPanelTicket.add((Component)this.reportviewer, "Center");
            this.m_jPanelTicket.repaint();
            this.reportviewer.loadJasperPrint(jp);
        }
        catch (Exception ex) {
            JMessageDialog.showMessage(this, new MessageInf(-67108864, AppLocal.getIntString("message.cannotprint"), ex));
        }
        this.m_App.waitCursorEnd();
    }
}

