/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.format.Formats;

public class UnPaidTicketInfo
implements SerializableRead,
SerializableWrite {
    private static final long serialVersionUID = 7640633837719L;
    private String id;
    private int ticketid;
    private String ticketdate;
    private String ticketplace;
    private String customername;
    private double ticketamount;

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.id = dr.getString(1);
        this.ticketid = dr.getInt(2);
        this.ticketdate = dr.getString(3).replace(".0", "");
        this.ticketplace = dr.getString(4) != null ? dr.getString(4) : "";
        this.ticketamount = dr.getDouble(5);
        this.customername = dr.getString(6) != null ? dr.getString(6) : "";
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.id);
        dp.setInt(2, this.ticketid);
        dp.setString(3, this.ticketdate);
        dp.setString(4, this.ticketplace);
        dp.setDouble(5, this.ticketamount);
        dp.setString(6, this.customername);
    }

    public String getId() {
        return this.id;
    }

    public int getTicketId() {
        return this.ticketid;
    }

    public String getDate() {
        return this.ticketdate;
    }

    public Double getAmount() {
        return this.ticketamount;
    }

    public String printAmount() {
        return Formats.CURRENCY.formatValue(this.ticketamount);
    }

    public String getCustomer() {
        return this.customername;
    }

    public String getName() {
        if (this.ticketplace.trim().length() > 0 && this.customername.trim().length() > 0) {
            return "<html><center>" + this.ticketid + "<br>" + this.ticketdate + "<br>" + this.ticketplace + "-" + this.customername + "<br>" + Formats.CURRENCY.formatValue(this.ticketamount);
        }
        if (this.ticketplace.trim().length() > 0) {
            return "<html><center>" + this.ticketid + "<br>" + this.ticketdate + "<br>" + this.ticketplace + "<br>" + Formats.CURRENCY.formatValue(this.ticketamount);
        }
        if (this.customername.trim().length() > 0) {
            return "<html><center>" + this.ticketid + "<br>" + this.ticketdate + "<br>" + this.customername + "<br>" + Formats.CURRENCY.formatValue(this.ticketamount);
        }
        return "<html><center>" + this.ticketid + "<br>" + this.ticketdate + "<br>" + Formats.CURRENCY.formatValue(this.ticketamount);
    }
}

