/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.posics.basic.BasicException;
import com.posics.data.gui.NullIcon;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.sales.restaurant.Place;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class DeliveryCall
implements SerializableRead,
SerializableWrite {
    private static final long serialVersionUID = 8652254694281L;
    private static final Icon ICO_OCU = new ImageIcon(Place.class.getResource("/com/posics/images/edit_group.png"));
    private static final Icon ICO_OCU_RED = new ImageIcon(Place.class.getResource("/com/posics/images/customerred.png"));
    private static final Icon ICO_FRE = new NullIcon(22, 22);
    public static final int CALL_INCOMING = 0;
    public static final int CALL_ORDERTAKEN = 1;
    public static final int CALL_BILLGENERATED = 2;
    public static final int CALL_DELIVERED = 3;
    private static DateFormat m_dateformat = new SimpleDateFormat("hh:mm a");
    private String m_sId;
    private String m_sCallerId;
    private Date m_dDate;
    private String m_sLine;
    private String m_sMoney;
    private int m_iStatus;
    private boolean m_bOrder;
    private JButton m_btn;
    private String m_sCustomerId;
    private String m_sDeliveryId;
    private String m_sReceiptId;
    private CustomerInfoExt m_Customer;
    private String m_sDriver;
    private JLabel m_lblTimer;
    private Date m_dTimer;

    public DeliveryCall(String callerid, String line, String activecash, String customerid) {
        this.m_sId = UUID.randomUUID().toString();
        this.m_sCallerId = callerid;
        this.m_sLine = line;
        this.m_dDate = new Date();
        this.m_iStatus = 0;
        this.m_sMoney = activecash;
        this.m_sCustomerId = customerid;
    }

    public DeliveryCall() {
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sId = dr.getString(1);
        this.m_sCallerId = dr.getString(2);
        this.m_dDate = dr.getTimestamp(3);
        this.m_sLine = dr.getString(4);
        this.m_sMoney = dr.getString(5);
        this.m_sCustomerId = dr.getString(6);
        if (dr.getString(7) != null) {
            this.m_sDeliveryId = dr.getString(7);
            this.m_sReceiptId = dr.getString(8);
            this.m_iStatus = dr.getInt(9);
        } else {
            this.m_sDeliveryId = null;
            this.m_sReceiptId = null;
            this.m_iStatus = 0;
        }
        this.m_sDriver = dr.getString(10);
        this.m_bOrder = false;
        this.m_btn = new JButton();
        this.m_lblTimer = new JLabel();
        this.m_btn.setFocusPainted(false);
        this.m_btn.setFocusable(false);
        this.m_btn.setRequestFocusEnabled(false);
        this.m_btn.setHorizontalTextPosition(0);
        this.m_btn.setVerticalTextPosition(3);
        this.m_btn.setIcon(ICO_FRE);
        this.m_btn.setText(this.m_sCallerId);
        this.m_lblTimer.setMinimumSize(this.m_btn.getMinimumSize());
        this.m_lblTimer.setPreferredSize(this.m_btn.getPreferredSize());
        this.m_lblTimer.setMaximumSize(this.m_btn.getMaximumSize());
        this.m_lblTimer.setHorizontalAlignment(4);
        this.m_lblTimer.setVerticalAlignment(1);
        this.m_lblTimer.setBorder(null);
        this.m_lblTimer.setForeground(Color.blue);
        this.m_btn.setMargin(new Insets(0, 0, 0, 0));
        this.m_btn.add((Component)this.m_lblTimer, "Center");
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.m_sId);
        dp.setString(2, this.m_sCallerId);
        dp.setTimestamp(3, this.m_dDate);
        dp.setString(4, this.m_sLine);
        dp.setInt(5, this.m_iStatus);
    }

    public String getCallerId() {
        return this.m_sCallerId;
    }

    public String getDeliveryId() {
        return this.m_sDeliveryId;
    }

    public void setDeliveryId(String did) {
        this.m_sDeliveryId = did;
    }

    public String getReceiptId() {
        return this.m_sReceiptId;
    }

    public String getId() {
        return this.m_sId;
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public int getStatus() {
        return this.m_iStatus;
    }

    public String getMoney() {
        return this.m_sMoney;
    }

    public void setStatus(int status) {
        this.m_iStatus = status;
    }

    public String getCallId() {
        return new SimpleDateFormat("HHmmss").format(this.m_dDate);
    }

    public String getLine() {
        return this.m_sLine;
    }

    public void setOrder(boolean bValue) {
        this.m_bOrder = bValue;
        this.m_btn.setIcon(bValue ? ICO_OCU : ICO_FRE);
    }

    public boolean hasOrder() {
        return this.m_bOrder;
    }

    public JButton getButton() {
        return this.m_btn;
    }

    public void setButton(JButton jbt) {
        this.m_btn = jbt;
    }

    public String getCustomerId() {
        return this.m_sCustomerId;
    }

    public CustomerInfoExt getCustomer() {
        return this.m_Customer;
    }

    public void setCustomer(CustomerInfoExt customer) {
        this.m_Customer = customer;
    }

    public String getName() {
        StringBuffer name = new StringBuffer();
        name.append("<html><center>");
        name.append("(" + m_dateformat.format(this.m_dDate) + ")");
        if (this.m_Customer != null) {
            name.append(" " + this.m_sCallerId);
            name.append("<br>" + this.m_Customer.getName());
            if (this.m_Customer.getAddress() != null) {
                name.append("<br>" + this.m_Customer.getAddress());
            }
        } else {
            name.append("<br>" + this.m_sCallerId);
        }
        if (this.m_sDriver != null) {
            name.append("<br>Dv. " + this.m_sDriver);
        }
        return name.toString();
    }

    public void setTimer(Date date) {
        this.m_dTimer = date;
    }

    public long getCounter() {
        if (this.m_dTimer != null) {
            long tStart = this.m_dTimer.getTime();
            long tEnd = System.currentTimeMillis();
            long tElapsed = tEnd - tStart;
            long tMinutes = TimeUnit.MILLISECONDS.toMinutes(tElapsed);
            return tMinutes;
        }
        return 0L;
    }
}

