/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.posics.basic.BasicException;
import com.posics.data.gui.NullIcon;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.pos.sales.restaurant.Place;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class DeliveryOrder
implements SerializableRead,
SerializableWrite {
    private static final long serialVersionUID = 8652254694281L;
    private static final Icon ICO_OCU = new ImageIcon(Place.class.getResource("/com/posics/images/edit_group.png"));
    private static final Icon ICO_FRE = new NullIcon(22, 22);
    public static final int DO_PENDING = 0;
    public static final int DO_READY = 1;
    public static final int DO_DELIVERED = 2;
    public static final int DO_RETURNED = 3;
    private String m_sId;
    private String m_sCallId;
    private String m_sLine;
    private String m_sDriver;
    private int m_iStatus;
    private JButton m_btn;
    private String customername = "";

    public DeliveryOrder(String callerid, String line, String driver) {
        this.m_sId = UUID.randomUUID().toString();
        this.m_sCallId = callerid;
        this.m_sLine = line;
        this.m_iStatus = 0;
        this.m_sDriver = driver;
    }

    public DeliveryOrder() {
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sId = dr.getString(1);
        this.m_sCallId = dr.getString(2);
        this.m_sDriver = dr.getString(3);
        this.m_iStatus = dr.getInt(4);
        this.m_btn = new JButton();
        this.m_btn.setFocusPainted(false);
        this.m_btn.setFocusable(false);
        this.m_btn.setRequestFocusEnabled(false);
        this.m_btn.setHorizontalTextPosition(0);
        this.m_btn.setVerticalTextPosition(3);
        this.m_btn.setIcon(ICO_FRE);
        this.m_btn.setText(this.m_sCallId);
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.m_sId);
        dp.setString(2, this.m_sCallId);
        dp.setString(3, this.m_sLine);
        dp.setInt(4, this.m_iStatus);
    }

    public String getCallId() {
        return this.m_sCallId;
    }

    public String getId() {
        return this.m_sId;
    }

    public int getStatus() {
        return this.m_iStatus;
    }

    public String getDriver() {
        return this.m_sDriver;
    }

    public void setStatus(int status) {
        this.m_iStatus = status;
    }

    public String getLine() {
        return this.m_sLine;
    }

    public String getName() {
        if (this.customername.trim().length() > 0) {
            return "<html><center>" + this.customername + "<br>" + this.m_sCallId + "<br>";
        }
        return "<html><center>" + this.m_sCallId + "<br>";
    }

    public JButton getButton() {
        return this.m_btn;
    }
}

