/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.posics.basic.BasicException;
import com.posics.data.user.DirtyManager;
import com.posics.data.user.EditorRecord;
import com.posics.format.Formats;
import com.posics.pos.forms.AppLocal;
import java.awt.Component;
import java.util.UUID;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DriverEditor
extends JPanel
implements EditorRecord {
    private String m_sID;
    private DirtyManager m_dirty;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField m_jCode;
    private JTextField m_jName;

    public DriverEditor(DirtyManager dirty) {
        this.initComponents();
        this.m_dirty = dirty;
        this.m_jName.getDocument().addDocumentListener(dirty);
        this.m_jCode.getDocument().addDocumentListener(dirty);
        this.writeValueEOF();
    }

    @Override
    public void writeValueEOF() {
        this.m_sID = null;
        this.m_jName.setText(null);
        this.m_jCode.setText(null);
        this.m_jName.setEnabled(false);
        this.m_jCode.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_sID = UUID.randomUUID().toString();
        this.m_jName.setText(null);
        this.m_jCode.setText(null);
        this.m_jName.setEnabled(true);
        this.m_jCode.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object value) {
        Object[] bank = (Object[])value;
        this.m_sID = Formats.STRING.formatValue(bank[0]);
        this.m_jName.setText(Formats.STRING.formatValue(bank[1]));
        this.m_jCode.setText(Formats.STRING.formatValue(bank[2]));
        this.m_jName.setEnabled(false);
        this.m_jCode.setEnabled(false);
    }

    @Override
    public void writeValueEdit(Object value) {
        Object[] bank = (Object[])value;
        this.m_sID = Formats.STRING.formatValue(bank[0]);
        this.m_jName.setText(Formats.STRING.formatValue(bank[1]));
        this.m_jCode.setText(Formats.STRING.formatValue(bank[2]));
        this.m_jName.setEnabled(true);
        this.m_jCode.setEnabled(true);
        this.m_dirty.setDirty(false);
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] bank = new Object[]{this.m_sID, this.m_jName.getText(), this.m_jCode.getText()};
        return bank;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void refresh() {
    }

    private void initComponents() {
        this.m_jName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.m_jCode = new JTextField();
        this.setLayout(null);
        this.add(this.m_jName);
        this.m_jName.setBounds(100, 20, 200, 25);
        this.jLabel2.setText(AppLocal.getIntString("driver.name"));
        this.add(this.jLabel2);
        this.jLabel2.setBounds(20, 20, 80, 25);
        this.jLabel3.setText(AppLocal.getIntString("driver.code"));
        this.add(this.jLabel3);
        this.jLabel3.setBounds(20, 50, 80, 25);
        this.add(this.m_jCode);
        this.m_jCode.setBounds(100, 50, 60, 25);
    }
}

