/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JOrderHistory
extends JDialog {
    private TicketInfo m_ticket;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private JLabel jLblCustomer;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel8;
    private JButton jcmdCancel;
    private JPanel m_jOptions;
    private JPanel m_jPanelTicket;

    private JOrderHistory(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JOrderHistory(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    public static JOrderHistory getOrderHistory(Component parent, DataLogicSystem m_dlSystem, TicketInfo ti) {
        Window window = JOrderHistory.getWindow(parent);
        JOrderHistory myMsg = window instanceof Frame ? new JOrderHistory((Frame)window, true) : new JOrderHistory((Dialog)window, true);
        myMsg.init(m_dlSystem, ti);
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        return myMsg;
    }

    public TicketInfo getSelectedTicket() {
        return this.m_ticket;
    }

    private void init(DataLogicSystem m_dlSystem, TicketInfo ti) {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        if (ti != null) {
            this.m_TP = new DeviceTicket();
            this.m_TTP = new TicketParser(this.m_TP, m_dlSystem);
            this.m_TP.getDevicePrinter("1").reset();
            this.m_jPanelTicket.removeAll();
            this.m_jPanelTicket.add((Component)this.m_TP.getDevicePrinter("1").getPrinterComponent(), "Center");
            this.m_jPanelTicket.repaint();
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", ti);
                this.m_TTP.printTicket(script.eval(m_dlSystem.getResourceAsXML("Printer.TicketPreview")).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException eTP) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), eTP);
                msg.show(this);
            }
            this.jLblCustomer.setBackground(Color.white);
            if (ti.getCustomer() != null) {
                String customerinfo = "<html>" + ti.getCustomer().getName() + "<br>" + ti.getCustomer().getSearchkey();
                if (ti.getCustomer().getAddress() != null) {
                    customerinfo = customerinfo + "<br>" + ti.getCustomer().getAddress();
                }
                if (ti.getCustomer().getAddress2() != null) {
                    customerinfo = customerinfo + "<br>" + ti.getCustomer().getAddress2();
                }
                this.jLblCustomer.setText(customerinfo);
            }
        }
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JOrderHistory.getWindow(parent.getParent());
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.m_jOptions = new JPanel();
        this.jLblCustomer = new JLabel();
        this.m_jPanelTicket = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jcmdCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("label.ticketid"));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.m_jOptions.setLayout(new BorderLayout());
        this.jLblCustomer.setBackground(new Color(255, 255, 255));
        this.jLblCustomer.setOpaque(true);
        this.m_jOptions.add((Component)this.jLblCustomer, "First");
        this.jPanel4.add((Component)this.m_jOptions, "North");
        this.m_jPanelTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanelTicket.setLayout(new BorderLayout());
        this.jPanel4.add((Component)this.m_jPanelTicket, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel8.setLayout(new BorderLayout());
        this.jcmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jcmdCancel.setText(AppLocal.getIntString("Button.OK"));
        this.jcmdCancel.setFocusPainted(false);
        this.jcmdCancel.setFocusable(false);
        this.jcmdCancel.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel.setRequestFocusEnabled(false);
        this.jcmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JOrderHistory.this.jcmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel);
        this.jPanel8.add((Component)this.jPanel1, "After");
        this.jPanel3.add((Component)this.jPanel8, "South");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.setSize(new Dimension(437, 647));
        this.setLocationRelativeTo(null);
    }

    private void jcmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

