/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.codeminders.hidapi.AD101;
import com.codeminders.hidapi.AD102;
import com.codeminders.hidapi.ClassPathLibraryLoader;
import com.codeminders.hidapi.HIDDeviceInfo;
import com.codeminders.hidapi.HIDManager;
import com.codeminders.hidapi.LineMessage;
import com.posics.basic.BasicException;
import com.posics.beans.JNumberEvent;
import com.posics.beans.JNumberEventListener;
import com.posics.beans.JTelephoneKeys;
import com.posics.data.gui.ListKeyed;
import com.posics.data.gui.MessageInf;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.customers.DataLogicCustomers;
import com.posics.pos.customers.JCustomerFinder;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.printer.TicketParser;
import com.posics.pos.printer.TicketPrinterException;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JTicketsBag;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.TicketsEditor;
import com.posics.pos.sales.delivery.DeliveryCall;
import com.posics.pos.sales.delivery.DriverInfo;
import com.posics.pos.sales.delivery.JCallTab;
import com.posics.pos.sales.delivery.JOrderHistory;
import com.posics.pos.sales.delivery.JTicketsBagDeliveryMenu;
import com.posics.pos.sales.delivery.SelectCall;
import com.posics.pos.sales.delivery.SelectDriver;
import com.posics.pos.sales.restaurant.Place;
import com.posics.pos.sales.restaurant.SelectTable;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.ThumbNailBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JTicketsBagDelivery
extends JTicketsBag {
    private JTicketsBagDeliveryMenu m_delivery;
    private DeliveryCall m_CallCurrent;
    private DataLogicReceipts dlReceipts = null;
    private DataLogicSales dlSales = null;
    private DataLogicCustomers dlCustomers;
    protected DataLogicSystem dlSystem;
    private ListKeyed taxcollection;
    private TaxesLogic taxeslogic;
    private TicketParser m_TTP;
    private ThumbNailBuilder tnbbutton;
    private JCallTab jcallTab;
    private JCallTab jpendingTab;
    private JCallTab jreadyTab;
    private List<DeliveryCall> calllog;
    private StringBuffer m_sBarcode;
    private String deviceid;
    private AD101 ti1;
    private AD102 ti2;
    private LineObserver lineObserver;
    private ArrayList<String> devicepaths;
    private ArrayList<JLabel> lineLabels;
    private ImageIcon lineIcon;
    private static boolean isHIDLibLoaded = false;
    private String ticketbuttons;
    private String m_sLastCallerID = "";
    private Date m_dLastCallerDate = new Date();
    private SimpleDateFormat simpleDate = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    public int previLineStatus = 0;
    private String m_sCallLabel;
    private boolean m_blTimer = false;
    private int m_iAlertAfter = 0;
    private static final int INTERVAL = 60000;
    private Timer timer;
    SelectCall selectcall;
    private JPanel jPanel2;
    private JPanel jPanel9;
    private JSplitPane jSplitPane2;
    private JTelephoneKeys jTelephoneKeys1;
    private JPanel m_jButtons;
    private JLabel m_jCallerId;
    private JPanel m_jContEntries;
    private JTextField m_jKeyFactory;
    private JPanel m_jPanEntries;
    private JPanel m_jPanTicket;
    private JPanel m_jPanelCallHistory;
    private JPanel m_jPanelCentral;
    private JPanel m_jPanelMap;
    private JPanel m_jPanelPending;
    private JPanel m_jPanelReady;
    private JButton m_jbtnRefresh;
    private JButton m_jbtnUnlock;

    public JTicketsBagDelivery(AppView app, TicketsEditor panelticket) {
        super(app, panelticket);
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.posics.pos.customers.DataLogicCustomers");
        this.calllog = new ArrayList<DeliveryCall>();
        this.m_delivery = new JTicketsBagDeliveryMenu(app, this);
        this.m_CallCurrent = null;
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.dlSystem);
        this.initComponents();
        this.m_jCallerId.setOpaque(true);
        this.m_jCallerId.setBackground(Color.white);
        String vendor = StringUtils.config.getProperty("telephone.vendor");
        String product = StringUtils.config.getProperty("telephone.product");
        String version = StringUtils.config.getProperty("telephone.version");
        this.deviceid = StringUtils.config.getProperty("telephone.device");
        if (this.deviceid == null) {
            this.deviceid = "1";
        }
        if (isHIDLibLoaded) {
            if (version.equals("1")) {
                if (vendor != null && product != null && !vendor.equals("") && !product.equals("")) {
                    this.openLines(Integer.parseInt(vendor), Integer.parseInt(product), 1);
                } else {
                    this.openLines(1256, 24594, 1);
                }
            } else {
                this.openLines(Integer.parseInt(vendor), Integer.parseInt(product), 2);
            }
        }
        this.ticketbuttons = this.dlSystem.getResourceAsXML("Ticket.Buttons");
        this.ticketbuttons = this.ticketbuttons.replaceAll("(?s)<!--.*?-->", "");
        this.m_sCallLabel = this.dlSystem.getResourceAsXML("Call.Label");
        String strCallTimer = StringUtils.config.getProperty("Call.Timer");
        if (strCallTimer != null && strCallTimer.trim().toLowerCase().equals("true")) {
            this.m_blTimer = true;
        }
        String alertafter = StringUtils.config.getProperty("Call.AlertAfter");
        try {
            this.m_iAlertAfter = Integer.parseInt(alertafter);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.m_iAlertAfter = 20;
        }
        if (this.m_blTimer) {
            this.timer = new Timer(60000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JTicketsBagDelivery.this.loadCalls();
                }
            });
            this.timer.start();
        }
    }

    public final void openLines(int vendorid, int productid, int version) {
        this.devicepaths = new ArrayList();
        this.lineLabels = new ArrayList();
        try {
            HIDManager manager = HIDManager.getInstance();
            HIDDeviceInfo[] devs = manager.listDevices();
            if (devs != null) {
                for (int i = 0; i < devs.length; ++i) {
                    if (devs[i].getVendor_id() != vendorid || devs[i].getProduct_id() != productid) continue;
                    this.devicepaths.add(devs[i].getPath());
                }
                for (int j = 0; j < this.devicepaths.size(); ++j) {
                    try {
                        JLabel lblLine = new JLabel("Line " + (j + 1), new ImageIcon(this.getClass().getResource("/com/posics/images/linedisconnected.png")), 0);
                        this.lineLabels.add(lblLine);
                        this.m_jButtons.add(lblLine);
                        if (version == 1) {
                            this.ti1 = new AD101(this.devicepaths.get(j), j);
                            this.lineObserver = new LineObserver(this.ti1);
                            continue;
                        }
                        this.ti2 = new AD102(this.devicepaths.get(j), j);
                        this.lineObserver = new LineObserver(this.ti2);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void printTicket(String sresourcename, TicketInfo ticket, Object ticketext) {
        String sresource = this.dlSystem.getResourceAsXML(sresourcename);
        if (sresource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("taxes", this.taxcollection);
                script.put("taxeslogic", this.taxeslogic);
                script.put("ticket", ticket);
                script.put("place", ticketext);
                this.m_TTP.printTicket(script.eval(sresource).toString());
            }
            catch (ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
            catch (TicketPrinterException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    private String getTicketXML(DataLogicSystem d, String ticketext, TicketInfo ticket, String TicketResource) {
        String sresource = d.getResourceAsXML(TicketResource);
        if (sresource != null) {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("taxes", this.taxcollection);
                script.put("taxeslogic", this.taxeslogic);
                script.put("ticket", ticket);
                script.put("place", ticketext);
                return script.eval(sresource).toString();
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void activate() {
        this.loadCalls();
        this.stateToZero();
        this.m_panelticket.setActiveTicket(null, null);
        this.m_delivery.activate();
        this.showView("map");
    }

    @Override
    public boolean deactivate() {
        if (this.m_CallCurrent != null && this.m_panelticket.getActiveTicket() != null) {
            try {
                this.dlReceipts.updateSharedTicket(this.m_CallCurrent.getId(), this.m_panelticket.getActiveTicket());
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.loadCalls();
            this.m_panelticket.setActiveTicket(null, null);
        }
        return true;
    }

    @Override
    protected JComponent getBagComponent() {
        return this.m_delivery;
    }

    @Override
    protected JComponent getNullComponent() {
        return this;
    }

    public boolean viewTables(CustomerInfo c) {
        this.showView("map");
        this.loadCalls();
        return true;
    }

    public boolean viewTables() {
        return this.viewTables(null);
    }

    public void newCall(String callerid, String line) {
        long diff = this.m_dLastCallerDate.getTime() - new Date().getTime();
        long diffSeconds = diff / 1000L;
        if (!this.m_sLastCallerID.equals(callerid) || diffSeconds > 30L) {
            try {
                CustomerInfoExt customer = this.dlSales.loadCustomerExt(callerid);
                if (customer == null) {
                    customer = this.dlSales.loadCustomerExt2(callerid);
                }
                if (customer == null) {
                    this.dlReceipts.insertCall(new DeliveryCall(callerid, line, this.m_App.getActiveCashIndex(), null));
                    Toolkit.getDefaultToolkit().beep();
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.dlReceipts.insertCall(new DeliveryCall(callerid, line, this.m_App.getActiveCashIndex(), customer.getId()));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
        }
    }

    public void updateTicket() {
        if (this.m_CallCurrent != null) {
            try {
                this.dlReceipts.updateSharedTicket(this.m_CallCurrent.getId(), this.m_panelticket.getActiveTicket());
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_CallCurrent = null;
        }
        this.loadCalls();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public TicketInfo getLastOrder() {
        if (this.m_panelticket.getActiveTicket() != null && this.m_panelticket.getActiveTicket().getCustomer() != null) {
            try {
                return this.dlSales.geCustomerLastOrder(this.m_panelticket.getActiveTicket().getCustomerId());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int getBillingMode() {
        return 3;
    }

    @Override
    public void deleteTicket() {
        if (this.m_CallCurrent != null) {
            String id = this.m_CallCurrent.getId();
            try {
                this.dlReceipts.deleteSharedTicket(id);
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_CallCurrent = null;
        }
        this.loadCalls();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public void deleteTicket2() {
        try {
            if (!this.ticketbuttons.contains("key=\"ticket.delete\"")) {
                this.dlReceipts.deleteDelivery(this.m_CallCurrent.getDeliveryId());
                this.dlReceipts.updateCallStatus(0, this.m_CallCurrent.getId());
                this.deleteTicket();
            } else {
                String resource = this.dlSystem.getResourceAsXML("event.delete");
                String place = this.m_panelticket.getActiveTicket().getId();
                ScriptObject scr = new ScriptObject(this.m_panelticket.getActiveTicket(), place);
                Object result = scr.evalScript(resource);
                if (result == null) {
                    this.dlReceipts.deleteDelivery(this.m_CallCurrent.getDeliveryId());
                    this.dlReceipts.updateCallStatus(0, this.m_CallCurrent.getId());
                    this.deleteTicket();
                }
            }
        }
        catch (Exception e) {
            MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
        }
    }

    private void stateToZero() {
        this.m_jCallerId.setText("");
        this.m_sBarcode = new StringBuffer();
        this.m_jKeyFactory.requestFocus();
    }

    public void loadCalls() {
        try {
            this.m_jPanelCallHistory.removeAll();
            this.m_jPanelPending.removeAll();
            this.m_jPanelReady.removeAll();
            this.jcallTab = new JCallTab(this.m_iAlertAfter);
            this.jpendingTab = new JCallTab(this.m_iAlertAfter);
            this.jreadyTab = new JCallTab(this.m_iAlertAfter);
            this.jcallTab.applyComponentOrientation(this.getComponentOrientation());
            this.jpendingTab.applyComponentOrientation(this.getComponentOrientation());
            this.jreadyTab.applyComponentOrientation(this.getComponentOrientation());
            this.m_jPanelCallHistory.add((Component)this.jcallTab, "Center");
            this.m_jPanelPending.add((Component)this.jpendingTab, "Center");
            this.m_jPanelReady.add((Component)this.jreadyTab, "Center");
            this.calllog.clear();
            this.calllog = this.dlReceipts.getCallLog(this.m_App.getActiveCashIndex(), this.deviceid);
            this.tnbbutton = new ThumbNailBuilder(170, 50, "com/posics/images/phonecall.png");
            String label = "";
            long timerCount = 0L;
            if (!this.calllog.isEmpty()) {
                for (int i = 0; i < this.calllog.size(); ++i) {
                    TicketInfo ti;
                    if (this.calllog.get(i).getCustomerId() != null) {
                        this.calllog.get(i).setCustomer(this.dlSales.loadCustomerExt(this.calllog.get(i).getCustomerId()));
                    }
                    if (this.calllog.get(i).getStatus() == 2) {
                        if (!this.m_sCallLabel.equals("") || this.m_blTimer) {
                            try {
                                ti = this.dlSales.getReceipt(this.calllog.get(i).getReceiptId());
                                label = !this.m_sCallLabel.equals("") ? this.readCallLabel(ti, this.m_sCallLabel, this.calllog.get(i)) : this.calllog.get(i).getName();
                                if (this.m_blTimer) {
                                    this.calllog.get(i).setTimer(ti.getDate());
                                    timerCount = this.calllog.get(i).getCounter();
                                }
                            }
                            catch (BasicException e) {
                                new MessageInf(e).show(this);
                            }
                        } else {
                            label = this.calllog.get(i).getName();
                        }
                        this.jreadyTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(null, label)), new CallClickListener(this.calllog.get(i), this), this.calllog.get(i).getCallerId(), this.calllog.get(i).getCallId(), this.calllog.get(i).getStatus(), timerCount);
                    } else if (this.calllog.get(i).getStatus() == 1) {
                        if (!this.m_sCallLabel.equals("") || this.m_blTimer) {
                            try {
                                ti = this.dlReceipts.getSharedTicket(this.calllog.get(i).getId());
                                label = !this.m_sCallLabel.equals("") ? this.readCallLabel(ti, this.m_sCallLabel, this.calllog.get(i)) : this.calllog.get(i).getName();
                                if (this.m_blTimer) {
                                    this.calllog.get(i).setTimer(ti.getTimer());
                                    timerCount = this.calllog.get(i).getCounter();
                                }
                            }
                            catch (BasicException e) {
                                new MessageInf(e).show(this);
                            }
                        } else {
                            label = this.calllog.get(i).getName();
                        }
                        this.jpendingTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(null, label)), new CallClickListener(this.calllog.get(i), this), this.calllog.get(i).getCallerId(), this.calllog.get(i).getCallId(), this.calllog.get(i).getStatus(), timerCount);
                    }
                    this.jcallTab.addButton(new ImageIcon(this.tnbbutton.getThumbNailText(null, this.calllog.get(i).getName())), new CallClickListener(this.calllog.get(i), this), this.calllog.get(i).getCallerId(), this.calllog.get(i).getCallId(), this.calllog.get(i).getStatus(), 0L);
                }
                this.m_jPanelCallHistory.revalidate();
                this.m_jPanelPending.revalidate();
                this.m_jPanelReady.revalidate();
            }
            this.m_jKeyFactory.setText(null);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTicketsBagDelivery.this.m_jKeyFactory.requestFocus();
                }
            });
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
        }
    }

    private TicketInfo getSharedTicketInfo(DeliveryCall call) {
        try {
            return this.dlReceipts.getSharedTicket(call.getId());
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
            return null;
        }
    }

    private String readCallLabel(TicketInfo ticket, String strLabel, Object call) {
        try {
            ScriptObject scr = new ScriptObject(ticket, call);
            Object result = scr.evalScript(strLabel);
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
            return "";
        }
    }

    private Properties getTicketInfo(String id) {
        try {
            return this.dlReceipts.getTicketProperties(id);
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
            return null;
        }
    }

    private void setActivePlace(DeliveryCall call, TicketInfo ticket) {
        try {
            if (!(ticket == null || this.selectcall != null && this.selectcall.isVisible())) {
                this.dlReceipts.lockTable(call.getId(), this.m_App.getAppUserView().getUser().getName());
            }
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
        this.m_CallCurrent = call;
        this.m_panelticket.setActiveTicket(ticket, call.getCallerId());
    }

    private void searchCallerID(String sCode) {
        Component[] jbs = this.jcallTab.getButtons();
        ArrayList<JButton> resultbs = new ArrayList<JButton>();
        if (jbs.length > 0) {
            for (int i = 0; i < jbs.length; ++i) {
                JButton jb = (JButton)jbs[i];
                if (!jb.getName().equals(sCode)) continue;
                resultbs.add(jb);
            }
        }
        if (resultbs.size() > 0) {
            if (resultbs.size() == 1) {
                ((JButton)resultbs.get(0)).doClick();
            } else {
                this.selectcall = SelectCall.getSelectDriver(this, resultbs);
                this.selectcall.setVisible(true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            new MessageInf(-33554432, AppLocal.getIntString("message.nocall")).show(this);
        }
    }

    private void searchKOT(String sCode) {
        Component[] jbs = this.jcallTab.getButtons();
        ArrayList<JButton> resultbs = new ArrayList<JButton>();
        if (jbs.length > 0) {
            for (int i = 0; i < jbs.length; ++i) {
                JButton jb = (JButton)jbs[i];
                if (!jb.getToolTipText().equals(sCode)) continue;
                resultbs.add(jb);
            }
        }
        if (resultbs.size() > 0) {
            if (resultbs.size() == 1) {
                ((JButton)resultbs.get(0)).doClick();
            } else {
                this.selectcall = SelectCall.getSelectDriver(this, resultbs);
                this.selectcall.setVisible(true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            new MessageInf(-33554432, AppLocal.getIntString("message.nocall")).show(this);
        }
    }

    private Object evalScript(ScriptObject scr, String resource) {
        try {
            this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
            return scr.evalScript(this.dlSystem.getResourceAsXML(resource));
        }
        catch (ScriptException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e);
            msg.show(this);
            return msg;
        }
    }

    private void showView(String view) {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, view);
    }

    private void stateTransition(char cTrans) {
        if (cTrans == '\n') {
            if (this.m_sBarcode.length() > 0) {
                String sCode = this.m_sBarcode.toString();
                if ((sCode.startsWith("c") || sCode.startsWith("C")) && sCode.length() > 1) {
                    this.loadCalls();
                    this.searchCallerID(sCode.substring(1, sCode.length()));
                    this.loadCalls();
                } else if ((sCode.startsWith("K") || sCode.startsWith("k")) && sCode.length() > 1) {
                    this.loadCalls();
                    this.searchKOT(sCode.substring(1, sCode.length()));
                    this.loadCalls();
                } else {
                    this.loadCalls();
                    this.newCall(sCode, this.deviceid);
                    this.loadCalls();
                }
                this.stateToZero();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (cTrans == '\u007f') {
            this.stateToZero();
        } else if (cTrans == '0' || cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9' || cTrans == 'k' || cTrans == 'c' || cTrans == 'K' || cTrans == 'C') {
            this.m_sBarcode.append(cTrans);
            this.m_jCallerId.setText(this.m_sBarcode.toString());
        } else if (cTrans == '-') {
            if (this.m_sBarcode != null && this.m_sBarcode.length() > 0) {
                this.m_sBarcode = this.m_sBarcode.deleteCharAt(this.m_sBarcode.length() - 1);
                this.m_jCallerId.setText(this.m_sBarcode.toString());
            }
        } else if (cTrans == '+') {
            if (this.m_sBarcode.length() > 0) {
                String sCode = this.m_sBarcode.toString();
                this.newCall(sCode, this.deviceid);
                this.loadCalls();
                this.stateToZero();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (cTrans == '=') {
            JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlCustomers);
            finder.search(null);
            finder.setVisible(true);
            if (finder.getSelectedCustomer() != null) {
                this.newCall(finder.getSelectedCustomer().getSearchkey(), this.deviceid);
                this.loadCalls();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void updateLineStatus(int line, int status) {
        switch (status) {
            case 0: {
                this.lineIcon = new ImageIcon(this.getClass().getResource("/com/posics/images/lineinactive.png"));
                break;
            }
            case 1: {
                this.lineIcon = new ImageIcon(this.getClass().getResource("/com/posics/images/lineconnected.png"));
                break;
            }
            case 2: {
                this.lineIcon = new ImageIcon(this.getClass().getResource("/com/posics/images/lineinactive.png"));
                break;
            }
            default: {
                this.lineIcon = new ImageIcon(this.getClass().getResource("/com/posics/images/linedisconnected.png"));
            }
        }
        this.lineLabels.get(line).setIcon(this.lineIcon);
    }

    private void initComponents() {
        this.m_jPanelMap = new JPanel();
        this.m_jPanTicket = new JPanel();
        this.m_jPanelCentral = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.m_jPanelReady = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jPanelPending = new JPanel();
        this.m_jButtons = new JPanel();
        this.m_jbtnRefresh = new JButton();
        this.m_jbtnUnlock = new JButton();
        this.m_jContEntries = new JPanel();
        this.m_jPanEntries = new JPanel();
        this.jPanel9 = new JPanel();
        this.m_jCallerId = new JLabel();
        this.jTelephoneKeys1 = new JTelephoneKeys();
        this.m_jKeyFactory = new JTextField();
        this.m_jPanelCallHistory = new JPanel();
        this.setLayout(new CardLayout());
        this.m_jPanelMap.setLayout(new BorderLayout());
        this.m_jPanTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanTicket.setLayout(new BorderLayout());
        this.m_jPanelCentral.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.m_jPanelReady.setBorder(BorderFactory.createTitledBorder(AppLocal.getIntString("delivery.readyfordelivery")));
        this.m_jPanelReady.setFocusable(false);
        this.m_jPanelReady.setLayout(new BorderLayout());
        this.jSplitPane2.setRightComponent(this.m_jPanelReady);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.m_jPanelPending.setBorder(BorderFactory.createTitledBorder(AppLocal.getIntString("delivery.pendingorders")));
        this.m_jPanelPending.setFocusable(false);
        this.m_jPanelPending.setLayout(new BorderLayout());
        this.jPanel2.add(this.m_jPanelPending);
        this.jSplitPane2.setLeftComponent(this.jPanel2);
        this.m_jPanelCentral.add((Component)this.jSplitPane2, "Center");
        this.m_jPanTicket.add((Component)this.m_jPanelCentral, "Center");
        this.m_jButtons.setLayout(new FlowLayout(0));
        this.m_jbtnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reload.png")));
        this.m_jbtnRefresh.setText(AppLocal.getIntString("button.reloadticket"));
        this.m_jbtnRefresh.setFocusPainted(false);
        this.m_jbtnRefresh.setFocusable(false);
        this.m_jbtnRefresh.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnRefresh.setRequestFocusEnabled(false);
        this.m_jbtnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagDelivery.this.m_jbtnRefreshActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jbtnRefresh);
        this.m_jbtnUnlock.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/unlock.png")));
        this.m_jbtnUnlock.setText(AppLocal.getIntString("button.unlockticket"));
        this.m_jbtnUnlock.setFocusPainted(false);
        this.m_jbtnUnlock.setFocusable(false);
        this.m_jbtnUnlock.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnUnlock.setRequestFocusEnabled(false);
        this.m_jbtnUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagDelivery.this.m_jbtnUnlockActionPerformed(evt);
            }
        });
        this.m_jButtons.add(this.m_jbtnUnlock);
        this.m_jPanTicket.add((Component)this.m_jButtons, "First");
        this.m_jPanelMap.add((Component)this.m_jPanTicket, "Center");
        this.m_jContEntries.setLayout(new BorderLayout());
        this.m_jPanEntries.setLayout(new BoxLayout(this.m_jPanEntries, 1));
        this.jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel9.setLayout(new GridBagLayout());
        this.m_jCallerId.setHorizontalAlignment(4);
        this.m_jCallerId.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jCallerId.setMaximumSize(new Dimension(10, 6));
        this.m_jCallerId.setMinimumSize(new Dimension(10, 6));
        this.m_jCallerId.setOpaque(true);
        this.m_jCallerId.setPreferredSize(new Dimension(100, 30));
        this.m_jCallerId.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.m_jCallerId, gridBagConstraints);
        this.m_jPanEntries.add(this.jPanel9);
        this.jTelephoneKeys1.addJNumberEventListener(new JNumberEventListener(){

            @Override
            public void keyPerformed(JNumberEvent evt) {
                JTicketsBagDelivery.this.jTelephoneKeys1KeyPerformed(evt);
            }
        });
        this.m_jPanEntries.add(this.jTelephoneKeys1);
        this.m_jKeyFactory.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setBorder(null);
        this.m_jKeyFactory.setCaretColor(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setPreferredSize(new Dimension(1, 1));
        this.m_jKeyFactory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JTicketsBagDelivery.this.m_jKeyFactoryKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                JTicketsBagDelivery.this.m_jKeyFactoryKeyTyped(evt);
            }
        });
        this.m_jPanEntries.add(this.m_jKeyFactory);
        this.m_jContEntries.add((Component)this.m_jPanEntries, "North");
        this.m_jPanelCallHistory.setBorder(BorderFactory.createTitledBorder(AppLocal.getIntString("delivery.callhistory")));
        this.m_jPanelCallHistory.setFocusable(false);
        this.m_jPanelCallHistory.setLayout(new BorderLayout());
        this.m_jContEntries.add((Component)this.m_jPanelCallHistory, "Center");
        this.m_jPanelMap.add((Component)this.m_jContEntries, "After");
        this.add((Component)this.m_jPanelMap, "map");
    }

    private void m_jKeyFactoryKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
    }

    private void m_jKeyFactoryKeyTyped(KeyEvent evt) {
        this.m_jKeyFactory.setText(null);
        this.stateTransition(evt.getKeyChar());
    }

    private void jTelephoneKeys1KeyPerformed(JNumberEvent evt) {
        this.stateTransition(evt.getKey());
    }

    private void m_jbtnRefreshActionPerformed(ActionEvent evt) {
        this.loadCalls();
    }

    private void m_jbtnUnlockActionPerformed(ActionEvent evt) {
        try {
            List<Place> places = this.dlReceipts.getOpenTickets(3);
            SelectTable selectdtable = SelectTable.getSelectTable(this, places);
            selectdtable.setVisible(true);
            if (selectdtable.isOK() && selectdtable.getTable() != null) {
                this.dlReceipts.unlockTable(selectdtable.getTable().getId());
            }
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    static {
        try {
            isHIDLibLoaded = ClassPathLibraryLoader.loadNativeHIDLibrary();
        }
        catch (Exception e) {
            isHIDLibLoaded = false;
            System.err.println(e.getMessage());
        }
    }

    public class LineObserver
    implements Observer {
        Thread linethread;
        int version;

        public LineObserver(AD101 lineConnection) {
            lineConnection.addObserver(this);
            this.linethread = new Thread(lineConnection);
            this.linethread.start();
            this.version = 1;
        }

        public LineObserver(AD102 lineConnection) {
            lineConnection.addObserver(this);
            this.linethread = new Thread(lineConnection);
            this.linethread.start();
            this.version = 2;
        }

        @Override
        public void update(Observable lineConnection, Object state) {
            if (this.version == 1) {
                this.updateStatusV1(lineConnection, state);
            } else {
                this.updateStatusV2(lineConnection, state);
            }
        }

        private void updateStatusV1(Observable lineConnection, Object state) {
            if (state.toString().equals("0b")) {
                JTicketsBagDelivery.this.updateLineStatus(((AD101)lineConnection).getLineId(), 0);
            } else if (state.toString().equals("09")) {
                JTicketsBagDelivery.this.updateLineStatus(((AD101)lineConnection).getLineId(), 1);
            } else if (state.toString().equals("07")) {
                JTicketsBagDelivery.this.updateLineStatus(((AD101)lineConnection).getLineId(), 2);
            } else if (state.toString().equals("08")) {
                JTicketsBagDelivery.this.updateLineStatus(((AD101)lineConnection).getLineId(), 3);
            } else if (state.toString().equals("00")) {
                JTicketsBagDelivery.this.updateLineStatus(((AD101)lineConnection).getLineId(), -1);
            } else if (!state.toString().equals("")) {
                JTicketsBagDelivery.this.newCall(state.toString(), JTicketsBagDelivery.this.deviceid);
                JTicketsBagDelivery.this.loadCalls();
            }
        }

        private void updateStatusV2(Observable lineConnection, Object state) {
            LineMessage msg = (LineMessage)state;
            int iChannel = msg.iLine;
            block0 : switch (msg.iStatus) {
                case 0: {
                    break;
                }
                case 1: {
                    switch (msg.iValue) {
                        case 1: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Disconnect";
                            JTicketsBagDelivery.this.updateLineStatus(msg.iLine, 0);
                            break block0;
                        }
                        case 2: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Idle";
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId = "";
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().Dtmf = "";
                            break block0;
                        }
                        case 3: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Dialing";
                            break block0;
                        }
                        case 4: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Ring On";
                            if (!"".equals(((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId.trim()) && ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId.trim().length() > 3) {
                                JTicketsBagDelivery.this.newCall(((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId.replaceAll("[^\\d]", ""), JTicketsBagDelivery.this.deviceid);
                                JTicketsBagDelivery.this.loadCalls();
                                ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Idle";
                                ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId = "";
                                ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().Dtmf = "";
                            }
                            JTicketsBagDelivery.this.updateLineStatus(msg.iLine, 2);
                            break block0;
                        }
                        case 5: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Ring Off";
                            JTicketsBagDelivery.this.updateLineStatus(msg.iLine, 0);
                            break block0;
                        }
                        case 6: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Incoming Call";
                            break block0;
                        }
                        case 7: {
                            ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineStatus = "Outgoing Call";
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    int oldVoltage = ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineVoltage;
                    int newVoltage = msg.iValue;
                    if (oldVoltage == 0 || Math.abs(oldVoltage - newVoltage) * 100 / oldVoltage >= 10) {
                        ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().LineVoltage = msg.iValue;
                    }
                    if (msg.iValue == 0) {
                        JTicketsBagDelivery.this.updateLineStatus(msg.iLine, 5);
                        break;
                    }
                    JTicketsBagDelivery.this.updateLineStatus(msg.iLine, 1);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    System.out.println("One: " + ((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId + "-" + JTicketsBagDelivery.this.previLineStatus);
                    if (((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId.length() <= 3 || JTicketsBagDelivery.this.previLineStatus == 4) break;
                    JTicketsBagDelivery.this.newCall(((JTicketsBagDelivery)JTicketsBagDelivery.this).ti2.getChannel().CallerId, JTicketsBagDelivery.this.deviceid);
                    JTicketsBagDelivery.this.loadCalls();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
            }
            JTicketsBagDelivery.this.previLineStatus = msg.iStatus;
        }
    }

    public class ScriptObject {
        private TicketInfo ticket;
        private Object ticketext;
        private DeliveryCall call;

        private ScriptObject(TicketInfo ticket, Object ticketext) {
            this.ticket = ticket;
            this.ticketext = ticketext;
            this.call = this.call;
        }

        public void printTicket(String sresourcename) {
            JTicketsBagDelivery.this.printTicket(sresourcename, this.ticket, this.ticketext);
        }

        public Object evalScript(String code) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            script.put("ticket", this.ticket);
            script.put("call", this.ticketext);
            script.put("taxes", JTicketsBagDelivery.this.taxcollection);
            script.put("taxeslogic", JTicketsBagDelivery.this.taxeslogic);
            script.put("user", JTicketsBagDelivery.this.m_App.getAppUserView().getUser());
            script.put("sales", this);
            return script.eval(code);
        }
    }

    private class CallClickListener
    implements ActionListener {
        private DeliveryCall m_call;
        private Component m_this;

        public CallClickListener(DeliveryCall call, Component mthis) {
            this.m_call = call;
            this.m_this = mthis;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block29: {
                if (this.m_call.getStatus() == 0 || this.m_call.getStatus() == 1) {
                    TicketInfo ticket;
                    try {
                        String lockedby = JTicketsBagDelivery.this.dlReceipts.isTableLocked(this.m_call.getId());
                        if (lockedby != null) {
                            new MessageInf(-33554432, AppLocal.getIntString("message.calllocked") + lockedby).show(JTicketsBagDelivery.this);
                            return;
                        }
                    }
                    catch (Exception e) {
                        new MessageInf(e).show(JTicketsBagDelivery.this);
                    }
                    JTicketsBagDelivery.this.m_CallCurrent = this.m_call;
                    if (this.m_call.getCustomer() == null) {
                        JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this.m_this, JTicketsBagDelivery.this.dlCustomers);
                        finder.search(null);
                        finder.setSearchKey(this.m_call.getCallerId());
                        finder.setVisible(true);
                        if (finder.getSelectedCustomer() != null) {
                            try {
                                this.m_call.setCustomer(JTicketsBagDelivery.this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()));
                                JTicketsBagDelivery.this.dlReceipts.updateCallCustomer(this.m_call);
                                JTicketsBagDelivery.this.loadCalls();
                            }
                            catch (BasicException e) {
                                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), e);
                                msg.show(this.m_this);
                            }
                        } else {
                            JTicketsBagDelivery.this.m_CallCurrent = null;
                            return;
                        }
                    }
                    if ((ticket = JTicketsBagDelivery.this.getSharedTicketInfo(this.m_call)) == null) {
                        ticket = new TicketInfo();
                        if (this.m_call.getCustomer() != null) {
                            ticket.setCustomer(this.m_call.getCustomer());
                        } else {
                            ticket.setCustomer(null);
                        }
                        try {
                            this.m_call.setDeliveryId(UUID.randomUUID().toString());
                            JTicketsBagDelivery.this.dlReceipts.insertDeliveryOrder(this.m_call.getDeliveryId(), this.m_call.getId());
                            JTicketsBagDelivery.this.dlReceipts.updateCallStatus(1, this.m_call.getId());
                            ticket.setProperty("DeliveryOrder", this.m_call.getDeliveryId());
                            ticket.setProperty("CallId", this.m_call.getCallId());
                            ticket.setProperty("Call", this.m_call.getId());
                            JTicketsBagDelivery.this.dlReceipts.insertSharedTicket(this.m_call.getId(), ticket, 3, JTicketsBagDelivery.this.m_App.getAppUserView().getUser().getName());
                        }
                        catch (BasicException e) {
                            new MessageInf(e).show(JTicketsBagDelivery.this);
                        }
                    }
                    this.m_call.setOrder(true);
                    JTicketsBagDelivery.this.setActivePlace(this.m_call, ticket);
                } else if (this.m_call.getStatus() == 2) {
                    try {
                        List<DriverInfo> drivers = JTicketsBagDelivery.this.dlReceipts.getDrivers();
                        SelectDriver selectdriver = SelectDriver.getSelectDriver(JTicketsBagDelivery.this, drivers, JTicketsBagDelivery.this.dlSystem, JTicketsBagDelivery.this.dlSales.getReceipt(this.m_call.getReceiptId()));
                        selectdriver.setVisible(true);
                        if (!selectdriver.isOK()) break block29;
                        if (selectdriver.getDriver() != null) {
                            JTicketsBagDelivery.this.dlReceipts.updateDeliveryDriver(selectdriver.getDriver().getID(), this.m_call.getDeliveryId());
                            Properties ticket = JTicketsBagDelivery.this.getTicketInfo(this.m_call.getReceiptId());
                            ticket.setProperty("Driver", selectdriver.getDriver().getName());
                            try {
                                ByteArrayOutputStream o = new ByteArrayOutputStream();
                                ticket.storeToXML((OutputStream)o, "Saleculator PDA", "UTF-8");
                                JTicketsBagDelivery.this.dlReceipts.setReceiptAttributes(this.m_call.getReceiptId(), o);
                            }
                            catch (IOException o) {
                                // empty catch block
                            }
                        }
                        JTicketsBagDelivery.this.dlReceipts.updateCallStatus(3, this.m_call.getId());
                        if (JTicketsBagDelivery.this.ticketbuttons.contains("key=\"ticket.driverselected\"")) {
                            try {
                                String resource = JTicketsBagDelivery.this.dlSystem.getResourceAsXML("event.driverselected");
                                if (resource.trim().length() > 0) {
                                    TicketInfo ticket = JTicketsBagDelivery.this.dlSales.getReceipt(this.m_call.getReceiptId());
                                    ScriptObject scr = new ScriptObject(ticket, selectdriver.getDriver());
                                    Object object = scr.evalScript(resource);
                                }
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                            }
                        }
                        JTicketsBagDelivery.this.loadCalls();
                    }
                    catch (Exception e) {
                        new MessageInf(e).show(JTicketsBagDelivery.this);
                    }
                } else if (this.m_call.getStatus() == 3) {
                    try {
                        JOrderHistory lastorder = JOrderHistory.getOrderHistory(JTicketsBagDelivery.this, JTicketsBagDelivery.this.dlSystem, JTicketsBagDelivery.this.dlSales.getReceipt(this.m_call.getReceiptId()));
                        lastorder.setVisible(true);
                    }
                    catch (Exception e) {
                        new MessageInf(e).show(JTicketsBagDelivery.this);
                    }
                }
            }
        }
    }
}

