/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.delivery;

import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.sales.delivery.DriverInfo;
import com.posics.pos.sales.delivery.JOrderHistory;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SelectDriver
extends JDialog {
    private DriverInfo selecteddriver;
    private boolean ok;
    private TicketInfo ticket;
    private DataLogicSystem m_dlSystem;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JButton jcmdCancel;
    private JButton jcmdCancel2;
    private JPanel m_jtickets;

    private SelectDriver(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private SelectDriver(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    public static SelectDriver getSelectDriver(Component parent, List<DriverInfo> drivers, DataLogicSystem m_dlSystem, TicketInfo ticket) {
        Window window = SwingUtilities.windowForComponent(parent);
        SelectDriver myMsg = window instanceof Frame ? new SelectDriver((Frame)window, true) : new SelectDriver((Dialog)window, true);
        myMsg.init(drivers);
        myMsg.ticket = ticket;
        myMsg.m_dlSystem = m_dlSystem;
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        myMsg.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        if (ticket == null) {
            myMsg.jcmdCancel2.setVisible(false);
        } else {
            myMsg.jcmdCancel2.setVisible(true);
        }
        return myMsg;
    }

    private void init(List<DriverInfo> drivers) {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        for (int i = 0; i < drivers.size(); ++i) {
            this.m_jtickets.add(new JButtonDriver(drivers.get(i)));
        }
        this.getRootPane().setDefaultButton(this.jcmdCancel2);
        this.ok = false;
        this.selecteddriver = null;
    }

    public boolean isOK() {
        return this.ok;
    }

    public DriverInfo getDriver() {
        return this.selecteddriver;
    }

    public void setDriver(DriverInfo driver) {
        this.selecteddriver = driver;
    }

    private void initComponents() {
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jcmdCancel2 = new JButton();
        this.jcmdCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.m_jtickets = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("form.selectdrivertitle"));
        this.jPanel8.setLayout(new BorderLayout());
        this.jcmdCancel2.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/receipt.png")));
        this.jcmdCancel2.setText(AppLocal.getIntString("label.ticketid"));
        this.jcmdCancel2.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectDriver.this.jcmdCancel2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel2);
        this.jcmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.jcmdCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.jcmdCancel.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectDriver.this.jcmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel);
        this.jPanel8.add((Component)this.jPanel1, "After");
        this.getContentPane().add((Component)this.jPanel8, "South");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.m_jtickets.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jtickets.setLayout(new GridLayout(0, 1, 5, 5));
        this.jPanel2.add((Component)this.m_jtickets, "North");
        this.jScrollPane1.setViewportView(this.jPanel2);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.setSize(new Dimension(359, 329));
        this.setLocationRelativeTo(null);
    }

    private void jcmdCancel2ActionPerformed(ActionEvent evt) {
        try {
            JOrderHistory lastorder = JOrderHistory.getOrderHistory(this, this.m_dlSystem, this.ticket);
            lastorder.setVisible(true);
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    private void jcmdCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.selecteddriver = null;
        this.dispose();
    }

    private class JButtonDriver
    extends JButton {
        private DriverInfo m_driver;

        public JButtonDriver(DriverInfo driver) {
            this.m_driver = driver;
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(8, 14, 8, 14));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectDriver.this.ok = true;
                    SelectDriver.this.selecteddriver = JButtonDriver.this.m_driver;
                    SelectDriver.this.dispose();
                }
            });
            this.setText(driver.getName());
        }
    }
}

