/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.restaurant;

import com.posics.basic.BasicException;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.gui.ListKeyed;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.StaticSentence;
import com.posics.pos.customers.CustomerInfo;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JTicketsBag;
import com.posics.pos.sales.SharedTicketInfo;
import com.posics.pos.sales.TaxesLogic;
import com.posics.pos.sales.TicketsEditor;
import com.posics.pos.sales.restaurant.Floor;
import com.posics.pos.sales.restaurant.JTicketsBagRestaurant;
import com.posics.pos.sales.restaurant.JTicketsBagRestaurantRes;
import com.posics.pos.sales.restaurant.Place;
import com.posics.pos.sales.restaurant.SelectTable;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jdesktop.layout.GroupLayout;

public class JTicketsBagRestaurantMap
extends JTicketsBag {
    private List<Place> m_aplaces;
    private List<Floor> m_afloors;
    private JTicketsBagRestaurant m_restaurantmap;
    private JTicketsBagRestaurantRes m_jreservations;
    private Place m_PlaceCurrent;
    private Place m_PlaceClipboard;
    private CustomerInfo customer;
    private DataLogicReceipts dlReceipts = null;
    private DataLogicSales dlSales = null;
    protected DataLogicSystem dlSystem;
    private ListKeyed taxcollection;
    private TaxesLogic taxeslogic;
    private ComboBoxValModel m_tablesModel;
    private boolean m_blTimer = false;
    private int m_iAlertAfter = 0;
    private int m_iTableWidth = 0;
    private int m_iTableHeight = 0;
    private static final int INTERVAL = 60000;
    private Timer timer;
    private String m_sTabeLabel;
    AppConfig config;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JComboBox jTablesCombo;
    private JPanel m_jPanelMap;
    private JLabel m_jText;
    private JButton m_jbtnRefresh;
    private JButton m_jbtnReservations;
    private JButton m_jbtnUnlock;

    public JTicketsBagRestaurantMap(AppView app, TicketsEditor panelticket) {
        super(app, panelticket);
        StaticSentence sent;
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.posics.pos.forms.DataLogicSales");
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.m_restaurantmap = new JTicketsBagRestaurant(app, this);
        this.m_PlaceCurrent = null;
        this.m_PlaceClipboard = null;
        this.customer = null;
        try {
            sent = new StaticSentence(app.getSession(), "SELECT ID, NAME, IMAGE FROM FLOORS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(Floor.class));
            this.m_afloors = sent.list();
        }
        catch (BasicException eD) {
            this.m_afloors = new ArrayList<Floor>();
        }
        try {
            sent = new StaticSentence(app.getSession(), "SELECT P.ID, P.NAME, P.X, P.Y, P.FLOOR, F.NAME AS FLOORNAME FROM PLACES P JOIN FLOORS F ON P.FLOOR = F.ID ORDER BY F.NAME, P.NAME", null, (SerializerRead)new SerializerReadClass(Place.class));
            this.m_aplaces = sent.list();
        }
        catch (BasicException eD) {
            this.m_aplaces = new ArrayList<Place>();
        }
        this.initComponents();
        if (this.m_afloors.size() > 1) {
            JTabbedPane jTabFloors = new JTabbedPane();
            jTabFloors.applyComponentOrientation(this.getComponentOrientation());
            jTabFloors.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            jTabFloors.setTabLayoutPolicy(1);
            jTabFloors.setFocusable(false);
            jTabFloors.setRequestFocusEnabled(false);
            this.m_jPanelMap.add((Component)jTabFloors, "Center");
            for (Floor f : this.m_afloors) {
                f.getContainer().applyComponentOrientation(this.getComponentOrientation());
                JScrollPane jScrCont = new JScrollPane();
                jScrCont.applyComponentOrientation(this.getComponentOrientation());
                JPanel jPanCont = new JPanel();
                jPanCont.applyComponentOrientation(this.getComponentOrientation());
                jTabFloors.addTab(f.getName(), f.getIcon(), jScrCont);
                jScrCont.setViewportView(jPanCont);
                jPanCont.add(f.getContainer());
            }
        } else if (this.m_afloors.size() == 1) {
            Floor f = this.m_afloors.get(0);
            f.getContainer().applyComponentOrientation(this.getComponentOrientation());
            JPanel jPlaces = new JPanel();
            jPlaces.applyComponentOrientation(this.getComponentOrientation());
            jPlaces.setLayout(new BorderLayout());
            jPlaces.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 5, 5, 5)), new TitledBorder(f.getName())));
            JScrollPane jScrCont = new JScrollPane();
            jScrCont.applyComponentOrientation(this.getComponentOrientation());
            JPanel jPanCont = new JPanel();
            jPanCont.setLayout(new BorderLayout());
            jPanCont.applyComponentOrientation(this.getComponentOrientation());
            this.m_jPanelMap.add((Component)jPlaces, "Center");
            jPlaces.add((Component)jScrCont, "Center");
            jScrCont.setViewportView(jPanCont);
            jPanCont.add(f.getContainer());
        }
        Floor currfloor = null;
        this.config = new AppConfig(new String[0]);
        this.config.load();
        String strTableTimer = this.config.getProperty("Table.Timer");
        if (strTableTimer != null && strTableTimer.trim().toLowerCase().equals("true")) {
            this.m_blTimer = true;
        }
        String alertafter = this.config.getProperty("Table.AlertAfter");
        try {
            this.m_iAlertAfter = Integer.parseInt(alertafter);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.m_iAlertAfter = 20;
        }
        String tablewidth = this.config.getProperty("Table.Width");
        try {
            this.m_iTableWidth = Integer.parseInt(tablewidth);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.m_iTableWidth = 0;
        }
        String tableheight = this.config.getProperty("Table.Height");
        try {
            this.m_iTableHeight = Integer.parseInt(tableheight);
        }
        catch (NullPointerException | NumberFormatException e) {
            this.m_iTableHeight = 0;
        }
        this.m_sTabeLabel = this.dlSystem.getResourceAsXML("Table.Label");
        this.m_tablesModel = new ComboBoxValModel();
        for (Place pl : this.m_aplaces) {
            int iFloor = 0;
            if (currfloor == null || !currfloor.getID().equals(pl.getFloor())) {
                while (!(currfloor = this.m_afloors.get(iFloor++)).getID().equals(pl.getFloor())) {
                }
            }
            if (this.m_iTableWidth > 0 && this.m_iTableHeight > 0) {
                pl.setSize(this.m_iTableWidth, this.m_iTableHeight);
            }
            currfloor.getContainer().add(pl.getButton());
            pl.setButtonBounds();
            pl.getButton().addActionListener(new MyActionListener(pl));
            this.m_tablesModel.add(pl.getName());
        }
        String resource = this.dlSystem.getResourceAsXML("Ticket.Buttons");
        if ((resource = resource.replaceAll("(?s)<!--.*?-->", "")).contains("showfloorscombo value=\"true\"")) {
            this.jTablesCombo.setModel(this.m_tablesModel);
            JTextComponent editor = (JTextComponent)this.jTablesCombo.getEditor().getEditorComponent();
            editor.setDocument(new CBDocument(this.jTablesCombo));
        } else {
            this.jPanel3.setVisible(false);
        }
        this.m_jreservations = new JTicketsBagRestaurantRes(app, this);
        this.add((Component)this.m_jreservations, "res");
        this.m_jbtnUnlock.setVisible(this.m_App.getAppUserView().getUser().hasPermission("UnlockTable"));
        if (this.m_blTimer) {
            this.timer = new Timer(60000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JTicketsBagRestaurantMap.this.loadTickets();
                }
            });
            this.timer.start();
        }
    }

    @Override
    public void activate() {
        this.m_PlaceClipboard = null;
        this.customer = null;
        this.loadTickets();
        this.printState();
        if (this.timer != null) {
            this.timer.start();
        }
        this.m_panelticket.setActiveTicket(null, null);
        this.m_restaurantmap.activate();
        this.showView("map");
        this.m_jbtnUnlock.setVisible(this.m_App.getAppUserView().getUser().hasPermission("UnlockTable"));
    }

    @Override
    public boolean deactivate() {
        if (this.viewTables()) {
            this.m_PlaceClipboard = null;
            this.customer = null;
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.m_PlaceCurrent != null) {
                try {
                    this.dlReceipts.updateSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket());
                }
                catch (BasicException e) {
                    new MessageInf(e).show(this);
                }
                this.m_PlaceCurrent = null;
            }
            this.printState();
            this.m_panelticket.setActiveTicket(null, null);
            return true;
        }
        return false;
    }

    @Override
    protected JComponent getBagComponent() {
        return this.m_restaurantmap;
    }

    @Override
    protected JComponent getNullComponent() {
        return this;
    }

    public void moveTicket() {
        if (this.m_PlaceCurrent != null) {
            try {
                this.dlReceipts.updateSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket());
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_PlaceClipboard = this.m_PlaceCurrent;
            this.customer = null;
            this.m_PlaceCurrent = null;
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public boolean viewTables(CustomerInfo c) {
        if (this.m_jreservations.deactivate()) {
            this.showView("map");
            this.m_PlaceClipboard = null;
            this.customer = c;
            this.printState();
            return true;
        }
        return false;
    }

    public boolean viewTables() {
        return this.viewTables(null);
    }

    public void newTicket() {
        if (this.m_PlaceCurrent != null) {
            try {
                this.dlReceipts.updateSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket());
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            if (!this.m_sTabeLabel.equals("")) {
                this.m_PlaceCurrent.setLabel(this.readTableLabel(this.m_panelticket.getActiveTicket(), this.m_sTabeLabel, this.m_PlaceCurrent));
            }
            this.m_PlaceCurrent = null;
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
        this.jTablesCombo.requestFocus();
    }

    private void deleteTicket2() {
        if (this.m_PlaceCurrent != null) {
            String id = this.m_PlaceCurrent.getId();
            try {
                this.dlReceipts.deleteSharedTicket(id);
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_PlaceCurrent.setPeople(false);
            if (this.m_blTimer) {
                this.m_PlaceCurrent.showCounter(this.m_iAlertAfter);
            }
            this.m_PlaceCurrent.setLabel(this.m_PlaceCurrent.getName());
            this.m_PlaceCurrent = null;
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
    }

    @Override
    public int getBillingMode() {
        return 2;
    }

    @Override
    public void deleteTicket() {
        String resource = this.dlSystem.getResourceAsXML("Ticket.Buttons");
        if (!(resource = resource.replaceAll("(?s)<!--.*?-->", "")).contains("key=\"ticket.delete\"")) {
            this.deleteTicket2();
        } else {
            resource = this.dlSystem.getResourceAsXML("event.delete");
            String place = this.m_panelticket.getActiveTicket().getId();
            try {
                ScriptObject scr = new ScriptObject(this.m_panelticket.getActiveTicket(), place);
                Object result = scr.evalScript(resource);
                if (result == null) {
                    this.deleteTicket2();
                }
            }
            catch (Exception e) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
            }
        }
    }

    public void loadTickets() {
        HashSet<String> atickets = new HashSet<String>();
        try {
            List<SharedTicketInfo> l = this.dlReceipts.getSharedTicketList(2);
            for (SharedTicketInfo ticket : l) {
                atickets.add(ticket.getId());
            }
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
        }
        for (Place table : this.m_aplaces) {
            if (atickets.contains(table.getId())) {
                table.setPeople(true);
                if (this.m_sTabeLabel.equals("") && !this.m_blTimer) continue;
                try {
                    TicketInfo ti = this.dlReceipts.getSharedTicket(table.getId());
                    if (!this.m_sTabeLabel.equals("")) {
                        table.setLabel(this.readTableLabel(ti, this.m_sTabeLabel, table));
                    }
                    if (!this.m_blTimer) continue;
                    table.setTimer(ti.getTimer());
                    table.showCounter(this.m_iAlertAfter);
                }
                catch (BasicException e) {
                    new MessageInf(e).show(this);
                }
                continue;
            }
            table.setPeople(false);
            table.setLabel(table.getName());
        }
    }

    private void printState() {
        if (this.m_PlaceClipboard == null) {
            if (this.customer == null) {
                this.m_jText.setText(null);
                for (Place place : this.m_aplaces) {
                    place.getButton().setEnabled(true);
                }
                this.m_jbtnReservations.setEnabled(true);
            } else {
                this.m_jText.setText(AppLocal.getIntString("label.restaurantcustomer", this.customer.getName()));
                for (Place place : this.m_aplaces) {
                    place.getButton().setEnabled(!place.hasPeople());
                }
                this.m_jbtnReservations.setEnabled(false);
            }
        } else {
            this.m_jText.setText(AppLocal.getIntString("label.restaurantmove", this.m_PlaceClipboard.getName()));
            for (Place place : this.m_aplaces) {
                place.getButton().setEnabled(true);
            }
            this.m_jbtnReservations.setEnabled(false);
        }
    }

    private TicketInfo getTicketInfo(Place place) {
        try {
            return this.dlReceipts.getSharedTicket(place.getId());
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
            return null;
        }
    }

    private void setActivePlace(Place place, TicketInfo ticket) {
        try {
            this.dlReceipts.lockTable(place.getId(), this.m_App.getAppUserView().getUser().getName());
            this.m_PlaceCurrent = place;
            this.m_panelticket.setActiveTicket(ticket, this.m_PlaceCurrent.getName());
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    private Object evalScript(ScriptObject scr, String resource) {
        try {
            this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
            return scr.evalScript(this.dlSystem.getResourceAsXML(resource));
        }
        catch (ScriptException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e);
            msg.show(this);
            return msg;
        }
    }

    private String readTableLabel(TicketInfo ticket, String strLabel, Object place) {
        try {
            ScriptObject scr = new ScriptObject(ticket, place);
            Object result = scr.evalScript(strLabel);
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
            return "";
        }
    }

    private void showView(String view) {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, view);
    }

    private void initComponents() {
        this.m_jPanelMap = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jbtnReservations = new JButton();
        this.m_jbtnRefresh = new JButton();
        this.m_jbtnUnlock = new JButton();
        this.m_jText = new JLabel();
        this.jPanel3 = new JPanel();
        this.jTablesCombo = new JComboBox();
        this.setLayout(new CardLayout());
        this.m_jPanelMap.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        this.m_jbtnReservations.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/date.png")));
        this.m_jbtnReservations.setText(AppLocal.getIntString("button.reservations"));
        this.m_jbtnReservations.setFocusPainted(false);
        this.m_jbtnReservations.setFocusable(false);
        this.m_jbtnReservations.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnReservations.setRequestFocusEnabled(false);
        this.m_jbtnReservations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnReservationsActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnReservations);
        this.m_jbtnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reload.png")));
        this.m_jbtnRefresh.setText(AppLocal.getIntString("button.reloadticket"));
        this.m_jbtnRefresh.setFocusPainted(false);
        this.m_jbtnRefresh.setFocusable(false);
        this.m_jbtnRefresh.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnRefresh.setRequestFocusEnabled(false);
        this.m_jbtnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnRefreshActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnRefresh);
        this.m_jbtnUnlock.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/tablesmall.png")));
        this.m_jbtnUnlock.setText(AppLocal.getIntString("button.unlockticket"));
        this.m_jbtnUnlock.setFocusPainted(false);
        this.m_jbtnUnlock.setFocusable(false);
        this.m_jbtnUnlock.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnUnlock.setRequestFocusEnabled(false);
        this.m_jbtnUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnUnlockActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnUnlock);
        this.jPanel2.add(this.m_jText);
        this.jPanel1.add((Component)this.jPanel2, "Before");
        this.m_jPanelMap.add((Component)this.jPanel1, "North");
        this.jPanel3.setPreferredSize(new Dimension(472, 25));
        this.jTablesCombo.setEditable(true);
        this.jTablesCombo.setPreferredSize(new Dimension(150, 25));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jTablesCombo, -2, 300, -2).addContainerGap(162, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jTablesCombo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.m_jPanelMap.add((Component)this.jPanel3, "Last");
        this.add((Component)this.m_jPanelMap, "map");
    }

    private void m_jbtnRefreshActionPerformed(ActionEvent evt) {
        this.m_PlaceClipboard = null;
        this.customer = null;
        this.loadTickets();
        this.printState();
        this.jTablesCombo.requestFocus();
    }

    private void m_jbtnReservationsActionPerformed(ActionEvent evt) {
        this.showView("res");
        this.m_jreservations.activate();
    }

    private void m_jbtnUnlockActionPerformed(ActionEvent evt) {
        try {
            List<Place> places = this.dlReceipts.getOpenTickets(2);
            SelectTable selectdtable = SelectTable.getSelectTable(this, places);
            selectdtable.setVisible(true);
            if (selectdtable.isOK() && selectdtable.getTable() != null) {
                this.dlReceipts.unlockTable(selectdtable.getTable().getId());
            }
        }
        catch (Exception e) {
            new MessageInf(e).show(this);
        }
    }

    public class CBDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private ComboBoxModel model;
        private JTextComponent editor;
        private boolean selecting = false;

        private CBDocument(final JComboBox comboBox) {
            this.comboBox = comboBox;
            this.model = comboBox.getModel();
            this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
            KeyListener[] ks = this.editor.getKeyListeners();
            if (ks.length == 0) {
                this.editor.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        int key;
                        if (comboBox.isDisplayable()) {
                            comboBox.setPopupVisible(true);
                        }
                        if ((key = e.getKeyCode()) == 10 && JTicketsBagRestaurantMap.this.jTablesCombo.getSelectedItem() != null) {
                            CBDocument.this.addSelectedItem();
                        }
                    }
                });
            }
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!CBDocument.this.selecting) {
                        CBDocument.this.highlightCompletedText(0);
                    }
                }
            });
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                this.setSelectedItem(item);
            } else {
                item = this.comboBox.getSelectedItem();
                offs -= str.length();
                this.comboBox.getToolkit().beep();
            }
            if (item != null) {
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            }
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(this.getLength());
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.model.setSelectedItem(item);
            this.selecting = false;
        }

        private void addSelectedItem() {
            try {
                String tbl = (String)JTicketsBagRestaurantMap.this.jTablesCombo.getSelectedItem();
                for (Place pl : JTicketsBagRestaurantMap.this.m_aplaces) {
                    if (!tbl.equals(pl.getName())) continue;
                    pl.getButton().doClick();
                    JTicketsBagRestaurantMap.this.jTablesCombo.setSelectedItem(null);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Object currentItem = this.model.getElementAt(i);
                if (!this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
                return currentItem;
            }
            return null;
        }

        private boolean startsWithIgnoreCase(String str1, String str2) {
            return str1.toUpperCase().startsWith(str2.toUpperCase());
        }
    }

    private class MyActionListener
    implements ActionListener {
        private Place m_place;

        public MyActionListener(Place place) {
            this.m_place = place;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TicketInfo ticket = JTicketsBagRestaurantMap.this.getTicketInfo(this.m_place);
            String resource = JTicketsBagRestaurantMap.this.dlSystem.getResourceAsXML("Ticket.Buttons");
            if ((resource = resource.replaceAll("(?s)<!--.*?-->", "")).contains("key=\"ticket.tableselected\"")) {
                try {
                    resource = JTicketsBagRestaurantMap.this.dlSystem.getResourceAsXML("event.tableselected");
                    ScriptObject scr = new ScriptObject(ticket, this.m_place);
                    Object result = scr.evalScript(resource);
                    if (result != null) {
                        return;
                    }
                }
                catch (Exception e) {
                    new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                }
            }
            try {
                String lockedby = JTicketsBagRestaurantMap.this.dlReceipts.isTableLocked(this.m_place.getId());
                if (lockedby != null) {
                    new MessageInf(-33554432, AppLocal.getIntString("message.tablelocked") + lockedby).show(JTicketsBagRestaurantMap.this);
                    return;
                }
            }
            catch (Exception e) {
                new MessageInf(e).show(JTicketsBagRestaurantMap.this);
            }
            if (JTicketsBagRestaurantMap.this.m_PlaceClipboard == null) {
                if (JTicketsBagRestaurantMap.this.customer == null) {
                    if (ticket == null && !this.m_place.hasPeople()) {
                        ticket = new TicketInfo();
                        this.m_place.setTimer(ticket.getTimer());
                        try {
                            JTicketsBagRestaurantMap.this.dlReceipts.insertSharedTicket(this.m_place.getId(), ticket, 2, JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().getName());
                        }
                        catch (BasicException e) {
                            new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                        }
                        this.m_place.setPeople(true);
                        if (JTicketsBagRestaurantMap.this.m_blTimer) {
                            this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                        }
                        JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                    } else if (ticket == null && this.m_place.hasPeople()) {
                        new MessageInf(-33554432, AppLocal.getIntString("message.tableempty")).show(JTicketsBagRestaurantMap.this);
                        this.m_place.setPeople(false);
                        if (JTicketsBagRestaurantMap.this.m_blTimer) {
                            this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                        }
                        this.m_place.setLabel(this.m_place.getName());
                    } else if (ticket != null && !this.m_place.hasPeople()) {
                        new MessageInf(-33554432, AppLocal.getIntString("message.tablefull")).show(JTicketsBagRestaurantMap.this);
                        this.m_place.setPeople(true);
                        this.m_place.setTimer(ticket.getTimer());
                        if (!JTicketsBagRestaurantMap.this.m_sTabeLabel.equals("")) {
                            this.m_place.setLabel(JTicketsBagRestaurantMap.this.readTableLabel(ticket, JTicketsBagRestaurantMap.this.m_sTabeLabel, this.m_place));
                        }
                        if (JTicketsBagRestaurantMap.this.m_blTimer) {
                            this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                        }
                    } else {
                        JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                    }
                } else if (ticket == null) {
                    ticket = new TicketInfo();
                    this.m_place.setTimer(ticket.getTimer());
                    try {
                        ticket.setCustomer(JTicketsBagRestaurantMap.this.customer.getId() == null ? null : JTicketsBagRestaurantMap.this.dlSales.loadCustomerExt(JTicketsBagRestaurantMap.this.customer.getId()));
                    }
                    catch (BasicException e) {
                        MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), e);
                        msg.show(JTicketsBagRestaurantMap.this);
                    }
                    try {
                        JTicketsBagRestaurantMap.this.dlReceipts.insertSharedTicket(this.m_place.getId(), ticket, 2, JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().getName());
                    }
                    catch (BasicException e) {
                        new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                    }
                    this.m_place.setPeople(true);
                    if (JTicketsBagRestaurantMap.this.m_blTimer) {
                        this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                    }
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                    JTicketsBagRestaurantMap.this.customer = null;
                    JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                } else {
                    new MessageInf(-33554432, AppLocal.getIntString("message.tablefull")).show(JTicketsBagRestaurantMap.this);
                    this.m_place.setPeople(true);
                    if (JTicketsBagRestaurantMap.this.m_blTimer) {
                        this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                    }
                    this.m_place.getButton().setEnabled(false);
                }
            } else {
                Place placeclip;
                TicketInfo ticketclip = JTicketsBagRestaurantMap.this.getTicketInfo(JTicketsBagRestaurantMap.this.m_PlaceClipboard);
                if (ticketclip == null) {
                    new MessageInf(-33554432, AppLocal.getIntString("message.tableempty")).show(JTicketsBagRestaurantMap.this);
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                    if (JTicketsBagRestaurantMap.this.m_blTimer) {
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                    }
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard.setLabel(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getName());
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                    JTicketsBagRestaurantMap.this.customer = null;
                    JTicketsBagRestaurantMap.this.printState();
                } else if (JTicketsBagRestaurantMap.this.m_PlaceClipboard == this.m_place) {
                    placeclip = JTicketsBagRestaurantMap.this.m_PlaceClipboard;
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                    JTicketsBagRestaurantMap.this.customer = null;
                    JTicketsBagRestaurantMap.this.printState();
                    JTicketsBagRestaurantMap.this.setActivePlace(placeclip, ticketclip);
                } else if (!this.m_place.hasPeople()) {
                    if (ticket == null) {
                        try {
                            JTicketsBagRestaurantMap.this.dlReceipts.insertSharedTicket(this.m_place.getId(), ticketclip, 2, JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().getName());
                            this.m_place.setPeople(true);
                            this.m_place.setTimer(ticketclip.getTimer());
                            if (JTicketsBagRestaurantMap.this.m_blTimer) {
                                this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                            }
                            JTicketsBagRestaurantMap.this.dlReceipts.deleteSharedTicket(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getId());
                            JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                            if (JTicketsBagRestaurantMap.this.m_blTimer) {
                                JTicketsBagRestaurantMap.this.m_PlaceClipboard.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                            }
                            JTicketsBagRestaurantMap.this.m_PlaceClipboard.setLabel(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getName());
                        }
                        catch (BasicException e) {
                            new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                        }
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                        JTicketsBagRestaurantMap.this.customer = null;
                        JTicketsBagRestaurantMap.this.printState();
                        JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticketclip);
                    } else {
                        new MessageInf(-33554432, AppLocal.getIntString("message.tablefull")).show(JTicketsBagRestaurantMap.this);
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(true);
                        if (JTicketsBagRestaurantMap.this.m_blTimer) {
                            JTicketsBagRestaurantMap.this.m_PlaceClipboard.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                        }
                        JTicketsBagRestaurantMap.this.printState();
                    }
                } else if (ticket == null) {
                    new MessageInf(-33554432, AppLocal.getIntString("message.tableempty")).show(JTicketsBagRestaurantMap.this);
                    this.m_place.setPeople(false);
                    if (JTicketsBagRestaurantMap.this.m_blTimer) {
                        this.m_place.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                    }
                    this.m_place.setLabel(this.m_place.getName());
                } else if (JOptionPane.showConfirmDialog(JTicketsBagRestaurantMap.this, AppLocal.getIntString("message.mergetablequestion"), AppLocal.getIntString("message.mergetable"), 0) == 0) {
                    try {
                        JTicketsBagRestaurantMap.this.dlReceipts.deleteSharedTicket(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getId());
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                        if (JTicketsBagRestaurantMap.this.m_blTimer) {
                            JTicketsBagRestaurantMap.this.m_PlaceClipboard.showCounter(JTicketsBagRestaurantMap.this.m_iAlertAfter);
                        }
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.setLabel(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getName());
                        if (ticket.getCustomer() == null) {
                            ticket.setCustomer(ticketclip.getCustomer());
                        }
                        for (TicketLineInfo line : ticketclip.getLines()) {
                            ticket.addLine(line);
                        }
                        JTicketsBagRestaurantMap.this.dlReceipts.updateSharedTicket(this.m_place.getId(), ticket);
                    }
                    catch (BasicException e) {
                        new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                    }
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                    JTicketsBagRestaurantMap.this.customer = null;
                    JTicketsBagRestaurantMap.this.printState();
                    JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                } else {
                    placeclip = JTicketsBagRestaurantMap.this.m_PlaceClipboard;
                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                    JTicketsBagRestaurantMap.this.customer = null;
                    JTicketsBagRestaurantMap.this.printState();
                    JTicketsBagRestaurantMap.this.setActivePlace(placeclip, ticketclip);
                }
            }
        }
    }

    public class ScriptObject {
        private TicketInfo ticket;
        private Object ticketext;

        private ScriptObject(TicketInfo ticket, Object ticketext) {
            this.ticket = ticket;
            this.ticketext = ticketext;
        }

        public Object evalScript(String code) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            script.put("ticket", this.ticket);
            script.put("place", this.ticketext);
            script.put("taxes", JTicketsBagRestaurantMap.this.taxcollection);
            script.put("taxeslogic", JTicketsBagRestaurantMap.this.taxeslogic);
            script.put("user", JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser());
            script.put("sales", this);
            return script.eval(code);
        }
    }
}

