/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.restaurant;

import com.posics.basic.BasicException;
import com.posics.data.gui.NullIcon;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.SerializableRead;
import com.posics.pos.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class Place
implements SerializableRead,
Serializable {
    private static final long serialVersionUID = 8652254694281L;
    private static final Icon ICO_OCU = new ImageIcon(Place.class.getResource("/com/posics/images/edit_group.png"));
    private static final Icon ICO_OCU_RED = new ImageIcon(Place.class.getResource("/com/posics/images/customerred.png"));
    private static final Icon ICO_FRE = new NullIcon(22, 22);
    private String m_sId;
    private String m_sLabel;
    private String m_sName;
    private String m_sFloorName;
    private int m_ix;
    private int m_iy;
    private int m_iwidth;
    private int m_iheight;
    private String m_sfloor;
    private boolean m_bPeople;
    private boolean m_bIsAppOrder = false;
    private JButton m_btn;
    private JLabel m_lblTimer;
    private int m_diffx;
    private int m_diffy;
    private Boolean m_changed = false;
    private Date m_dTimer;

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sId = dr.getString(1);
        this.m_sLabel = this.m_sName = dr.getString(2);
        this.m_ix = dr.getInt(3);
        this.m_iy = dr.getInt(4);
        this.m_sfloor = dr.getString(5);
        this.m_sFloorName = dr.getString(6);
        this.m_bPeople = false;
        this.addButton();
    }

    public void addButton() {
        this.m_btn = new JButton();
        this.m_lblTimer = new JLabel();
        this.m_btn.setFocusPainted(false);
        this.m_btn.setFocusable(false);
        this.m_btn.setRequestFocusEnabled(false);
        this.m_btn.setHorizontalTextPosition(0);
        this.m_btn.setVerticalTextPosition(3);
        this.m_btn.setIcon(ICO_FRE);
        this.m_btn.setText(this.m_sName);
        this.m_lblTimer.setMinimumSize(this.m_btn.getMinimumSize());
        this.m_lblTimer.setPreferredSize(this.m_btn.getPreferredSize());
        this.m_lblTimer.setMaximumSize(this.m_btn.getMaximumSize());
        this.m_lblTimer.setHorizontalAlignment(4);
        this.m_lblTimer.setVerticalAlignment(1);
        this.m_lblTimer.setForeground(Color.white);
        this.m_btn.setMargin(new Insets(0, 0, 0, 0));
        this.m_btn.add((Component)this.m_lblTimer, "Before");
        this.setButtonBounds();
        this.getButton().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent E) {
                if (StringUtils.m_blTableLayoutRunning) {
                    if (Place.this.getDiffX() == 0) {
                        Place.this.setDiffX(Place.this.getButton().getX() - Place.this.getX());
                        Place.this.setDiffY(Place.this.getButton().getY() - Place.this.getY());
                    }
                    int newX = E.getX() + Place.this.getButton().getX();
                    int newY = E.getY() + Place.this.getButton().getY();
                    Place.this.getButton().setBounds(newX + Place.this.getDiffX(), newY + Place.this.getDiffY(), Place.this.getButton().getWidth(), Place.this.getButton().getHeight());
                    Place.this.setX(newX);
                    Place.this.setY(newY);
                }
            }
        });
    }

    public String getId() {
        return this.m_sId;
    }

    public void setId() {
        this.m_sId = UUID.randomUUID().toString();
    }

    public void setId(String id) {
        this.m_sId = id;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String tblname) {
        this.m_sName = tblname;
    }

    public String getLabel() {
        return this.m_sLabel;
    }

    public void setLabel(String strLabel) {
        this.m_sLabel = strLabel;
        this.m_btn.setText(this.m_sLabel);
    }

    public int getX() {
        return this.m_ix;
    }

    public int getY() {
        return this.m_iy;
    }

    public void setX(int x) {
        this.m_ix = x;
    }

    public void setY(int y) {
        this.m_iy = y;
    }

    public int getDiffX() {
        return this.m_diffx;
    }

    public int getDiffY() {
        return this.m_diffy;
    }

    public void setDiffX(int x) {
        this.m_diffx = x;
    }

    public void setDiffY(int y) {
        this.m_diffy = y;
    }

    public Boolean getChanged() {
        return this.m_changed;
    }

    public void setChanged(Boolean changed) {
        this.m_changed = changed;
    }

    public String getFloor() {
        return this.m_sfloor;
    }

    public void setFloor(String floor) {
        this.m_sfloor = floor;
    }

    public String getFloorName() {
        return this.m_sFloorName;
    }

    public void setFloorName(String floorname) {
        this.m_sFloorName = floorname;
    }

    public JButton getButton() {
        return this.m_btn;
    }

    public void setSize(int width, int height) {
        this.m_btn.setPreferredSize(new Dimension(width, height));
    }

    public boolean hasPeople() {
        return this.m_bPeople;
    }

    public void setPeople(boolean bValue) {
        this.m_bPeople = bValue;
        if (!bValue) {
            this.m_dTimer = null;
        }
        this.m_btn.setIcon(bValue ? ICO_OCU : ICO_FRE);
    }

    public void setTimer(Date date) {
        this.m_dTimer = date;
    }

    public void setAppOrder() {
        this.m_bIsAppOrder = true;
    }

    public boolean isAppOrder() {
        return this.m_bIsAppOrder;
    }

    public void showCounter(int alertafter) {
        if (this.m_dTimer != null) {
            long tStart = this.m_dTimer.getTime();
            long tEnd = System.currentTimeMillis();
            long tElapsed = tEnd - tStart;
            long tMinutes = TimeUnit.MILLISECONDS.toMinutes(tElapsed);
            if (tMinutes > (long)alertafter) {
                this.m_lblTimer.setForeground(Color.red);
                this.m_btn.setIcon(ICO_OCU_RED);
            } else {
                this.m_lblTimer.setForeground(Color.blue);
                this.m_btn.setIcon(ICO_OCU);
            }
            long hours = tMinutes / 60L;
            long minutes = tMinutes % 60L;
            this.m_lblTimer.setText("<html><font bgcolor=black>" + String.format("%d:%02d", hours, minutes));
        } else {
            this.m_lblTimer.setText("");
            this.m_btn.setIcon(ICO_FRE);
        }
    }

    public void setButtonBounds() {
        Dimension d = this.m_btn.getPreferredSize();
        this.m_btn.setBounds(this.m_ix - d.width / 2, this.m_iy - d.height / 2, d.width, d.height);
    }
}

