/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.sales.shared;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.sales.DataLogicReceipts;
import com.posics.pos.sales.JPanelButtons;
import com.posics.pos.sales.JTicketsBag;
import com.posics.pos.sales.SharedTicketInfo;
import com.posics.pos.sales.TicketsEditor;
import com.posics.pos.sales.shared.JTicketsBagSharedList;
import com.posics.pos.scripting.ScriptEngine;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import com.posics.pos.ticket.TicketInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JTicketsBagShared
extends JTicketsBag {
    private String m_sCurrentTicket = null;
    private DataLogicReceipts dlReceipts = null;
    protected JPanelButtons m_jbtnconfig;
    protected DataLogicSystem dlSystem;
    private JPanel jPanel1;
    private JButton m_jDelTicket;
    private JButton m_jListTickets;
    private JButton m_jNewTicket;

    public JTicketsBagShared(AppView app, TicketsEditor panelticket) {
        super(app, panelticket);
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.posics.pos.sales.DataLogicReceipts");
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.posics.pos.forms.DataLogicSystem");
        this.initComponents();
    }

    @Override
    public void activate() {
        this.m_sCurrentTicket = null;
        this.selectValidTicket();
        this.m_jDelTicket.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("com.posics.pos.sales.JPanelTicketEdits"));
    }

    @Override
    public boolean deactivate() {
        this.saveCurrentTicket();
        this.m_sCurrentTicket = null;
        this.m_panelticket.setActiveTicket(null, null);
        return true;
    }

    @Override
    public int getBillingMode() {
        return 1;
    }

    @Override
    public void deleteTicket() {
        String resource = this.dlSystem.getResourceAsXML("Ticket.Buttons");
        if (!(resource = resource.replaceAll("(?s)<!--.*?-->", "")).contains("key=\"ticket.delete\"")) {
            this.m_sCurrentTicket = null;
            this.selectValidTicket();
        } else {
            resource = this.dlSystem.getResourceAsXML("event.delete");
            String place = this.m_panelticket.getActiveTicket().getId();
            try {
                ScriptObject scr = new ScriptObject(this.m_panelticket.getActiveTicket(), place);
                Object result = scr.evalScript(resource);
                if (result == null) {
                    this.m_sCurrentTicket = null;
                    this.selectValidTicket();
                }
            }
            catch (Exception e) {
                MessageInf messageInf = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
            }
        }
    }

    @Override
    protected JComponent getBagComponent() {
        return this;
    }

    @Override
    protected JComponent getNullComponent() {
        return new JPanel();
    }

    private void saveCurrentTicket() {
        if (this.m_sCurrentTicket != null) {
            try {
                this.dlReceipts.insertSharedTicket(this.m_sCurrentTicket, this.m_panelticket.getActiveTicket(), 1, this.m_App.getAppUserView().getUser().getName());
                TicketInfo l = this.dlReceipts.getSharedTicket(this.m_sCurrentTicket);
                if (l.getLinesCount() == 0) {
                    this.dlReceipts.deleteSharedTicket(this.m_sCurrentTicket);
                }
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
        }
    }

    private void setActiveTicket(String id) throws BasicException {
        TicketInfo ticket = this.dlReceipts.getSharedTicket(id);
        if (ticket == null) {
            throw new BasicException(AppLocal.getIntString("message.noticket"));
        }
        this.dlReceipts.deleteSharedTicket(id);
        this.m_sCurrentTicket = id;
        this.m_panelticket.setActiveTicket(ticket, null);
    }

    private void selectValidTicket() {
        this.newTicket();
    }

    private void newTicket() {
        this.saveCurrentTicket();
        TicketInfo ticket = new TicketInfo();
        this.m_sCurrentTicket = UUID.randomUUID().toString();
        this.m_panelticket.setActiveTicket(ticket, null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.m_jNewTicket = new JButton();
        this.m_jDelTicket = new JButton();
        this.m_jListTickets = new JButton();
        this.setLayout(new BorderLayout());
        this.m_jNewTicket.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/editnew.png")));
        this.m_jNewTicket.setToolTipText("New Bill (F3)");
        this.m_jNewTicket.setFocusPainted(false);
        this.m_jNewTicket.setFocusable(false);
        this.m_jNewTicket.setMargin(new Insets(8, 14, 8, 14));
        this.m_jNewTicket.setRequestFocusEnabled(false);
        this.m_jNewTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagShared.this.m_jNewTicketActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jNewTicket);
        this.m_jDelTicket.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/editdelete.png")));
        this.m_jDelTicket.setToolTipText("Delete Bill (F4)");
        this.m_jDelTicket.setFocusPainted(false);
        this.m_jDelTicket.setFocusable(false);
        this.m_jDelTicket.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDelTicket.setRequestFocusEnabled(false);
        this.m_jDelTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagShared.this.m_jDelTicketActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jDelTicket);
        this.m_jListTickets.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/ticketqueue.png")));
        this.m_jListTickets.setToolTipText("Bill Queue (F5)");
        this.m_jListTickets.setFocusPainted(false);
        this.m_jListTickets.setFocusable(false);
        this.m_jListTickets.setMargin(new Insets(8, 14, 8, 14));
        this.m_jListTickets.setRequestFocusEnabled(false);
        this.m_jListTickets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagShared.this.m_jListTicketsActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jListTickets);
        this.add((Component)this.jPanel1, "West");
    }

    private void m_jListTicketsActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    List<SharedTicketInfo> l = JTicketsBagShared.this.dlReceipts.getSharedTicketList(1);
                    JTicketsBagSharedList listDialog = JTicketsBagSharedList.newJDialog(JTicketsBagShared.this);
                    String id = listDialog.showTicketsList(l);
                    if (id != null) {
                        JTicketsBagShared.this.saveCurrentTicket();
                        JTicketsBagShared.this.setActiveTicket(id);
                    }
                }
                catch (BasicException e) {
                    new MessageInf(e).show(JTicketsBagShared.this);
                    JTicketsBagShared.this.newTicket();
                }
            }
        });
    }

    private void m_jDelTicketActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannadelete"), AppLocal.getIntString("title.editor"), 0, 3);
        if (res == 0) {
            this.deleteTicket();
        }
    }

    private void m_jNewTicketActionPerformed(ActionEvent evt) {
        this.newTicket();
    }

    public class ScriptObject {
        private TicketInfo ticket;
        private Object ticketext;

        private ScriptObject(TicketInfo ticket, Object ticketext) {
            this.ticket = ticket;
            this.ticketext = ticketext;
        }

        public Object evalScript(String code) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            script.put("ticket", this.ticket);
            script.put("user", JTicketsBagShared.this.m_App.getAppUserView().getUser());
            script.put("sales", this);
            return script.eval(code);
        }
    }
}

