/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.scale;

import com.posics.pos.scale.Scale;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public class ScaleComm
implements Scale,
SerialPortEventListener {
    private String m_sPortScale;
    private CommPortIdentifier m_PortIdPrinter;
    private SerialPort m_CommPortPrinter;
    private Integer m_iBaud;
    private OutputStream m_out;
    private InputStream m_in;
    private static final int SCALE_READY = 0;
    private static final int SCALE_READING = 1;
    private double m_dWeightBuffer;
    private int m_iStatusScale;

    public ScaleComm(String sPortPrinter, Integer iBaud) {
        this.m_sPortScale = sPortPrinter;
        this.m_iBaud = iBaud;
        this.m_out = null;
        this.m_in = null;
        this.m_iStatusScale = 0;
        this.m_dWeightBuffer = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double readWeight() {
        ScaleComm scaleComm = this;
        synchronized (scaleComm) {
            if (this.m_iStatusScale != 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_iStatusScale != 0) {
                    this.m_iStatusScale = 0;
                }
            }
            this.m_dWeightBuffer = 0.0;
            this.write(new byte[]{5});
            this.flush();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_iStatusScale == 0) {
                double dWeight = this.m_dWeightBuffer / 1000.0;
                this.m_dWeightBuffer = 0.0;
                return new Double(dWeight);
            }
            this.m_iStatusScale = 0;
            this.m_dWeightBuffer = 0.0;
            return new Double(0.0);
        }
    }

    private void flush() {
        try {
            this.m_out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] data) {
        try {
            if (this.m_out == null) {
                this.m_PortIdPrinter = CommPortIdentifier.getPortIdentifier(this.m_sPortScale);
                this.m_CommPortPrinter = (SerialPort)this.m_PortIdPrinter.open("PORTID", 2000);
                this.m_out = this.m_CommPortPrinter.getOutputStream();
                this.m_in = this.m_CommPortPrinter.getInputStream();
                this.m_CommPortPrinter.addEventListener(this);
                this.m_CommPortPrinter.notifyOnDataAvailable(true);
                this.m_CommPortPrinter.setSerialPortParams(this.m_iBaud, 8, 1, 1);
            }
            this.m_out.write(data);
        }
        catch (NoSuchPortException e) {
            e.printStackTrace();
        }
        catch (PortInUseException e) {
            e.printStackTrace();
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void serialEvent(SerialPortEvent e) {
        block14: {
            switch (e.getEventType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return;
                }
                case 1: {
                    try {}
                    catch (IOException iOException) {
                        // empty catch block
                        return;
                    }
                    break block14;
                }
            }
            return;
        }
        while (this.m_in.available() > 0) {
            ScaleComm scaleComm;
            int b = this.m_in.read();
            if (b == 30) {
                scaleComm = this;
                synchronized (scaleComm) {
                    this.m_iStatusScale = 0;
                    this.notifyAll();
                    continue;
                }
            }
            if (b > 47 && b < 58) {
                scaleComm = this;
                synchronized (scaleComm) {
                    if (this.m_iStatusScale == 0) {
                        this.m_dWeightBuffer = 0.0;
                        this.m_iStatusScale = 1;
                    }
                    this.m_dWeightBuffer = this.m_dWeightBuffer * 10.0 + (double)b - 48.0;
                    continue;
                }
            }
            this.m_dWeightBuffer = 0.0;
            this.m_iStatusScale = 0;
        }
    }
}

