/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.suppliers;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataParams;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.QBFBuilder;
import com.posics.data.loader.SentenceList;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerWrite;
import com.posics.data.loader.SerializerWriteBasic;
import com.posics.data.loader.SerializerWriteParams;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.data.loader.TableDefinition;
import com.posics.format.Formats;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.BeanFactoryDataSingle;
import com.posics.pos.suppliers.SupplierInfo;
import com.posics.pos.suppliers.SupplierInfoExt;

public class DataLogicSuppliers
extends BeanFactoryDataSingle {
    protected Session s;
    private TableDefinition tsuppliers;
    private static Datas[] supplierdatas = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.INT, Datas.BOOLEAN, Datas.STRING};

    @Override
    public void init(Session s) {
        this.s = s;
        this.tsuppliers = new TableDefinition(s, "SUPPLIERS", new String[]{"ID", "TAXID", "SEARCHKEY", "NAME", "NOTES", "VISIBLE", "CARD", "MAXDEBT", "CURDATE", "CURDEBT", "FIRSTNAME", "LASTNAME", "EMAIL", "PHONE", "PHONE2", "FAX", "ADDRESS", "ADDRESS2", "POSTAL", "CITY", "REGION", "COUNTRY", "TAXCATEGORY"}, new String[]{"ID", AppLocal.getIntString("label.taxid"), AppLocal.getIntString("label.searchkey"), AppLocal.getIntString("label.name"), AppLocal.getIntString("label.notes"), "VISIBLE", "CARD", AppLocal.getIntString("label.maxdebt"), AppLocal.getIntString("label.curdate"), AppLocal.getIntString("label.curdebt"), AppLocal.getIntString("label.firstname"), AppLocal.getIntString("label.lastname"), AppLocal.getIntString("label.email"), AppLocal.getIntString("label.phone"), AppLocal.getIntString("label.phone2"), AppLocal.getIntString("label.fax"), AppLocal.getIntString("label.address"), AppLocal.getIntString("label.address2"), AppLocal.getIntString("label.postal"), AppLocal.getIntString("label.city"), AppLocal.getIntString("label.region"), AppLocal.getIntString("label.country"), "TAXCATEGORY"}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.BOOLEAN, Datas.STRING, Datas.DOUBLE, Datas.TIMESTAMP, Datas.DOUBLE, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.BOOLEAN, Formats.STRING, Formats.CURRENCY, Formats.TIMESTAMP, Formats.CURRENCY, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public SentenceList getSupplierList() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT ID, TAXID, SEARCHKEY, NAME FROM SUPPLIERS WHERE VISIBLE = " + this.s.DB.TRUE() + " AND ?(QBF_FILTER) ORDER BY NAME", new String[]{"TAXID", "SEARCHKEY", "NAME"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING, Datas.OBJECT, Datas.STRING), new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                SupplierInfo c = new SupplierInfo(dr.getString(1));
                c.setTaxid(dr.getString(2));
                c.setSearchkey(dr.getString(3));
                c.setName(dr.getString(4));
                return c;
            }
        });
    }

    public int updateSupplierExt(final SupplierInfoExt supplier) throws BasicException {
        return new PreparedSentence(this.s, "UPDATE SUPPLIERS SET NOTES = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, supplier.getNotes());
                this.setString(2, supplier.getId());
            }
        });
    }

    public final TableDefinition getTableSuppliers() {
        return this.tsuppliers;
    }

    public SupplierInfoExt loadSupplierExt(String id) throws BasicException {
        return (SupplierInfoExt)new PreparedSentence(this.s, "SELECT ID, TAXID, SEARCHKEY, NAME, CARD, TAXCATEGORY, NOTES, MAXDEBT, VISIBLE, CURDATE, CURDEBT, FIRSTNAME, LASTNAME, EMAIL, PHONE, PHONE2, FAX, ADDRESS, ADDRESS2, POSTAL, CITY, REGION, COUNTRY FROM SUPPLIERS WHERE ID = ?", SerializerWriteString.INSTANCE, new SupplierExtRead()).find((Object)id);
    }

    protected static class SupplierExtRead
    implements SerializerRead {
        protected SupplierExtRead() {
        }

        @Override
        public Object readValues(DataRead dr) throws BasicException {
            SupplierInfoExt c = new SupplierInfoExt(dr.getString(1));
            c.setTaxid(dr.getString(2));
            c.setSearchkey(dr.getString(3));
            c.setName(dr.getString(4));
            c.setCard(dr.getString(5));
            c.setTaxSupplierID(dr.getString(6));
            c.setNotes(dr.getString(7));
            c.setMaxdebt(dr.getDouble(8));
            c.setVisible(dr.getBoolean(9));
            c.setCurdate(dr.getTimestamp(10));
            c.setCurdebt(dr.getDouble(11));
            c.setFirstname(dr.getString(12));
            c.setLastname(dr.getString(13));
            c.setEmail(dr.getString(14));
            c.setPhone(dr.getString(15));
            c.setPhone2(dr.getString(16));
            c.setFax(dr.getString(17));
            c.setAddress(dr.getString(18));
            c.setAddress2(dr.getString(19));
            c.setPostal(dr.getString(20));
            c.setCity(dr.getString(21));
            c.setRegion(dr.getString(22));
            c.setCountry(dr.getString(23));
            return c;
        }
    }
}

