/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.suppliers;

import com.posics.basic.BasicException;
import com.posics.data.loader.QBFCompareEnum;
import com.posics.data.user.EditorCreator;
import com.posics.data.user.ListProvider;
import com.posics.data.user.ListProviderCreator;
import com.posics.editor.JEditorKeys;
import com.posics.editor.JEditorString;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.suppliers.DataLogicSuppliers;
import com.posics.pos.suppliers.SupplierInfo;
import com.posics.pos.suppliers.SupplierRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSupplierFinder
extends JDialog
implements EditorCreator {
    private SupplierInfo selectedSupplier;
    private ListProvider lpr;
    private JButton jButton1;
    private JButton jButton3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jListSuppliers;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JButton jcmdCancel;
    private JButton jcmdOK;
    private JEditorKeys m_jKeys;
    private JEditorString m_jtxtName;
    private JEditorString m_jtxtSearchKey;
    private JEditorString m_jtxtTaxID;

    private JSupplierFinder(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JSupplierFinder(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    public static JSupplierFinder getSupplierFinder(Component parent, DataLogicSuppliers dlSuppliers) {
        Window window = JSupplierFinder.getWindow(parent);
        JSupplierFinder myMsg = window instanceof Frame ? new JSupplierFinder((Frame)window, true) : new JSupplierFinder((Dialog)window, true);
        myMsg.init(dlSuppliers);
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        return myMsg;
    }

    public SupplierInfo getSelectedSupplier() {
        return this.selectedSupplier;
    }

    private void init(DataLogicSuppliers dlSuppliers) {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        this.m_jtxtTaxID.addEditorKeys(this.m_jKeys);
        this.m_jtxtSearchKey.addEditorKeys(this.m_jKeys);
        this.m_jtxtName.addEditorKeys(this.m_jKeys);
        this.m_jtxtTaxID.reset();
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtTaxID.activate();
        this.lpr = new ListProviderCreator(dlSuppliers.getSupplierList(), this);
        this.jListSuppliers.setCellRenderer(new SupplierRenderer());
        this.getRootPane().setDefaultButton(this.jcmdOK);
        this.selectedSupplier = null;
    }

    public void search(SupplierInfo Supplier2) {
        if (Supplier2 == null || Supplier2.getName() == null || Supplier2.getName().equals("")) {
            this.m_jtxtTaxID.reset();
            this.m_jtxtSearchKey.reset();
            this.m_jtxtName.reset();
            this.m_jtxtTaxID.activate();
            this.cleanSearch();
        } else {
            this.m_jtxtTaxID.setText(Supplier2.getTaxid());
            this.m_jtxtSearchKey.setText(Supplier2.getSearchkey());
            this.m_jtxtName.setText(Supplier2.getName());
            this.m_jtxtTaxID.activate();
            this.executeSearch();
        }
    }

    private void cleanSearch() {
        this.jListSuppliers.setModel(new MyListDataS(new ArrayList()));
    }

    public void executeSearch() {
        try {
            this.jListSuppliers.setModel(new MyListDataS(this.lpr.loadData()));
            if (this.jListSuppliers.getModel().getSize() > 0) {
                this.jListSuppliers.setSelectedIndex(0);
            }
        }
        catch (BasicException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] afilter = new Object[6];
        if (this.m_jtxtTaxID.getText() == null || this.m_jtxtTaxID.getText().equals("")) {
            afilter[0] = QBFCompareEnum.COMP_NONE;
            afilter[1] = null;
        } else {
            afilter[0] = QBFCompareEnum.COMP_RE;
            afilter[1] = "%" + this.m_jtxtTaxID.getText() + "%";
        }
        if (this.m_jtxtSearchKey.getText() == null || this.m_jtxtSearchKey.getText().equals("")) {
            afilter[2] = QBFCompareEnum.COMP_NONE;
            afilter[3] = null;
        } else {
            afilter[2] = QBFCompareEnum.COMP_RE;
            afilter[3] = "%" + this.m_jtxtSearchKey.getText() + "%";
        }
        if (this.m_jtxtName.getText() == null || this.m_jtxtName.getText().equals("")) {
            afilter[4] = QBFCompareEnum.COMP_NONE;
            afilter[5] = null;
        } else {
            afilter[4] = QBFCompareEnum.COMP_RE;
            afilter[5] = "%" + this.m_jtxtName.getText() + "%";
        }
        return afilter;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JSupplierFinder.getWindow(parent.getParent());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.m_jtxtName = new JEditorString();
        this.jLabel6 = new JLabel();
        this.m_jtxtSearchKey = new JEditorString();
        this.jLabel7 = new JLabel();
        this.m_jtxtTaxID = new JEditorString();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListSuppliers = new JList();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jcmdOK = new JButton();
        this.jcmdCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("form.supplierstitle"));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.m_jKeys, "North");
        this.getContentPane().add((Component)this.jPanel2, "After");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jLabel5.setText(AppLocal.getIntString("label.prodname"));
        this.jLabel6.setText(AppLocal.getIntString("label.searchkey"));
        this.jLabel7.setText(AppLocal.getIntString("label.taxid"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel7, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtTaxID, -2, 220, -2)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtName, -2, 220, -2)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtSearchKey, -2, 220, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, 25, -2).addComponent(this.m_jtxtTaxID, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -2, 25, -2).addComponent(this.m_jtxtSearchKey, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 25, -2).addComponent(this.m_jtxtName, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.add((Component)this.jPanel7, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/reset.png")));
        this.jButton1.setText(AppLocal.getIntString("button.clean"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSupplierFinder.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/launch.png")));
        this.jButton3.setText(AppLocal.getIntString("button.executefilter"));
        this.jButton3.setFocusPainted(false);
        this.jButton3.setFocusable(false);
        this.jButton3.setRequestFocusEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSupplierFinder.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton3);
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel3.add((Component)this.jPanel5, "First");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.jListSuppliers.setFocusable(false);
        this.jListSuppliers.setRequestFocusEnabled(false);
        this.jListSuppliers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JSupplierFinder.this.jListSuppliersMouseClicked(evt);
            }
        });
        this.jListSuppliers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JSupplierFinder.this.jListSuppliersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSuppliers);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel8.setLayout(new BorderLayout());
        this.jcmdOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.jcmdOK.setText(AppLocal.getIntString("Button.OK"));
        this.jcmdOK.setEnabled(false);
        this.jcmdOK.setFocusPainted(false);
        this.jcmdOK.setFocusable(false);
        this.jcmdOK.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdOK.setRequestFocusEnabled(false);
        this.jcmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSupplierFinder.this.jcmdOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdOK);
        this.jcmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.jcmdCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.jcmdCancel.setFocusPainted(false);
        this.jcmdCancel.setFocusable(false);
        this.jcmdCancel.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel.setRequestFocusEnabled(false);
        this.jcmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSupplierFinder.this.jcmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel);
        this.jPanel8.add((Component)this.jPanel1, "After");
        this.jPanel3.add((Component)this.jPanel8, "South");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 613) / 2, (screenSize.height - 610) / 2, 613, 610);
    }

    private void jcmdOKActionPerformed(ActionEvent evt) {
        this.selectedSupplier = (SupplierInfo)this.jListSuppliers.getSelectedValue();
        this.dispose();
    }

    private void jcmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.executeSearch();
    }

    private void jListSuppliersValueChanged(ListSelectionEvent evt) {
        this.jcmdOK.setEnabled(this.jListSuppliers.getSelectedValue() != null);
    }

    private void jListSuppliersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectedSupplier = (SupplierInfo)this.jListSuppliers.getSelectedValue();
            this.dispose();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.m_jtxtTaxID.reset();
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtTaxID.activate();
        this.cleanSearch();
    }

    private static class MyListDataS
    extends AbstractListModel {
        private List m_data;

        public MyListDataS(List data) {
            this.m_data = data;
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_data.get(index);
        }

        @Override
        public int getSize() {
            return this.m_data.size();
        }
    }
}

