/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.ticket;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataResultSet;
import com.posics.data.loader.ImageUtils;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadDouble;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.forms.AppViewConnection;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.StringUtils;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class ProductInfoExt {
    private static final long serialVersionUID = 7587696873036L;
    protected String m_ID = null;
    protected String m_sRef = "0000";
    protected String m_sCode = "0000";
    protected String m_sName = null;
    protected boolean m_bCom = false;
    protected boolean m_bScale = false;
    protected boolean m_bInCat = false;
    protected int m_iCatOrder = 0;
    protected String categoryid = null;
    protected String taxcategoryid = null;
    protected String attributesetid = null;
    protected double m_dPriceBuy = 0.0;
    protected double m_dPriceSell = 0.0;
    protected BufferedImage m_Image = null;
    protected Properties attributes = new Properties();

    public final String getID() {
        return this.m_ID;
    }

    public final void setID(String id) {
        this.m_ID = id;
    }

    public final String getReference() {
        return this.m_sRef;
    }

    public final void setReference(String sRef) {
        this.m_sRef = sRef;
    }

    public final String getCode() {
        return this.m_sCode;
    }

    public final void setCode(String sCode) {
        this.m_sCode = sCode;
    }

    public final String getName() {
        return this.m_sName;
    }

    public final String printName() {
        return StringUtils.encodeXML(this.m_sName);
    }

    public final void setName(String sName) {
        this.m_sName = sName;
    }

    public final boolean isCom() {
        return this.m_bCom;
    }

    public final void setCom(boolean bValue) {
        this.m_bCom = bValue;
    }

    public final boolean isScale() {
        return this.m_bScale;
    }

    public final boolean inCatlog() {
        return this.m_bInCat;
    }

    public final void setInCatalog(boolean bValue) {
        this.m_bInCat = bValue;
    }

    public int getOrder() {
        return this.m_iCatOrder;
    }

    public void setOrder(int catorder) {
        this.m_iCatOrder = catorder;
    }

    public final void setScale(boolean bValue) {
        this.m_bScale = bValue;
    }

    public final String getCategoryID() {
        return this.categoryid;
    }

    public final void setCategoryID(String sCategoryID) {
        this.categoryid = sCategoryID;
    }

    public final String getTaxCategoryID() {
        return this.taxcategoryid;
    }

    public final void setTaxCategoryID(String value) {
        this.taxcategoryid = value;
    }

    public final String getAttributeSetID() {
        return this.attributesetid;
    }

    public final void setAttributeSetID(String value) {
        this.attributesetid = value;
    }

    public final double getPriceBuy() {
        return this.m_dPriceBuy;
    }

    public final void setPriceBuy(double dPrice) {
        this.m_dPriceBuy = dPrice;
    }

    public final double getPriceSell() {
        return this.m_dPriceSell;
    }

    public final void setPriceSell(double dPrice) {
        this.m_dPriceSell = dPrice;
    }

    public final double getPriceSellTax(TaxInfo tax) {
        return this.m_dPriceSell * (1.0 + tax.getRate());
    }

    public String printPriceSell() {
        return Formats.CURRENCY.formatValue(new Double(this.getPriceSell()));
    }

    public String printPriceSellTax(TaxInfo tax) {
        return Formats.CURRENCY.formatValue(new Double(this.getPriceSellTax(tax)));
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }

    public void setImage(BufferedImage img) {
        this.m_Image = img;
    }

    public String getProperty(String key) {
        return this.attributes.getProperty(key);
    }

    public String getProperty(String key, String defaultvalue) {
        return this.attributes.getProperty(key, defaultvalue);
    }

    public void setProperty(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                ProductInfoExt product = new ProductInfoExt();
                product.m_ID = dr.getString(1);
                product.m_sRef = dr.getString(2);
                product.m_sCode = dr.getString(3);
                product.m_sName = dr.getString(4);
                product.m_bCom = dr.getBoolean(5);
                product.m_bScale = dr.getBoolean(6);
                product.m_dPriceBuy = dr.getDouble(7);
                product.m_dPriceSell = dr.getDouble(8);
                product.taxcategoryid = dr.getString(9);
                product.categoryid = dr.getString(10);
                product.attributesetid = dr.getString(11);
                product.m_Image = ImageUtils.readImage(dr.getBytes(12));
                product.attributes = ImageUtils.readProperties(dr.getBytes(13));
                product.m_bInCat = dr.getBoolean(14);
                product.m_iCatOrder = dr.getInt(15) != null ? dr.getInt(15) : 0;
                return product;
            }
        };
    }

    public final String toString() {
        return this.m_sRef + " - " + this.m_sName;
    }

    public double getTariffPrice(String tariff) {
        try {
            Session session = AppViewConnection.createSession(StringUtils.config);
            StaticSentence bsentence = new StaticSentence(session, "SELECT TAP.PRICESELL FROM TARIFFAREAS_PROD TAP JOIN TARIFFAREAS TA ON TA.ID = TAP.TARIFFID WHERE TA.NAME LIKE '" + tariff + "' AND TAP.PRODUCTID LIKE '" + this.m_ID + "'", null, SerializerReadDouble.INSTANCE);
            DataResultSet ds = bsentence.openExec(this);
            double tprice = 0.0;
            if (ds != null) {
                ds.next();
                tprice = Double.parseDouble(ds.getCurrent().toString());
            }
            session.close();
            return tprice;
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

