/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.ticket;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.LocalRes;
import com.posics.data.loader.SerializableRead;
import com.posics.format.Formats;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoMagcard;
import com.posics.pos.suppliers.SupplierInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.pos.ticket.TicketTaxInfo;
import com.posics.pos.ticket.UserInfo;
import com.posics.pos.util.SMS;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.TransliterateArabic;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class TicketInfo
implements SerializableRead,
Externalizable {
    private static final long serialVersionUID = 2765650092387265178L;
    public static final int RECEIPT_NORMAL = 0;
    public static final int RECEIPT_REFUND = 1;
    public static final int RECEIPT_PAYMENT = 2;
    public static final int SUPPLIER_PAYMENT = 3;
    private static DateFormat m_dateformat = new SimpleDateFormat("hh:mm");
    private String m_sId = UUID.randomUUID().toString();
    private int tickettype = 0;
    private int m_iTicketId = 0;
    private int m_iOrderNumber = 0;
    private Date m_dDate = new Date();
    private Date m_dTimer = new Date();
    private Properties attributes = new Properties();
    private UserInfo m_User = null;
    private CustomerInfoExt m_Customer = null;
    private SupplierInfoExt m_Supplier = null;
    private String m_sActiveCash = null;
    private List<TicketLineInfo> m_aLines = new ArrayList<TicketLineInfo>();
    private List<PaymentInfo> payments = new ArrayList<PaymentInfo>();
    private List<TicketTaxInfo> taxes = null;
    private boolean isAppOrder = false;
    private String m_sHost = null;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_sId);
        out.writeInt(this.tickettype);
        out.writeInt(this.m_iTicketId);
        out.writeObject(this.m_Customer);
        out.writeObject(this.m_Supplier);
        out.writeObject(this.m_dDate);
        out.writeObject(this.m_dTimer);
        out.writeObject(this.attributes);
        out.writeObject(this.m_aLines);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_sId = (String)in.readObject();
        this.tickettype = in.readInt();
        this.m_iTicketId = in.readInt();
        this.m_Customer = (CustomerInfoExt)in.readObject();
        this.m_Supplier = (SupplierInfoExt)in.readObject();
        this.m_dDate = (Date)in.readObject();
        this.m_dTimer = (Date)in.readObject();
        this.attributes = (Properties)in.readObject();
        this.m_aLines = (List)in.readObject();
        this.m_User = null;
        this.m_sActiveCash = null;
        this.payments = new ArrayList<PaymentInfo>();
        this.taxes = null;
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sId = dr.getString(1);
        this.tickettype = dr.getInt(2);
        this.m_iTicketId = dr.getInt(3);
        this.m_dDate = dr.getTimestamp(4);
        this.m_sActiveCash = dr.getString(5);
        try {
            byte[] img = dr.getBytes(6);
            if (img != null) {
                this.attributes.loadFromXML(new ByteArrayInputStream(img));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_User = new UserInfo(dr.getString(7), dr.getString(8), dr.getString(11));
        this.m_Customer = new CustomerInfoExt(dr.getString(9));
        this.m_Supplier = new SupplierInfoExt(dr.getString(10));
        this.m_aLines = new ArrayList<TicketLineInfo>();
        this.payments = new ArrayList<PaymentInfo>();
        this.taxes = null;
    }

    public TicketInfo copyTicket() {
        TicketInfo t = new TicketInfo();
        t.tickettype = this.tickettype;
        t.m_iTicketId = this.m_iTicketId;
        t.m_dDate = this.m_dDate;
        t.m_dTimer = this.m_dTimer;
        t.m_sActiveCash = this.m_sActiveCash;
        t.attributes = (Properties)this.attributes.clone();
        t.m_User = this.m_User;
        t.m_Customer = this.m_Customer;
        t.m_Supplier = this.m_Supplier;
        t.m_sHost = this.m_sHost;
        t.m_aLines = new ArrayList<TicketLineInfo>();
        for (TicketLineInfo l : this.m_aLines) {
            t.m_aLines.add(l.copyTicketLine());
        }
        t.refreshLines();
        t.payments = new LinkedList<PaymentInfo>();
        for (PaymentInfo p : this.payments) {
            t.payments.add(p.copyPayment());
        }
        return t;
    }

    public String getId() {
        return this.m_sId;
    }

    public int getTicketType() {
        return this.tickettype;
    }

    public void setTicketType(int tickettype) {
        this.tickettype = tickettype;
    }

    public void setIsAppOrder() {
        this.isAppOrder = true;
    }

    public boolean isAppOrder() {
        return this.isAppOrder;
    }

    public int getTicketId() {
        return this.m_iTicketId;
    }

    public void setTicketId(int iTicketId) {
        this.m_iTicketId = iTicketId;
    }

    public void setOrderNumber(int iOrderNumber) {
        this.m_iOrderNumber = iOrderNumber;
    }

    public Integer getOrderNumber() {
        return this.m_iOrderNumber;
    }

    public String getName(Object info) {
        StringBuffer name = new StringBuffer();
        if (this.getCustomerId() != null) {
            name.append(this.m_Customer.toString());
            name.append(" - ");
        }
        if (info == null) {
            if (this.m_iTicketId == 0) {
                name.append("(" + m_dateformat.format(this.m_dDate) + " " + Long.toString(this.m_dDate.getTime() % 1000L) + ")");
            } else {
                name.append(Integer.toString(this.m_iTicketId));
            }
        } else {
            name.append(info.toString());
        }
        return name.toString();
    }

    public String getName() {
        return this.getName(null);
    }

    public String getKOTNumber() {
        return Long.toString(this.m_dDate.getTime() % 1000L);
    }

    public Date getDate() {
        return this.m_dDate;
    }

    public Date getTimer() {
        return this.m_dTimer;
    }

    public String printTimer() {
        return Formats.TIMESTAMP.formatValue(this.m_dTimer);
    }

    public long getElapsedMinutes() {
        long tStart = this.m_dTimer.getTime();
        long tEnd = System.currentTimeMillis();
        long tElapsed = tEnd - tStart;
        long tMinutes = TimeUnit.MILLISECONDS.toMinutes(tElapsed);
        return tMinutes;
    }

    public void setDate(Date dDate) {
        this.m_dDate = dDate;
    }

    public UserInfo getUser() {
        return this.m_User;
    }

    public void setUser(UserInfo value) {
        this.m_User = value;
    }

    public CustomerInfoExt getCustomer() {
        return this.m_Customer;
    }

    public void setCustomer(CustomerInfoExt value) {
        this.m_Customer = value;
    }

    public void setSupplier(SupplierInfoExt value) {
        this.m_Supplier = value;
    }

    public SupplierInfoExt getSupplier() {
        return this.m_Supplier;
    }

    public String getCustomerId() {
        if (this.m_Customer == null) {
            return null;
        }
        return this.m_Customer.getId();
    }

    public void setCustomerId(String custid) {
        if (this.m_Customer != null) {
            this.m_Customer.setId(custid);
        }
    }

    public String getSupplierId() {
        if (this.m_Supplier == null) {
            return null;
        }
        return this.m_Supplier.getId();
    }

    public String getTransactionID() {
        return this.getPayments().size() > 0 ? this.getPayments().get(this.getPayments().size() - 1).getTransactionID() : StringUtils.getCardNumber();
    }

    public String getReturnMessage() {
        return this.getPayments().get(this.getPayments().size() - 1) instanceof PaymentInfoMagcard ? ((PaymentInfoMagcard)this.getPayments().get(this.getPayments().size() - 1)).getReturnMessage() : LocalRes.getIntString("button.ok");
    }

    public void setActiveCash(String value) {
        this.m_sActiveCash = value;
    }

    public String getActiveCash() {
        return this.m_sActiveCash;
    }

    public String getProperty(String key) {
        return this.attributes.getProperty(key);
    }

    public String printProperty(String key) {
        return StringUtils.encodeXML(this.attributes.getProperty(key));
    }

    public String getProperty(String key, String defaultvalue) {
        return this.attributes.getProperty(key, defaultvalue);
    }

    public void setProperty(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public TicketLineInfo getLine(int index) {
        return this.m_aLines.get(index);
    }

    public void addLine(TicketLineInfo oLine) {
        oLine.setTicket(this.m_sId, this.m_aLines.size());
        this.m_aLines.add(oLine);
    }

    public void insertLine(int index, TicketLineInfo oLine) {
        this.m_aLines.add(index, oLine);
        this.refreshLines();
    }

    public void setLine(int index, TicketLineInfo oLine) {
        oLine.setTicket(this.m_sId, index);
        this.m_aLines.set(index, oLine);
    }

    public void removeLine(int index) {
        this.m_aLines.remove(index);
        this.refreshLines();
    }

    private void refreshLines() {
        for (int i = 0; i < this.m_aLines.size(); ++i) {
            this.getLine(i).setTicket(this.m_sId, i);
        }
    }

    public int getLinesCount() {
        return this.m_aLines.size();
    }

    public double getArticlesCount() {
        double dArticles = 0.0;
        for (TicketLineInfo oLine : this.m_aLines) {
            dArticles += oLine.getMultiply();
        }
        return dArticles;
    }

    public double getSubTotal() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getSubValue();
        }
        return sum;
    }

    public double getTotalDiscount() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getDiscount();
        }
        return sum;
    }

    public double getTax() {
        double sum = 0.0;
        for (TicketLineInfo line : this.m_aLines) {
            sum += line.getTax();
        }
        return sum;
    }

    public double getTotal() {
        return this.getSubTotal() + this.getTax();
    }

    public double getTotalPaid() {
        double sum = 0.0;
        for (PaymentInfo p : this.payments) {
            if ("debtpaid".equals(p.getName()) || "advancepaid".equals(p.getName())) continue;
            sum += p.getTotal();
        }
        return sum;
    }

    public List<TicketLineInfo> getLines() {
        return this.m_aLines;
    }

    public void setLines(List<TicketLineInfo> l) {
        this.m_aLines = l;
    }

    public List<PaymentInfo> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInfo> l) {
        this.payments = l;
    }

    public void resetPayments() {
        this.payments = new ArrayList<PaymentInfo>();
    }

    public List<TicketTaxInfo> getTaxes() {
        return this.taxes;
    }

    public boolean hasTaxesCalculated() {
        return this.taxes != null;
    }

    public void setTaxes(List<TicketTaxInfo> l) {
        this.taxes = l;
    }

    public void resetTaxes() {
        this.taxes = null;
    }

    public TicketTaxInfo getTaxLine(TaxInfo tax) {
        for (TicketTaxInfo taxline : this.taxes) {
            if (!tax.getId().equals(taxline.getTaxInfo().getId())) continue;
            return taxline;
        }
        return new TicketTaxInfo(tax);
    }

    public TicketTaxInfo[] getTaxLines() {
        HashMap<String, TicketTaxInfo> m = new HashMap<String, TicketTaxInfo>();
        for (TicketLineInfo oLine : this.m_aLines) {
            TicketTaxInfo t = (TicketTaxInfo)m.get(oLine.getTaxInfo().getId());
            if (t == null) {
                t = new TicketTaxInfo(oLine.getTaxInfo());
                m.put(t.getTaxInfo().getId(), t);
            }
            t.add(oLine.getSubValue());
        }
        Collection avalues = m.values();
        return avalues.toArray(new TicketTaxInfo[avalues.size()]);
    }

    public String printHost() {
        return StringUtils.encodeXML(this.m_sHost);
    }

    public void setHost(String value) {
        this.m_sHost = value;
    }

    public String printId() {
        if (this.m_iTicketId > 0) {
            return Integer.toString(this.m_iTicketId);
        }
        return "";
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.m_dDate);
    }

    public String printDateFormatted(String pattern) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            return simpleDateFormat.format(this.m_dDate);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String printUser() {
        return this.m_User == null ? "" : this.m_User.getName();
    }

    public String printCustomer() {
        return this.m_Customer == null ? "" : this.m_Customer.getName();
    }

    public String printSupplier() {
        return this.m_Supplier == null ? "" : this.m_Supplier.getName();
    }

    public String printArticlesCount() {
        return Formats.DOUBLE.formatValue(new Double(this.getArticlesCount()));
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubTotal()));
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(new Double(this.getTax()));
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotal()));
    }

    public String printTotalDiscount() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotalDiscount()));
    }

    public String printTotalPaid() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotalPaid()));
    }

    public double parseDouble(String val) {
        return Double.parseDouble(val);
    }

    public int parseInt(String val) {
        return Integer.parseInt(val);
    }

    public double roundDouble(double val, int decimals) {
        if (decimals > 0) {
            return (double)Math.round(val * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
        }
        return Math.round(val);
    }

    public String formatCurrency(Double val) {
        return Formats.CURRENCY.formatValue(val);
    }

    public void setGlobalValue(String val) {
        StringUtils.m_sGlobalVariable1 = val;
    }

    public String getGlobalValue() {
        return StringUtils.m_sGlobalVariable1;
    }

    public String TransliterateToArabic(String word) {
        return StringUtils.encodeXML(TransliterateArabic.convert(word));
    }

    public void sendSMS(String toMobile, String msg) {
        SMS myRunnable = new SMS(toMobile, msg);
        Thread t = new Thread(myRunnable);
        t.start();
    }

    public void sendKey(String[] keys) {
        try {
            int i;
            Robot robot = new Robot();
            Class<KeyEvent> cl = KeyEvent.class;
            int[] intKeys = new int[keys.length];
            for (i = 0; i < keys.length; ++i) {
                Field field = cl.getDeclaredField(keys[i]);
                intKeys[i] = field.getInt(field);
                robot.keyPress(intKeys[i]);
            }
            for (i = keys.length - 1; i >= 0; --i) {
                robot.keyRelease(intKeys[i]);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }
}

