/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.ticket;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataResultSet;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.data.loader.SerializableWrite;
import com.posics.data.loader.SerializerReadInteger;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.format.Formats;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppViewConnection;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;

public class TicketLineInfo
implements SerializableWrite,
SerializableRead,
Serializable {
    private static final long serialVersionUID = 6608012948284450199L;
    private String m_sTicket;
    private int m_iLine;
    private double multiply;
    private double price;
    private double pricebuy = 0.0;
    private double saleprice;
    private TaxInfo tax;
    private Properties attributes;
    private String productid;
    private String attsetinstid;
    private String m_Code;

    public TicketLineInfo(String productid, double dMultiply, double dPrice, TaxInfo tax, Properties props) {
        this.init(productid, null, dMultiply, dPrice, dPrice, tax, props);
    }

    public TicketLineInfo(String productid, double dMultiply, double dPrice, TaxInfo tax) {
        this.init(productid, null, dMultiply, dPrice, dPrice, tax, new Properties());
    }

    public TicketLineInfo(String productid, String productname, String producttaxcategory, double dMultiply, double dPrice, TaxInfo tax) {
        Properties props = new Properties();
        props.setProperty("product.name", productname);
        props.setProperty("product.price", Double.toString(dPrice));
        props.setProperty("product.taxcategoryid", producttaxcategory);
        this.init(productid, null, dMultiply, dPrice, dPrice, tax, props);
    }

    public TicketLineInfo(String productname, String producttaxcategory, double dMultiply, double dPrice, TaxInfo tax) {
        Properties props = new Properties();
        props.setProperty("product.name", productname);
        props.setProperty("product.price", Double.toString(dPrice));
        props.setProperty("product.taxcategoryid", producttaxcategory);
        this.init(null, null, dMultiply, dPrice, dPrice, tax, props);
    }

    public TicketLineInfo() {
        this.init(null, null, 0.0, 0.0, 0.0, null, new Properties());
    }

    public TicketLineInfo(ProductInfoExt product, double dMultiply, double dPrice, TaxInfo tax, Properties attributes) {
        String pid;
        if (product == null) {
            pid = null;
        } else {
            pid = product.getID();
            this.m_Code = product.m_sCode;
            this.pricebuy = product.getPriceBuy();
            attributes.setProperty("product.name", product.getName());
            attributes.setProperty("product.price", Double.toString(dPrice));
            attributes.setProperty("product.com", product.isCom() ? "true" : "false");
            if (product.getAttributeSetID() != null) {
                attributes.setProperty("product.attsetid", product.getAttributeSetID());
            }
            attributes.setProperty("product.taxcategoryid", product.getTaxCategoryID());
            if (product.getCategoryID() != null) {
                attributes.setProperty("product.categoryid", product.getCategoryID());
            }
        }
        this.init(pid, null, dMultiply, dPrice, dPrice, tax, attributes);
    }

    public TicketLineInfo(ProductInfoExt oProduct, double dPrice, TaxInfo tax, Properties attributes) {
        this(oProduct, 1.0, dPrice, tax, attributes);
    }

    public TicketLineInfo(TicketLineInfo line) {
        this.init(line.productid, line.attsetinstid, line.multiply, line.price, line.saleprice, line.tax, (Properties)line.attributes.clone());
    }

    private void init(String productid, String attsetinstid, double dMultiply, double dPrice, double dSalePrice, TaxInfo tax, Properties attributes) {
        this.productid = productid;
        this.attsetinstid = attsetinstid;
        this.multiply = dMultiply;
        this.price = dPrice;
        this.saleprice = dSalePrice;
        this.tax = tax;
        this.attributes = attributes;
        this.m_sTicket = null;
        this.m_iLine = -1;
    }

    void setTicket(String ticket, int line) {
        this.m_sTicket = ticket;
        this.m_iLine = line;
    }

    @Override
    public void writeValues(DataWrite dp) throws BasicException {
        dp.setString(1, this.m_sTicket);
        dp.setInt(2, new Integer(this.m_iLine));
        dp.setString(3, this.productid);
        dp.setString(4, this.attsetinstid);
        dp.setDouble(5, new Double(this.multiply));
        dp.setDouble(6, new Double(this.saleprice));
        dp.setString(7, this.tax.getId());
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            this.attributes.storeToXML((OutputStream)o, "Saleculator PDA", "UTF-8");
            dp.setBytes(8, o.toByteArray());
        }
        catch (IOException e) {
            dp.setBytes(8, null);
        }
    }

    @Override
    public void readValues(DataRead dr) throws BasicException {
        this.m_sTicket = dr.getString(1);
        this.m_iLine = dr.getInt(2);
        this.productid = dr.getString(3);
        this.attsetinstid = dr.getString(4);
        this.multiply = dr.getDouble(5);
        this.saleprice = dr.getDouble(6);
        this.tax = new TaxInfo(dr.getString(7), dr.getString(8), dr.getString(9), dr.getString(10), dr.getString(11), dr.getDouble(12), dr.getBoolean(13), dr.getInt(14));
        this.attributes = new Properties();
        try {
            byte[] img = dr.getBytes(15);
            if (img != null) {
                this.attributes.loadFromXML(new ByteArrayInputStream(img));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.price = this.attributes.containsKey("product.price") ? Double.parseDouble(this.attributes.getProperty("product.price")) : 0.0;
    }

    public TicketLineInfo copyTicketLine() {
        TicketLineInfo l = new TicketLineInfo();
        l.productid = this.productid;
        l.attsetinstid = this.attsetinstid;
        l.multiply = this.multiply;
        l.price = this.price;
        l.saleprice = this.saleprice;
        l.tax = this.tax;
        l.attributes = (Properties)this.attributes.clone();
        return l;
    }

    public int getTicketLine() {
        return this.m_iLine;
    }

    public String getProductID() {
        return this.productid;
    }

    public String getProductName() {
        return this.attributes.getProperty("product.name");
    }

    public String getProductAttSetId() {
        return this.attributes.getProperty("product.attsetid");
    }

    public String getProductAttSetInstDesc() {
        return this.attributes.getProperty("product.attsetdesc", "");
    }

    public void setProductAttSetInstDesc(String value) {
        if (value == null) {
            this.attributes.remove(value);
        } else {
            this.attributes.setProperty("product.attsetdesc", value);
        }
    }

    public String getProductAttSetInstId() {
        return this.attsetinstid;
    }

    public void setProductAttSetInstId(String value) {
        this.attsetinstid = value;
    }

    public boolean isProductCom() {
        return "true".equals(this.attributes.getProperty("product.com"));
    }

    public String getProductTaxCategoryID() {
        return this.attributes.getProperty("product.taxcategoryid");
    }

    public String getProductCategoryID() {
        return this.attributes.getProperty("product.categoryid");
    }

    public double getMultiply() {
        return this.multiply;
    }

    public void setMultiply(double dValue) {
        this.multiply = dValue;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double dValue) {
        this.price = dValue;
    }

    public void setSalePrice(double dValue) {
        this.saleprice = dValue;
    }

    public double getSalePrice() {
        return this.saleprice;
    }

    public double getPriceTax() {
        return this.saleprice * (1.0 + this.getTaxRate());
    }

    public void setPriceTax(double dValue) {
        this.saleprice = dValue / (1.0 + this.getTaxRate());
    }

    public TaxInfo getTaxInfo() {
        return this.tax;
    }

    public void setTaxInfo(TaxInfo value) {
        this.tax = value;
    }

    public String getProperty(String key) {
        return this.attributes.getProperty(key);
    }

    public String getProperty(String key, String defaultvalue) {
        return this.attributes.getProperty(key, defaultvalue);
    }

    public void setProperty(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.attributes;
    }

    public double getTaxRate() {
        return this.tax == null ? 0.0 : this.tax.getRate();
    }

    public double getDiscount() {
        if (this.saleprice < this.price) {
            return (this.price - this.saleprice) * this.multiply;
        }
        return 0.0;
    }

    public double getSubValueWithoutDiscount() {
        return this.price * this.multiply;
    }

    public double getSubValue() {
        return this.saleprice * this.multiply;
    }

    public double getTax() {
        return this.saleprice * this.multiply * this.getTaxRate();
    }

    public double getValue() {
        return this.saleprice * this.multiply * (1.0 + this.getTaxRate());
    }

    public String printName() {
        return StringUtils.encodeXML(this.attributes.getProperty("product.name"));
    }

    public String getName() {
        return this.attributes.getProperty("product.name");
    }

    public String printCode() {
        return StringUtils.encodeXML(this.m_Code);
    }

    public String printMultiply() {
        return Formats.DOUBLE.formatValue(this.multiply);
    }

    public String printPrice() {
        return Formats.CURRENCY.formatValue(this.getPrice());
    }

    public String printSalePrice() {
        return Formats.CURRENCY.formatValue(this.getSalePrice());
    }

    public String printPriceTax() {
        return Formats.CURRENCY.formatValue(this.getPriceTax());
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(this.getTax());
    }

    public String printTaxRate() {
        return Formats.PERCENT.formatValue(this.getTaxRate());
    }

    public String printSubValue() {
        return Formats.CURRENCY.formatValue(this.getSubValue());
    }

    public String printValue() {
        return Formats.CURRENCY.formatValue(this.getValue());
    }

    public double getPriceBuy() {
        return this.pricebuy;
    }

    public double getStock() {
        try {
            AppConfig config = new AppConfig(new String[0]);
            config.load();
            Session session = AppViewConnection.createSession(config);
            StaticSentence bsentence = new StaticSentence(session, "SELECT UNITS FROM STOCKCURRENT WHERE LOCATION='0' AND PRODUCT = '" + this.productid + "'", null, SerializerReadInteger.INSTANCE);
            DataResultSet ds = bsentence.openExec(this);
            int rcount = 0;
            if (ds != null) {
                ds.next();
                rcount = Integer.parseInt(ds.getCurrent().toString());
            }
            session.close();
            return rcount;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String printPriceBuy() {
        return Formats.CURRENCY.formatValue(this.getPriceBuy());
    }
}

