/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.update;

import com.posics.pos.update.Updater;
import com.posics.pos.util.ActivationCheck;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FlashUpdate
extends JFrame {
    private Thread worker;
    private final String root1 = System.getProperty("user.home");
    private final String root2 = System.getProperty("user.home") + File.separator + "update";
    private JTextArea outText;
    private JButton cancle;
    private JButton launch;
    private JScrollPane sp;
    private JPanel pan1;
    private JPanel pan2;

    public FlashUpdate() {
        this.initComponents();
        this.outText.setText("Contacting Download Server...");
        this.download();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Saleculator PDA Update");
        this.pan1 = new JPanel();
        this.pan1.setLayout(new BorderLayout());
        this.pan2 = new JPanel();
        this.pan2.setLayout(new FlowLayout());
        this.outText = new JTextArea();
        this.outText.setEditable(false);
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.outText);
        this.launch = new JButton("Launch App");
        this.launch.setEnabled(false);
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashUpdate.this.launch();
            }
        });
        this.pan2.add(this.launch);
        this.cancle = new JButton("Cancel Update");
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashUpdate.this.launch();
            }
        });
        this.pan2.add(this.cancle);
        this.pan1.add((Component)this.sp, "Center");
        this.pan1.add((Component)this.pan2, "South");
        this.add(this.pan1);
        this.pack();
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
    }

    private void download() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] run;
                    String downloadlink = FlashUpdate.this.getDownloadLinkFromHost();
                    if (downloadlink == null) {
                        FlashUpdate.this.outText.setText(FlashUpdate.this.outText.getText() + "\nUpdate error!");
                        FlashUpdate.this.launch.setEnabled(true);
                        return;
                    }
                    FlashUpdate.this.downloadFile(FlashUpdate.this.getDownloadLinkFromHost());
                    FlashUpdate.this.unzip();
                    FlashUpdate.this.copyFiles(new File(FlashUpdate.this.root2), new File("").getAbsolutePath());
                    File updatefile = new File(FlashUpdate.this.root2 + File.separator + "update.jar");
                    if (updatefile.exists()) {
                        run = new String[]{"java", "-jar", updatefile.getAbsolutePath()};
                        try {
                            Runtime.getRuntime().exec(run);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((updatefile = new File(FlashUpdate.this.root2 + File.separator + "update.sh")).exists()) {
                        run = new String[]{"sh", updatefile.getAbsolutePath()};
                        try {
                            Runtime.getRuntime().exec(run);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    FlashUpdate.this.cleanup();
                    FlashUpdate.this.launch.setEnabled(true);
                    FlashUpdate.this.outText.setText(FlashUpdate.this.outText.getText() + "\nUpdate Finished!");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "An error occured while preforming update!");
                }
            }
        });
        this.worker.start();
    }

    private void launch() {
        String[] run = new String[]{"java", "-jar", "SaleculatorPDA.jar"};
        try {
            Runtime.getRuntime().exec(run);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private void cleanup() {
        this.outText.setText(this.outText.getText() + "\nPreforming clean up...");
        try {
            File f = new File(this.root1 + File.separator + "update.zip");
            if (f.exists()) {
                f.delete();
            }
            this.remove(new File(this.root2));
            new File(this.root2).delete();
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }

    private void remove(File f) {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                this.remove(ff);
                ff.delete();
                continue;
            }
            ff.delete();
        }
    }

    private void copyFiles(File f, String dir) throws IOException {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                new File(dir + File.separator + ff.getName()).mkdir();
                this.copyFiles(ff, dir + File.separator + ff.getName());
                continue;
            }
            this.copy(ff.getAbsolutePath(), dir + File.separator + ff.getName());
        }
    }

    public void copy(String srFile, String dtFile) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void unzip() throws IOException {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile(this.root1 + File.separator + "update.zip");
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        new File(this.root2).mkdir();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            this.outText.setText(this.outText.getText() + "\nExtracting: " + entry);
            if (entry.isDirectory()) {
                new File(this.root2 + File.separator + entry.getName()).mkdir();
                continue;
            }
            new File(this.root2 + File.separator + entry.getName()).createNewFile();
            is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(this.root2 + File.separator + entry.getName());
            dest = new BufferedOutputStream(fos, BUFFER);
            while ((count = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
        }
        zipfile.close();
    }

    private void downloadFile(String link) throws MalformedURLException, IOException {
        URL url = new URL(link);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        long max = conn.getContentLength();
        this.outText.setText(this.outText.getText() + "\nUpdate Size: " + FlashUpdate.readableFileSize(max) + ". \nDownloading file...");
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(new File(this.root1 + File.separator + "update.zip")));
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        int in = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            in += bytesRead;
            fOut.write(buffer, 0, bytesRead);
        }
        fOut.flush();
        fOut.close();
        is.close();
        this.outText.setText(this.outText.getText() + "\nDownload Complete.");
    }

    private String getDownloadLinkFromHost() throws MalformedURLException, IOException {
        String path = "http://saleculator.com/sumup/update/geturl";
        List<String> macs = ActivationCheck.getAllMacs();
        String mac = "";
        if (macs.size() > 0) {
            mac = macs.get(0);
        }
        String urlParameters = "/" + mac + "/" + FlashUpdate.getSerialKey();
        URL url = new URL(path + urlParameters);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        System.err.println(buffer);
        if (buffer.substring(buffer.indexOf("[STATUS]") + 8, buffer.indexOf("[/STATUS]")).equals("1")) {
            return buffer.substring(buffer.indexOf("[URL]") + 5, buffer.indexOf("[/URL]"));
        }
        return null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Updater().setVisible(true);
            }
        });
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String getSerialKey() {
        try {
            File f = new File(System.getProperty("user.home"), "license.sig");
            if (f.exists()) {
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                String s1 = br.readLine();
                if (s1 != null) {
                    String s2 = br.readLine();
                    if (s2 != null) {
                        return s2;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

