/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.util.ActivationCheck;
import com.posics.pos.util.ClockObservable;
import com.posics.pos.util.ConnectionObservable;
import com.posics.pos.util.InternetConnectionState;
import com.posics.pos.util.NetworkPrinterConnectionObservable;
import com.posics.pos.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

public class Activate
extends JFrame {
    private JTextArea outText;
    private JTextField keyText;
    private JButton btnNetwork;
    private JButton btnCancel;
    private JButton btnActivate;
    private JScrollPane sp;
    private String SERIAL;
    public boolean ACTSTATUS = false;
    private Timer m_jtimer;
    ConnectionObservable observableConnection = new ConnectionObservable();
    NetworkPrinterConnectionObservable observableConnectionNetworkPrinter;
    ClockObservable observableClock;
    InternetConnectionObserver internetConnectionObserver = new InternetConnectionObserver(this.observableConnection);
    private static final String ACTIVATE_URL = "https://www.saleculator.com/update/activateurl.html";

    public Activate() {
        this.m_jtimer = new Timer(30000, new TimerAction());
        this.m_jtimer.start();
    }

    public void activatesaleculator() {
        JDialog d6 = new JDialog((Window)this, "", Dialog.ModalityType.DOCUMENT_MODAL);
        d6.setTitle("System Activation");
        this.outText = new JTextArea();
        this.outText.setEditable(false);
        Font font = this.outText.getFont();
        float size = (float)font.getSize() + 1.0f;
        this.outText.setFont(font.deriveFont(size));
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.outText);
        this.btnActivate = new JButton();
        this.btnActivate.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Activate.this.btnActivate.setEnabled(false);
                ActivateNow myRunnable = new ActivateNow();
                Thread t = new Thread(myRunnable);
                t.start();
            }
        });
        this.btnCancel = new JButton("");
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Activate.this.dispose();
            }
        });
        this.btnNetwork = new JButton("");
        this.btnNetwork.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/offline.png")));
        this.btnNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Activate.this.networkSettings();
            }
        });
        this.keyText = new JTextField("");
        this.keyText.setFont(font.deriveFont(size + 1.0f));
        this.keyText.setColumns(20);
        this.keyText.setText("");
        this.outText.setText("This Saleculator is not activated.");
        this.outText.setText(this.outText.getText() + "\nMake sure Saleculator is connected to internet before proceding.\n\nPlease enter device Serial Number in the below text box and press Activate.");
        this.outText.setEditable(false);
        this.btnActivate.setHorizontalAlignment(4);
        this.btnCancel.setHorizontalAlignment(4);
        Container cp6 = d6.getContentPane();
        cp6.setLayout(new BorderLayout());
        cp6.add((Component)new JScrollPane(this.outText), "Center");
        JPanel p6 = new JPanel();
        JPanel p7 = new JPanel();
        JPanel p8 = new JPanel();
        p7.setFocusable(false);
        p8.setFocusable(false);
        this.btnNetwork.setFocusable(false);
        p8.setPreferredSize(new Dimension(20, 10));
        p7.add(p8);
        p7.add(this.btnNetwork);
        p6.setLayout(new FlowLayout(0));
        p7.setLayout(new FlowLayout(2));
        p6.add(this.keyText);
        p6.add(this.btnActivate);
        p6.add(this.btnCancel);
        p6.add(p7);
        cp6.add((Component)p6, "South");
        this.outText.setFocusable(false);
        this.keyText.requestFocusInWindow();
        d6.pack();
        d6.setSize(500, 400);
        d6.setModal(true);
        d6.setLocationRelativeTo(null);
        d6.setVisible(true);
    }

    private void isOnline() {
        if (this.observableConnection.isInternetConnectionAvailable()) {
            this.btnNetwork.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/online.png")));
        } else {
            this.btnNetwork.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/offline.png")));
        }
        this.btnNetwork.repaint();
    }

    private String getactivatelink() throws MalformedURLException, IOException {
        URL url = new URL(ACTIVATE_URL);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        return buffer.substring(buffer.indexOf("[url]") + 5, buffer.indexOf("[/url]"));
    }

    public void networkSettings() {
        try {
            AppConfig config = new AppConfig(new String[0]);
            config.load();
            String strScript = config.getProperty("Network.Manager");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(strScript);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Network manager failed:" + e.toString(), "Saleculator", 0);
        }
    }

    public class InternetConnectionObserver
    implements Observer {
        public InternetConnectionObserver(ConnectionObservable internetConnection) {
            internetConnection.addObserver(this);
            new Thread(internetConnection).start();
        }

        @Override
        public void update(Observable internetConnection, Object state) {
            InternetConnectionState connectionState = (InternetConnectionState)state;
            StringUtils.m_blIsOnline = connectionState.getState();
            Activate.this.isOnline();
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Activate.this.m_jtimer.stop();
                Activate.this.isOnline();
                Activate.this.m_jtimer.start();
            }
            catch (Exception e) {
                Activate.this.m_jtimer.restart();
            }
        }
    }

    public class ActivateNow
    implements Runnable {
        @Override
        public void run() {
            try {
                Activate.this.SERIAL = Activate.this.keyText.getText().trim();
                if (Activate.this.SERIAL.length() > 0) {
                    if (Activate.this.SERIAL.equalsIgnoreCase("demo")) {
                        StringUtils.m_blIsDemo = true;
                        if (JOptionPane.showConfirmDialog(null, "Entering in demo mode will delete all data. Are you sure to continue?", AppLocal.getIntString("message.title"), 0, 3) == 0) {
                            Activate.this.ACTSTATUS = true;
                            Activate.this.dispose();
                        }
                    } else {
                        String inputLine;
                        StringUtils.m_blIsDemo = false;
                        Activate.this.outText.setText(Activate.this.outText.getText() + "\nContacting Saleculator Activation server.\nPlease wait...");
                        String activateUrl = Activate.this.getactivatelink();
                        List<String> macs = ActivationCheck.getAllMacs();
                        String m_sMAC = "NOID";
                        if (macs.size() > 0) {
                            m_sMAC = macs.get(0);
                        }
                        String urlParameters = "/" + m_sMAC + "/" + Activate.this.SERIAL + "/" + "1.0" + "/2";
                        URL url = new URL(activateUrl + urlParameters);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        StringBuilder buffer = new StringBuilder("");
                        while ((inputLine = in.readLine()) != null) {
                            buffer.append(inputLine);
                        }
                        in.close();
                        connection.disconnect();
                        String msg = buffer.toString();
                        Activate.this.outText.setText(Activate.this.outText.getText() + "\n" + msg.substring(msg.indexOf("[MESSAGE]") + 9, msg.indexOf("[/MESSAGE]")));
                        String status = msg.substring(msg.indexOf("[STATUS]") + 8, msg.indexOf("[/STATUS]"));
                        if (Integer.parseInt(status) != 0) {
                            Activate.this.outText.setText(Activate.this.outText.getText() + "\nGenerating signature file.\nPlease wait...");
                            String code = m_sMAC + '*' + Activate.this.SERIAL + '2';
                            String hashcode = Integer.toString(code.hashCode());
                            File fs = new File(System.getProperty("user.home"), "license.sig");
                            FileOutputStream out = new FileOutputStream(fs);
                            ((OutputStream)out).write(hashcode.getBytes());
                            ((OutputStream)out).write(System.getProperty("line.separator").getBytes());
                            ((OutputStream)out).write(Activate.this.SERIAL.getBytes());
                            ((OutputStream)out).close();
                            out = new FileOutputStream(fs, true);
                            String filehash = "*" + Integer.toString(ActivationCheck.getFileDate(fs.toPath()).hashCode()) + "*";
                            ((OutputStream)out).write(System.getProperty("line.separator").getBytes());
                            ((OutputStream)out).write(filehash.getBytes());
                            ((OutputStream)out).close();
                            Activate.this.ACTSTATUS = true;
                            Activate.this.dispose();
                        }
                    }
                }
            }
            catch (UnknownHostException ex) {
                System.out.println(ex.getMessage());
                Activate.this.outText.setText("Internet not available. Please check your connection and try again.");
                Activate.this.ACTSTATUS = false;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                Activate.this.outText.setText(Activate.this.outText.getText() + "\n" + ex.getMessage());
                Activate.this.ACTSTATUS = false;
            }
            Activate.this.btnActivate.setEnabled(true);
        }
    }
}

