/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.util.Activate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class ActivationCheck {
    public static boolean doCheck() {
        return ActivationCheck.readLicenseFile();
    }

    private static boolean readLicenseFile() {
        try {
            File f = new File(System.getProperty("user.home"), "license.sig");
            if (f.exists()) {
                String s3;
                String s2;
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                String filehash = "*" + Integer.toString(ActivationCheck.getFileDate(f.toPath()).hashCode()) + "*";
                String s1 = br.readLine();
                if (s1 != null && (s2 = br.readLine()) != null && (s3 = br.readLine()) != null) {
                    List<String> macs = ActivationCheck.getAllMacs();
                    String mac = "";
                    if (macs.size() > 0) {
                        mac = macs.get(0);
                    }
                    if (mac != "") {
                        String code = mac + '*' + s2 + '2';
                        String hashcode = Integer.toString(code.hashCode());
                        if (s1.equals(hashcode) && filehash.equals(s3)) {
                            return true;
                        }
                        return ActivationCheck.activatenow();
                    }
                    return true;
                }
                fr.close();
                return true;
            }
            return ActivationCheck.activatenow();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return false;
        }
    }

    private static boolean activatenow() {
        Activate act = new Activate();
        act.activatesaleculator();
        return act.ACTSTATUS;
    }

    public static List<String> getAllMacs() {
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                StringBuilder macAddress = new StringBuilder();
                byte[] mac = netint.getHardwareAddress();
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "" : ""));
                }
                if (netint.getDisplayName().contains("Bluetooth") || netint.getDisplayName().contains("Virtual") || macAddress.toString().trim().length() <= 8 || macAddress.toString().equals("00000000000000E0") || macs.contains(macAddress.toString())) continue;
                macs.add(macAddress.toString());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (macs.isEmpty()) {
            try {
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.contains("nix") || OS.contains("nux") || OS.contains("aix")) {
                    BufferedReader stdInput;
                    ArrayList<String> command = new ArrayList<String>();
                    command.add("bash");
                    command.add("-c");
                    command.add("cat /sys/class/net/eth0/address");
                    ProcessBuilder builder = new ProcessBuilder(command);
                    Process proc = builder.start();
                    proc.waitFor();
                    String s = null;
                    if (proc.exitValue() == 0) {
                        stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((s = stdInput.readLine()) != null) {
                            s = s.replace(":", "").toUpperCase();
                            macs.add(s);
                        }
                    }
                    command = new ArrayList();
                    command.add("bash");
                    command.add("-c");
                    command.add("cat /sys/class/net/wlan0/address");
                    builder = new ProcessBuilder(command);
                    proc = builder.start();
                    proc.waitFor();
                    s = null;
                    if (proc.exitValue() == 0) {
                        stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((s = stdInput.readLine()) != null) {
                            s = s.replace(":", "").toUpperCase();
                            macs.add(s);
                        }
                    }
                    command = new ArrayList();
                    command.add("bash");
                    command.add("-c");
                    command.add("cat /sys/class/net/wlan1/address");
                    builder = new ProcessBuilder(command);
                    proc = builder.start();
                    proc.waitFor();
                    s = null;
                    if (proc.exitValue() == 0) {
                        stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((s = stdInput.readLine()) != null) {
                            s = s.replace(":", "").toUpperCase();
                            macs.add(s);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return macs;
    }

    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
            StringBuffer macAddress = new StringBuffer();
            while (ni.hasMoreElements()) {
                NetworkInterface nextElement = ni.nextElement();
                byte[] mac = nextElement.getHardwareAddress();
                if (mac == null) continue;
                macAddress = new StringBuffer();
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "" : ""));
                }
                if (macAddress.toString().trim().length() <= 8 || macAddress.toString().equals("00000000000000E0")) continue;
                return macAddress.toString();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getSerialKey() {
        try {
            File f = new File(System.getProperty("user.home"), "license.sig");
            if (f.exists()) {
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                String s1 = br.readLine();
                if (s1 != null) {
                    String s2 = br.readLine();
                    if (s2 != null) {
                        return s2;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FileTime getFileDate(Path path) {
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return attr.creationTime();
        }
        catch (Exception e) {
            return null;
        }
    }
}

