/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.basic.BasicException;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.update.UpdateInfo;
import com.posics.pos.util.FlashDrive;
import com.posics.pos.util.StringUtils;
import com.posics.pos.util.Updater;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Backup {
    public static void restartApplication(Component parent) {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-jar");
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.contains("nix") || OS.contains("nux") || OS.contains("aix")) {
                command.add("/opt/Saleculator/SaleculatorPDA.jar");
            } else {
                String jarPath = new File(".").getAbsolutePath();
                jarPath = jarPath.replace(".", "");
                command.add(jarPath + "SaleculatorPDA.jar");
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            builder.start();
            System.exit(0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parent, "Saleculator failed to restart:" + e.toString(), "Restart", 0);
        }
    }

    public static void updateSoftware(Component parent) throws BasicException {
        try {
            int n = JOptionPane.showConfirmDialog(null, AppLocal.getIntString("message.updatesaleculator"), "Saleculator Update", 1);
            if (n == 1) {
                if (FlashDrive.MountFlashDrive()) {
                    JFileChooser targetFile = new JFileChooser();
                    targetFile.setDialogTitle("Update From");
                    targetFile.setApproveButtonText("Update");
                    targetFile.setToolTipText("Selecting required folder");
                    AppConfig config = new AppConfig(new String[0]);
                    config.load();
                    String usbLocation = config.getProperty("Usb.Location");
                    targetFile.setCurrentDirectory(new File(usbLocation));
                    targetFile.setSelectedFile(new File("update.zip"));
                    int result = targetFile.showOpenDialog(null);
                    if (result == 0) {
                        String path = targetFile.getSelectedFile().getAbsolutePath();
                        try {
                            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                            ArrayList<String> command = new ArrayList<String>();
                            command.add(javaBin);
                            command.add("-jar");
                            command.add("/opt/Saleculator/Updater.jar");
                            command.add(path);
                            ProcessBuilder builder = new ProcessBuilder(command);
                            builder.start();
                            System.exit(0);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            } else if (n == 0) {
                if (!Updater.getLatestVersion().equals("v1.0u20")) {
                    UpdateInfo upi = new UpdateInfo();
                    upi.showhistory("v1.0u20", Updater.getLatestVersion());
                } else {
                    JOptionPane.showMessageDialog(null, "This Saleculator is up to date.", "Saleculator Update", 1);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Backup Failed:" + e.toString(), "Saleculator Backup", 0);
        }
    }

    public static void turnoff(Component parent) {
        String turnoffScript = StringUtils.config.getProperty("Script.TurnOff");
        String OS = System.getProperty("os.name").toLowerCase();
        if (turnoffScript.equals("") || !OS.contains("nix") && !OS.contains("nux") && !OS.contains("aix")) {
            System.exit(0);
        } else {
            Runtime runtime = Runtime.getRuntime();
            try {
                Process proc = runtime.exec(turnoffScript);
                System.exit(0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(parent, "System shutdown failed:" + e.toString() + " - Please press Power Switch to Turn Off.", "Turn Off", 0);
                System.exit(0);
            }
        }
    }

    public static String getDBName(String dburl) {
        int dbStartPos = dburl.lastIndexOf(47);
        int dbEndPos = dburl.lastIndexOf(63);
        if (dbEndPos >= 0) {
            return dburl.substring(dbStartPos + 1, dbEndPos);
        }
        return dburl.substring(dbStartPos + 1);
    }
}

