/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.util.Battery;
import com.posics.pos.util.BatteryState;
import java.util.Observable;

public class BatteryObservable
extends Observable
implements Runnable {
    private static final long CHECK_INTERVAL = 60000L;
    private BatteryState batstate;

    @Override
    public void run() {
        this.batstate = Battery.getStatus();
        if (this.batstate.getStatus() != null) {
            this.updateBatteryStatus();
        }
    }

    public void updateBatteryStatus() {
        while (true) {
            this.checkBattery();
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    private void checkBattery() {
        BatteryState newState = Battery.getStatus();
        if (newState.getStatus() != null && !newState.getStatus().equals(this.batstate.getStatus())) {
            this.batstate = newState;
            this.setChanged();
            this.notifyObservers(this.batstate);
        }
    }
}

