/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.util.Clock;
import com.posics.pos.util.ClockState;
import com.posics.pos.util.InternetConnection;
import com.posics.pos.util.InternetConnectionState;
import com.posics.pos.util.NetworkPrinterConnection;
import com.posics.pos.util.NetworkPrinterConnectionState;
import com.posics.pos.util.StringUtils;
import java.util.Observable;

public class ConnectionObservable
extends Observable
implements Runnable {
    private static final long CHECK_INTERVAL = 20000L;
    private InternetConnectionState internetstate;
    private NetworkPrinterConnectionState networkprinterstate;
    private ClockState clockstate;

    @Override
    public void run() {
        this.internetstate = InternetConnection.isAvailable();
        this.updateConnectionStatus();
    }

    public void updateConnectionStatus() {
        while (true) {
            this.checkInternetConnection();
            try {
                Thread.sleep(20000L);
                continue;
            }
            catch (InterruptedException e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    private void checkInternetConnection() {
        InternetConnectionState intState = InternetConnection.isAvailable();
        if (intState.getState() != this.internetstate.getState() || intState.getState() != StringUtils.m_blIsOnline) {
            this.internetstate = intState;
            StringUtils.m_blIsOnline = intState.getState();
            this.setChanged();
            this.notifyObservers(this.internetstate);
        }
    }

    public boolean isInternetConnectionAvailable() {
        if (this.internetstate != null) {
            return this.internetstate.getState();
        }
        return false;
    }

    private void checkNetworkPrinterConnection() {
        NetworkPrinterConnectionState newState = NetworkPrinterConnection.isAvailable();
        if (newState.getState() != this.networkprinterstate.getState() || newState.getState() != StringUtils.m_blIsNetworkPrinterOnline) {
            this.networkprinterstate = newState;
            StringUtils.m_blIsNetworkPrinterOnline = newState.getState();
            this.setChanged();
            this.notifyObservers(this.networkprinterstate);
        }
    }

    public boolean isNetworkPrinterConnectionAvailable() {
        if (this.networkprinterstate != null) {
            return this.networkprinterstate.getState();
        }
        return false;
    }

    private void checkClockConnection() {
        ClockState newState = Clock.getTime();
        if (!newState.getState().equals(this.clockstate.getState())) {
            this.clockstate = newState;
            this.setChanged();
            this.notifyObservers(this.clockstate);
        }
    }
}

