/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.basic.BasicException;
import com.posics.pos.forms.AppLocal;

public class ExtensionUtil {
    public static final String _SEPRATOR = "###";

    public static String formatPaymentNotes(String rmksStr) throws BasicException {
        String[] val = rmksStr.split(_SEPRATOR);
        String formattedRemarks = AppLocal.getIntString("transpayment." + val[0]);
        if (val.length > 1) {
            formattedRemarks = formattedRemarks + val[1];
        }
        return formattedRemarks;
    }

    public static String[] splitToMultiline(String p_data, int charPerLine) throws BasicException {
        return ExtensionUtil.splitToMultiline(p_data, charPerLine, null, 0);
    }

    public static String[] splitToMultiline(String[] params) throws BasicException {
        return ExtensionUtil.splitToMultiline(params[0], Integer.parseInt(params[1]));
    }

    public static String[] splitToMultiline(String data, String charLmt) throws BasicException {
        return ExtensionUtil.splitToMultiline(data, Integer.parseInt(charLmt));
    }

    public static String[] splitToMultiline(String p_data, int charPerLine, String p_val, int valFixedLength) throws BasicException {
        String[] dataLines = null;
        int dataLength = p_data.length();
        int noOfLines = dataLength / charPerLine;
        if ((noOfLines += dataLength % charPerLine != 0 ? 1 : 0) == 1) {
            dataLines = new String[]{p_data};
        } else {
            dataLines = new String[noOfLines];
            int start = 0;
            for (int line = 0; line < noOfLines; ++line) {
                dataLines[line] = p_data.substring(start, Math.min(start + charPerLine, dataLength));
                start += charPerLine;
            }
        }
        if (p_val != null && dataLines != null && dataLines.length > 0) {
            dataLines[dataLines.length - 1] = ExtensionUtil.padSpace(dataLines[dataLines.length - 1], charPerLine, 'r') + ExtensionUtil.padSpace(p_val, valFixedLength, 'l');
        }
        return dataLines;
    }

    private static String padSpace(String data, int fixedLength, char pos) {
        if (data != null && data.length() < fixedLength) {
            switch (pos) {
                case 'l': {
                    data = "                                                                               ".substring(0, fixedLength - data.length()) + data;
                    break;
                }
                case 'r': {
                    data = data + "                                                                               ".substring(0, fixedLength - data.length());
                }
            }
        }
        return data;
    }
}

