/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.util.NetworkPrinterConnection;
import com.posics.pos.util.NetworkPrinterConnectionState;
import com.posics.pos.util.StringUtils;
import java.util.Observable;

public class NetworkPrinterConnectionObservable
extends Observable
implements Runnable {
    private static final long CHECK_INTERVAL = 20000L;
    private NetworkPrinterConnectionState networkprinterstate;

    @Override
    public void run() {
        this.networkprinterstate = NetworkPrinterConnection.isAvailable();
        this.updateConnectionStatus();
    }

    public void updateConnectionStatus() {
        while (true) {
            this.checkNetworkPrinterConnection();
            try {
                Thread.sleep(20000L);
                continue;
            }
            catch (InterruptedException e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    private void checkNetworkPrinterConnection() {
        NetworkPrinterConnectionState newState = NetworkPrinterConnection.isAvailable();
        if (newState.getState() != this.networkprinterstate.getState() || newState.getState() != StringUtils.m_blIsNetworkPrinterOnline) {
            this.networkprinterstate = newState;
            StringUtils.m_blIsNetworkPrinterOnline = newState.getState();
            this.setChanged();
            this.notifyObservers(this.networkprinterstate);
        }
    }

    public boolean isNetworkPrinterConnectionAvailable() {
        if (this.networkprinterstate != null) {
            return this.networkprinterstate.getState();
        }
        return false;
    }
}

