/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.basic.BasicException;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.util.AltEncrypter;
import com.posics.pos.util.WaitDialog;
import java.net.InetAddress;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Online
extends Thread {
    private Properties props;
    private String sMailHost;
    private String sMailPort;
    private String sMailEmail;
    private String sMailEmailTo;
    private String sMailPassword;
    private String sMailTLS;
    private String sMailAuth;
    private String sWebAddress;

    public Online() {
        this.loadConfig();
    }

    public boolean isOnline_Old() {
        try {
            if (this.sWebAddress != null && !this.sWebAddress.equals("")) {
                InetAddress address = InetAddress.getByName(this.sWebAddress);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isConfigured() {
        return this.sMailEmail != null && this.sMailPassword != null && this.sMailEmailTo != null && !this.sMailEmail.equals("") && !this.sMailPassword.equals("") && !this.sMailEmailTo.equals("");
    }

    public String TestAccount(String host, String tls, String port, String auth, String email, String password) {
        try {
            WaitDialog.showDialog("Testing account...");
            Properties tmp = new Properties();
            tmp.setProperty("mail.smtp.host", host);
            tmp.setProperty("mail.smtp.starttls.enable", tls);
            tmp.setProperty("mail.smtp.port", port);
            tmp.setProperty("mail.smtp.auth", auth);
            tmp.setProperty("mail.smtp.user", email);
            Session session = Session.getDefaultInstance((Properties)tmp);
            Transport t = session.getTransport("smtp");
            t.connect(host, email, password);
            WaitDialog.hideDialog();
            return "Success";
        }
        catch (Exception e) {
            WaitDialog.hideDialog();
            return e.getMessage();
        }
    }

    public String SendMail(String subject, String mailBody, Boolean isHtml) throws BasicException {
        try {
            if (this.isConfigured()) {
                WaitDialog.showDialog("Sending email...");
                Session session = Session.getDefaultInstance((Properties)this.props);
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(this.sMailEmail));
                InternetAddress[] toAddress = InternetAddress.parse((String)this.sMailEmailTo);
                message.addRecipients(Message.RecipientType.TO, (Address[])toAddress);
                message.setSubject(subject);
                if (isHtml.booleanValue()) {
                    message.setContent((Object)mailBody, "text/html");
                } else {
                    message.setText(mailBody);
                }
                Transport t = session.getTransport("smtp");
                t.connect(this.sMailHost, this.sMailEmail, this.sMailPassword);
                t.sendMessage((Message)message, message.getAllRecipients());
                t.close();
                WaitDialog.hideDialog();
            }
            return "Success";
        }
        catch (Exception e) {
            WaitDialog.hideDialog();
            return e.getMessage();
        }
    }

    public String SendMailwithAttachment(String subject, String filename) {
        try {
            WaitDialog.showDialog("Sending email...");
            if (this.isConfigured()) {
                Session session = Session.getDefaultInstance((Properties)this.props);
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(this.sMailEmail));
                InternetAddress[] toAddress = InternetAddress.parse((String)this.sMailEmailTo);
                message.addRecipients(Message.RecipientType.TO, (Address[])toAddress);
                message.setSubject(subject);
                MimeBodyPart mbp1 = new MimeBodyPart();
                String mailBody = "Dear Customer,\r\n\r\nWe are happy to offer you the facility of receiving statements on E-mail. Now, you can access your statement on your computer from anywhere in the world. This is something you cannot do with your printed statements.\r\n\r\nTo open the attached file, all you need is a software capable to read the file.\r\n\r\nThank you,\r\nSaleculator Online Services";
                mbp1.setText(mailBody);
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(filename);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(fds.getName());
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                message.setContent((Multipart)mp);
                Transport t = session.getTransport("smtp");
                t.connect(this.sMailHost, this.sMailEmail, this.sMailPassword);
                t.sendMessage((Message)message, message.getAllRecipients());
                t.close();
            }
            WaitDialog.hideDialog();
            return "Success";
        }
        catch (Exception e) {
            WaitDialog.hideDialog();
            return e.getMessage();
        }
    }

    public String SendMailwithStringAsAttachment(String subject, String attachment, String filename) {
        try {
            WaitDialog.showDialog("Sending email...");
            if (this.isConfigured()) {
                Session session = Session.getDefaultInstance((Properties)this.props);
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(this.sMailEmail));
                InternetAddress[] toAddress = InternetAddress.parse((String)this.sMailEmailTo);
                message.addRecipients(Message.RecipientType.TO, (Address[])toAddress);
                message.setSubject(subject);
                MimeBodyPart mbp1 = new MimeBodyPart();
                String mailBody = "Dear Customer,\r\n\r\nWe are happy to offer you the facility of receiving statements on E-mail. Now, you can access your statement on your computer from anywhere in the world. This is something you cannot do with your printed statements.\r\n\r\nYou can view the attached file in the browser itself or download the file to open it using any text editor.\r\n\r\nThank you,\r\nSaleculator Online Services";
                mbp1.setText(mailBody);
                MimeBodyPart mbp2 = new MimeBodyPart();
                mbp2.setText(attachment, "UTF-8", "plain");
                mbp2.addHeader("Content-Type", "text/plain; charset=UTF-8");
                mbp2.setFileName(filename);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                message.setContent((Multipart)mp);
                Transport t = session.getTransport("smtp");
                t.connect(this.sMailHost, this.sMailEmail, this.sMailPassword);
                t.sendMessage((Message)message, message.getAllRecipients());
                t.close();
            }
            WaitDialog.hideDialog();
            return "Success";
        }
        catch (Exception e) {
            WaitDialog.hideDialog();
            return e.getMessage();
        }
    }

    private boolean loadConfig() {
        try {
            AppConfig config = new AppConfig(new String[0]);
            config.load();
            this.sMailHost = config.getProperty("mail.host");
            this.sMailPort = config.getProperty("mail.port");
            this.sMailEmail = config.getProperty("mail.emailaddress");
            this.sMailEmailTo = config.getProperty("mail.sendto");
            this.sMailPassword = config.getProperty("mail.password");
            this.sMailTLS = config.getProperty("mail.tls");
            this.sMailAuth = config.getProperty("mail.auth");
            this.sWebAddress = config.getProperty("www.address");
            if (this.isConfigured() && this.sMailPassword.startsWith("crypt:")) {
                AltEncrypter cypher = new AltEncrypter("cypherkey" + this.sMailEmail);
                this.sMailPassword = cypher.decrypt(this.sMailPassword.substring(6));
            }
            this.props = new Properties();
            this.props.setProperty("mail.smtp.host", this.sMailHost);
            this.props.setProperty("mail.smtp.starttls.enable", this.sMailTLS);
            this.props.setProperty("mail.smtp.port", this.sMailPort);
            this.props.setProperty("mail.smtp.auth", this.sMailAuth);
            this.props.setProperty("mail.smtp.user", this.sMailEmail);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

