/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.util;

import com.posics.pos.forms.AppProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final NumberFormat cardformat = new DecimalFormat("000000");
    private static final Random cardrandom = new Random();
    public static boolean m_blIsOnline = false;
    public static boolean m_blsecondDisplayAvailable = false;
    public static boolean m_blIsNetworkPrinterOnline = false;
    public static boolean m_blIsDemo = false;
    public static int m_iDemoBills = 0;
    public static boolean m_blIsActivated = false;
    public static boolean m_blIsPCheckRunning = false;
    public static boolean m_blIsPriceEdited = false;
    public static AppProperties config;
    public static boolean m_blTableLayoutRunning;
    public static StringBuffer m_sReceiptBarcode;
    public static String m_sGlobalVariable1;
    public static boolean m_blTicketProperties;
    public static List<String> networkprinterpool;

    private StringUtils() {
    }

    public static String getCardNumber() {
        return cardformat.format(Math.abs(System.currentTimeMillis()) % 1000000L) + cardformat.format(Math.abs(cardrandom.nextLong()) % 1000000L);
    }

    public static String encodeXML(String sValue) {
        if (sValue == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < sValue.length(); ++i) {
            char charToCompare = sValue.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }

    public static String byte2hex(byte[] binput) {
        StringBuffer sb = new StringBuffer(binput.length * 2);
        for (int i = 0; i < binput.length; ++i) {
            int high = (binput[i] & 0xF0) >> 4;
            int low = binput[i] & 0xF;
            sb.append(hexchars[high]);
            sb.append(hexchars[low]);
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String sinput) {
        int length = sinput.length();
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("odd number of characters.");
        }
        byte[] out = new byte[length >> 1];
        int i = 0;
        int j = 0;
        while (j < length) {
            int f = Character.digit(sinput.charAt(j++), 16) << 4;
            out[i] = (byte)((f |= Character.digit(sinput.charAt(j++), 16)) & 0xFF);
            ++i;
        }
        return out;
    }

    public static String readResource(String resource) throws IOException {
        int len;
        InputStream in = StringUtils.class.getResourceAsStream(resource);
        if (in == null) {
            throw new FileNotFoundException(resource);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        byte[] data = out.toByteArray();
        return new String(data, "UTF-8");
    }

    public static boolean isNumber(String sCardNumber) {
        if (sCardNumber == null || sCardNumber.equals("")) {
            return false;
        }
        for (int i = 0; i < sCardNumber.length(); ++i) {
            char c = sCardNumber.charAt(i);
            if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isDouble(String number) {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", number);
    }

    public static boolean isValidIPAddress(String ipAddress) {
        String[] tokens = ipAddress.split("\\.");
        if (tokens.length != 4) {
            return false;
        }
        for (String str : tokens) {
            int i = Integer.parseInt(str);
            if (i >= 0 && i <= 255) continue;
            return false;
        }
        return true;
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            if ((char)bytes[i] <= '\u001f' || (char)bytes[i] >= '\u007f') continue;
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }

    static {
        m_blTableLayoutRunning = false;
        m_blTicketProperties = false;
        networkprinterpool = new ArrayList<String>();
    }
}

