/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.loader.DataParams;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.ImageUtils;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.SerializerReadClass;
import com.posics.data.loader.SerializerWriteParams;
import com.posics.data.loader.SerializerWriteString;
import com.posics.data.loader.Session;
import com.posics.data.loader.StaticSentence;
import com.posics.data.loader.Transaction;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.BeanFactoryDataSingle;
import com.posics.pos.inventory.TaxCategoryInfo;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.ticket.CategoryInfo;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import java.util.List;

public class DataLogicIntegration
extends BeanFactoryDataSingle {
    protected Session s;

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public void executeSumupQueries(String query) throws BasicException {
        new StaticSentence(this.s, query).exec();
    }

    public void generateDataFile(String path, String tablename) throws BasicException {
        new StaticSentence(this.s, "SELECT * FROM " + tablename + " INTO OUTFILE '" + path + "'").exec();
    }

    public void syncCustomersBefore() throws BasicException {
        new StaticSentence(this.s, "UPDATE CUSTOMERS SET VISIBLE = " + this.s.DB.FALSE()).exec();
    }

    public void syncCustomer(final CustomerInfoExt customer) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                if (new PreparedSentence(DataLogicIntegration.this.s, "UPDATE CUSTOMERS SET SEARCHKEY = ?, NAME = ?, NOTES = ?, VISIBLE = " + DataLogicIntegration.this.s.DB.TRUE() + " WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, customer.getSearchkey());
                        this.setString(2, customer.getName());
                        this.setString(3, customer.getAddress());
                        this.setString(4, customer.getId());
                    }
                }) == 0) {
                    new PreparedSentence(DataLogicIntegration.this.s, "INSERT INTO CUSTOMERS(ID, SEARCHKEY, NAME, NOTES, VISIBLE) VALUES (?, ?, ?, ?, " + DataLogicIntegration.this.s.DB.TRUE() + ")", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, customer.getId());
                            this.setString(2, customer.getSearchkey());
                            this.setString(3, customer.getName());
                            this.setString(4, customer.getAddress());
                        }
                    });
                }
                return null;
            }
        };
        t.execute();
    }

    public void syncProductsBefore() throws BasicException {
        new StaticSentence(this.s, "DELETE FROM PRODUCTS_CAT").exec();
    }

    public void syncTaxCategory(final TaxCategoryInfo taxcat) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                if (new PreparedSentence(DataLogicIntegration.this.s, "UPDATE TAXCATEGORIES SET NAME = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, taxcat.getName());
                        this.setString(2, taxcat.getID());
                    }
                }) == 0) {
                    new PreparedSentence(DataLogicIntegration.this.s, "INSERT INTO TAXCATEGORIES(ID, NAME) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, taxcat.getID());
                            this.setString(2, taxcat.getName());
                        }
                    });
                }
                return null;
            }
        };
        t.execute();
    }

    public void syncTax(final TaxInfo tax) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                if (new PreparedSentence(DataLogicIntegration.this.s, "UPDATE TAXES SET NAME = ?, CATEGORY = ?, CUSTCATEGORY = ?, PARENTID = ?, RATE = ?, RATECASCADE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, tax.getName());
                        this.setString(2, tax.getTaxCategoryID());
                        this.setString(3, tax.getTaxCustCategoryID());
                        this.setString(4, tax.getParentID());
                        this.setDouble(5, tax.getRate());
                        this.setBoolean(6, tax.isCascade());
                        this.setString(7, tax.getId());
                    }
                }) == 0) {
                    new PreparedSentence(DataLogicIntegration.this.s, "INSERT INTO TAXES(ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE) VALUES (?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, tax.getId());
                            this.setString(2, tax.getName());
                            this.setString(3, tax.getTaxCategoryID());
                            this.setString(4, tax.getTaxCustCategoryID());
                            this.setString(5, tax.getParentID());
                            this.setDouble(6, tax.getRate());
                            this.setBoolean(7, tax.isCascade());
                        }
                    });
                }
                return null;
            }
        };
        t.execute();
    }

    public void syncCategory(final CategoryInfo cat) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                if (new PreparedSentence(DataLogicIntegration.this.s, "UPDATE CATEGORIES SET NAME = ?, IMAGE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, cat.getName());
                        this.setBytes(2, ImageUtils.writeImage(cat.getImage()));
                        this.setString(3, cat.getID());
                    }
                }) == 0) {
                    new PreparedSentence(DataLogicIntegration.this.s, "INSERT INTO CATEGORIES(ID, NAME, IMAGE) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, cat.getID());
                            this.setString(2, cat.getName());
                            this.setBytes(3, ImageUtils.writeImage(cat.getImage()));
                        }
                    });
                }
                return null;
            }
        };
        t.execute();
    }

    public void syncProduct(final ProductInfoExt prod) throws BasicException {
        Transaction t = new Transaction(this.s){

            public Object transact() throws BasicException {
                if (new PreparedSentence(DataLogicIntegration.this.s, "UPDATE PRODUCTS SET REFERENCE = ?, CODE = ?, NAME = ?, PRICEBUY = ?, PRICESELL = ?, CATEGORY = ?, TAXCAT = ?, IMAGE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, prod.getReference());
                        this.setString(2, prod.getCode());
                        this.setString(3, prod.getName());
                        this.setDouble(4, prod.getPriceBuy());
                        this.setDouble(5, prod.getPriceSell());
                        this.setString(6, prod.getCategoryID());
                        this.setString(7, prod.getTaxCategoryID());
                        this.setBytes(8, ImageUtils.writeImage(prod.getImage()));
                        this.setString(9, prod.getID());
                    }
                }) == 0) {
                    new PreparedSentence(DataLogicIntegration.this.s, "INSERT INTO PRODUCTS (ID, REFERENCE, CODE, NAME, ISCOM, ISSCALE, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, IMAGE, STOCKCOST, STOCKVOLUME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                        @Override
                        public void writeValues() throws BasicException {
                            this.setString(1, prod.getID());
                            this.setString(2, prod.getReference());
                            this.setString(3, prod.getCode());
                            this.setString(4, prod.getName());
                            this.setBoolean(5, prod.isCom());
                            this.setBoolean(6, prod.isScale());
                            this.setDouble(7, prod.getPriceBuy());
                            this.setDouble(8, prod.getPriceSell());
                            this.setString(9, prod.getCategoryID());
                            this.setString(10, prod.getTaxCategoryID());
                            this.setBytes(11, ImageUtils.writeImage(prod.getImage()));
                            this.setDouble(12, 0.0);
                            this.setDouble(13, 0.0);
                        }
                    });
                }
                new StaticSentence(DataLogicIntegration.this.s, "INSERT INTO PRODUCTS_CAT(PRODUCT, CATORDER) VALUES (?, NULL)", SerializerWriteString.INSTANCE).exec((Object)prod.getID());
                return null;
            }
        };
        t.execute();
    }

    public List getTickets() throws BasicException {
        return new PreparedSentence(this.s, "SELECT T.ID, T.TICKETTYPE, T.TICKETID, R.DATENEW, R.MONEY, P.ID, P.NAME, C.ID, C.TAXID, C.SEARCHKEY, C.NAME FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN CUSTOMERS C ON T.CUSTOMER = C.ID WHERE (T.TICKETTYPE = 0 OR T.TICKETTYPE = 1) AND T.STATUS = 0", null, new SerializerReadClass(TicketInfo.class)).list();
    }

    public List getTicketLines(String ticket) throws BasicException {
        return new PreparedSentence(this.s, "SELECT L.TICKET, L.LINE, L.PRODUCT, L.UNITS, L.PRICE, T.ID, T.NAME, T.CATEGORY, T.CUSTCATEGORY, T.PARENTID, T.RATE, T.RATECASCADE, T.RATEORDER, L.ATTRIBUTES FROM TICKETLINES L, TAXES T WHERE L.TAXID = T.ID AND L.TICKET = ?", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket);
    }

    public List getTicketPayments(String ticket) throws BasicException {
        return new PreparedSentence(this.s, "SELECT TOTAL, PAYMENT FROM PAYMENTS WHERE RECEIPT = ?", SerializerWriteString.INSTANCE, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new PaymentInfoTicket(dr.getDouble(1), dr.getString(2));
            }
        }).list((Object)ticket);
    }

    public void execTicketUpdate() throws BasicException {
        new StaticSentence(this.s, "UPDATE TICKETS SET STATUS = 1 WHERE STATUS = 0").exec();
    }
}

