/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.util.AltEncrypter;
import com.posics.pos.util.Base64Encoder;
import com.posics.ws.customers.Customer;
import com.posics.ws.customers.WebServiceImpl;
import com.posics.ws.customers.WebServiceImplServiceLocator;
import com.posics.ws.externalsales.ExternalSalesImpl;
import com.posics.ws.externalsales.ExternalSalesImplServiceLocator;
import com.posics.ws.externalsales.Order;
import com.posics.ws.externalsales.Product;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.xml.rpc.ServiceException;

public class ExternalSalesHelper {
    private ExternalSalesImpl externalSales;
    private WebServiceImpl externalCustomers;
    private String m_sERPUser;
    private String m_sERPPassword;
    private String m_iERPId;
    private String m_iERPOrg;
    private String m_iERPPos;

    public ExternalSalesHelper(DataLogicSystem dlsystem) throws BasicException, ServiceException, MalformedURLException {
        Properties prop = dlsystem.getResourceAsProperties("posics.properties");
        if (prop == null) {
            throw new BasicException(AppLocal.getIntString("message.propsnotdefined"));
        }
        String url = prop.getProperty("url");
        if (url == null || url.equals("")) {
            throw new BasicException(AppLocal.getIntString("message.urlnotdefined"));
        }
        if ((url = url.trim()).endsWith("/ExternalSales")) {
            url = url.substring(0, url.length() - 14);
        }
        this.externalSales = new ExternalSalesImplServiceLocator().getExternalSales(new URL(url + "/ExternalSales"));
        this.externalCustomers = new WebServiceImplServiceLocator().getWebService(new URL(url + "/WebService"));
        this.m_sERPUser = prop.getProperty("user");
        this.m_sERPPassword = prop.getProperty("password");
        if (this.m_sERPUser != null && this.m_sERPPassword != null && this.m_sERPPassword.startsWith("crypt:")) {
            AltEncrypter cypher = new AltEncrypter("key" + this.m_sERPUser);
            this.m_sERPPassword = cypher.decrypt(this.m_sERPPassword.substring(6));
        }
        this.m_sERPPassword = ExternalSalesHelper.getPasswordHash(this.m_sERPPassword);
        this.m_iERPId = prop.getProperty("id");
        this.m_iERPOrg = prop.getProperty("org");
        this.m_iERPPos = prop.getProperty("pos");
    }

    public Customer[] getCustomers() throws RemoteException {
        try {
            return this.externalCustomers.getCustomers(this.m_iERPId, this.m_sERPUser, this.m_sERPPassword);
        }
        catch (RemoteException e) {
            return new Customer[0];
        }
    }

    public Product[] getProductsCatalog() throws RemoteException {
        try {
            return this.externalSales.getProductsPlusCatalog(this.m_iERPId, this.m_iERPOrg, this.m_iERPPos, this.m_sERPUser, this.m_sERPPassword);
        }
        catch (RemoteException e) {
            return this.externalSales.getProductsCatalog(this.m_iERPId, this.m_iERPOrg, this.m_iERPPos, this.m_sERPUser, this.m_sERPPassword);
        }
    }

    public boolean uploadOrders(Order[] orderstoupload) throws RemoteException {
        return this.externalSales.uploadOrders(this.m_iERPId, this.m_iERPOrg, this.m_iERPPos, orderstoupload, this.m_sERPUser, this.m_sERPPassword);
    }

    private static String getPasswordHash(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] raw = md.digest(password.getBytes("UTF-8"));
            return Base64Encoder.encode(raw);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

