/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.ticket.TicketLineInfo;
import com.posics.possync.DataLogicIntegration;
import com.posics.possync.ExternalSalesHelper;
import com.posics.ws.externalsales.BPartner;
import com.posics.ws.externalsales.Order;
import com.posics.ws.externalsales.OrderIdentifier;
import com.posics.ws.externalsales.OrderLine;
import com.posics.ws.externalsales.Payment;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class OrdersSync
implements ProcessAction {
    private DataLogicSystem dlsystem;
    private DataLogicIntegration dlintegration;
    private ExternalSalesHelper externalsales;

    public OrdersSync(DataLogicSystem dlsystem, DataLogicIntegration dlintegration) {
        this.dlsystem = dlsystem;
        this.dlintegration = dlintegration;
        this.externalsales = null;
    }

    @Override
    public MessageInf execute() throws BasicException {
        try {
            if (this.externalsales == null) {
                this.externalsales = new ExternalSalesHelper(this.dlsystem);
            }
            List ticketlist = this.dlintegration.getTickets();
            for (TicketInfo ticket : ticketlist) {
                ticket.setLines(this.dlintegration.getTicketLines(ticket.getId()));
                ticket.setPayments(this.dlintegration.getTicketPayments(ticket.getId()));
            }
            if (ticketlist.size() == 0) {
                return new MessageInf(-67108864, AppLocal.getIntString("message.zeroorders"));
            }
            Order[] orders = this.transformTickets(ticketlist);
            if (!this.externalsales.uploadOrders(orders)) {
                throw new BasicException(AppLocal.getIntString("message.returnnull"));
            }
            this.dlintegration.execTicketUpdate();
            return new MessageInf(-83886080, AppLocal.getIntString("message.syncordersok"), AppLocal.getIntString("message.syncordersinfo", orders.length));
        }
        catch (ServiceException e) {
            throw new BasicException(AppLocal.getIntString("message.serviceexception"), e);
        }
        catch (RemoteException e) {
            throw new BasicException(AppLocal.getIntString("message.remoteexception"), e);
        }
        catch (MalformedURLException e) {
            throw new BasicException(AppLocal.getIntString("message.malformedurlexception"), e);
        }
    }

    private Order[] transformTickets(List<TicketInfo> ticketlist) {
        Order[] orders = new Order[ticketlist.size()];
        for (int i = 0; i < ticketlist.size(); ++i) {
            BPartner bp;
            TicketInfo ticket = ticketlist.get(i);
            orders[i] = new Order();
            OrderIdentifier orderid = new OrderIdentifier();
            Calendar datenew = Calendar.getInstance();
            datenew.setTime(ticket.getDate());
            orderid.setDateNew(datenew);
            orderid.setDocumentNo(Integer.toString(ticket.getTicketId()));
            orders[i].setOrderId(orderid);
            orders[i].setState(800175);
            if (ticket.getCustomerId() == null) {
                bp = null;
            } else {
                bp = new BPartner();
                bp.setId(ticket.getCustomer().getSearchkey());
                bp.setName(ticket.getCustomer().getName());
            }
            orders[i].setBusinessPartner(bp);
            OrderLine[] orderLine = new OrderLine[ticket.getLines().size()];
            for (int j = 0; j < ticket.getLines().size(); ++j) {
                TicketLineInfo line = ticket.getLines().get(j);
                orderLine[j] = new OrderLine();
                orderLine[j].setOrderLineId(String.valueOf(line.getTicketLine()));
                if (line.getProductID() == null) {
                    orderLine[j].setProductId("0");
                } else {
                    orderLine[j].setProductId(line.getProductID());
                }
                orderLine[j].setUnits(line.getMultiply());
                orderLine[j].setPrice(line.getPrice());
                orderLine[j].setTaxId(line.getTaxInfo().getId());
            }
            orders[i].setLines(orderLine);
            Payment[] paymentLine = new Payment[ticket.getPayments().size()];
            for (int j = 0; j < ticket.getPayments().size(); ++j) {
                PaymentInfo payment = ticket.getPayments().get(j);
                paymentLine[j] = new Payment();
                paymentLine[j].setAmount(payment.getTotal());
                if ("magcard".equals(payment.getName())) {
                    paymentLine[j].setPaymentType("K");
                    continue;
                }
                if ("cheque".equals(payment.getName())) {
                    paymentLine[j].setPaymentType("2");
                    continue;
                }
                if ("cash".equals(payment.getName())) {
                    paymentLine[j].setPaymentType("B");
                    continue;
                }
                paymentLine[j].setPaymentType(null);
            }
            orders[i].setPayment(paymentLine);
        }
        return orders;
    }

    private static int parseInt(String sValue) {
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException eNF) {
            return 0;
        }
    }
}

