/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.data.loader.ImageUtils;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.inventory.TaxCategoryInfo;
import com.posics.pos.ticket.CategoryInfo;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.possync.DataLogicIntegration;
import com.posics.possync.ExternalSalesHelper;
import com.posics.ws.customers.Customer;
import com.posics.ws.externalsales.Product;
import com.posics.ws.externalsales.ProductPlus;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.UUID;
import javax.xml.rpc.ServiceException;

public class ProductsSync
implements ProcessAction {
    private DataLogicSystem dlsystem;
    private DataLogicIntegration dlintegration;
    private DataLogicSales dlsales;
    private String warehouse;
    private ExternalSalesHelper externalsales;

    public ProductsSync(DataLogicSystem dlsystem, DataLogicIntegration dlintegration, DataLogicSales dlsales, String warehouse) {
        this.dlsystem = dlsystem;
        this.dlintegration = dlintegration;
        this.dlsales = dlsales;
        this.warehouse = warehouse;
        this.externalsales = null;
    }

    @Override
    public MessageInf execute() throws BasicException {
        try {
            if (this.externalsales == null) {
                this.externalsales = new ExternalSalesHelper(this.dlsystem);
            }
            Product[] products = this.externalsales.getProductsCatalog();
            Customer[] customers = this.externalsales.getCustomers();
            if (products == null || customers == null) {
                throw new BasicException(AppLocal.getIntString("message.returnnull"));
            }
            if (products.length > 0) {
                this.dlintegration.syncProductsBefore();
                Date now = new Date();
                Product[] productArray = products;
                int n = productArray.length;
                for (int i = 0; i < n; ++i) {
                    Product product = productArray[i];
                    TaxCategoryInfo tc = new TaxCategoryInfo(product.getTax().getId(), product.getTax().getName());
                    this.dlintegration.syncTaxCategory(tc);
                    TaxInfo t = new TaxInfo(product.getTax().getId(), product.getTax().getName(), tc.getID(), null, null, product.getTax().getPercentage() / 100.0, false, 0);
                    this.dlintegration.syncTax(t);
                    CategoryInfo c = new CategoryInfo(product.getCategory().getId(), product.getCategory().getName(), null);
                    this.dlintegration.syncCategory(c);
                    ProductInfoExt p = new ProductInfoExt();
                    p.setID(product.getId());
                    p.setReference(product.getId());
                    p.setCode(product.getEan() == null || product.getEan().equals("") ? product.getId() : product.getEan());
                    p.setName(product.getName());
                    p.setCom(false);
                    p.setScale(false);
                    p.setPriceBuy(product.getPurchasePrice());
                    p.setPriceSell(product.getListPrice());
                    p.setCategoryID(c.getID());
                    p.setTaxCategoryID(tc.getID());
                    p.setImage(ImageUtils.readImage(product.getImageUrl()));
                    this.dlintegration.syncProduct(p);
                    if (!(product instanceof ProductPlus)) continue;
                    ProductPlus productplus = (ProductPlus)product;
                    double diff = productplus.getQtyonhand() - this.dlsales.findProductStock(this.warehouse, p.getID(), null);
                    Object[] diary = new Object[]{UUID.randomUUID().toString(), now, diff > 0.0 ? MovementReason.IN_MOVEMENT.getKey() : MovementReason.OUT_MOVEMENT.getKey(), this.warehouse, p.getID(), new Double(diff), new Double(p.getPriceBuy())};
                    this.dlsales.getStockDiaryInsert().exec(diary);
                }
            }
            if (customers.length > 0) {
                this.dlintegration.syncCustomersBefore();
                for (Customer customer : customers) {
                    CustomerInfoExt cinfo = new CustomerInfoExt(customer.getId());
                    cinfo.setSearchkey(customer.getSearchKey());
                    cinfo.setName(customer.getName());
                    cinfo.setNotes(customer.getDescription());
                    this.dlintegration.syncCustomer(cinfo);
                }
            }
            if (products.length == 0 && customers.length == 0) {
                return new MessageInf(-67108864, AppLocal.getIntString("message.zeroproducts"));
            }
            return new MessageInf(-83886080, AppLocal.getIntString("message.syncproductsok"), AppLocal.getIntString("message.syncproductsinfo", products.length, customers.length));
        }
        catch (ServiceException e) {
            throw new BasicException(AppLocal.getIntString("message.serviceexception"), e);
        }
        catch (RemoteException e) {
            throw new BasicException(AppLocal.getIntString("message.remoteexception"), e);
        }
        catch (MalformedURLException e) {
            throw new BasicException(AppLocal.getIntString("message.malformedurlexception"), e);
        }
    }
}

