/*
 * Decompiled with CFR 0.152.
 */
package com.posics.possync;

import com.posics.basic.BasicException;
import com.posics.data.gui.MessageInf;
import com.posics.pos.forms.AppConfig;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.forms.ProcessAction;
import com.posics.pos.util.ActivationCheck;
import com.posics.possync.DataLogicIntegration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class SumupSync
extends JFrame
implements ProcessAction {
    private DataLogicIntegration dlintegration;
    private DataLogicSystem dlsystem;
    private Thread worker;
    private JTextArea outText;
    private JButton btnCancel;
    private JButton btnSync;
    private JScrollPane sp;
    private JPanel pan1;
    private JPanel pan2;
    public boolean ETLSTATUS = false;
    private ArrayList datafiles;
    private String hostname;
    private static final String SYNC_URL = "http://saleculator.com/update/syncurl.html";

    public SumupSync(DataLogicIntegration dlintegration, DataLogicSystem dlsystem, String hostname) {
        this.dlintegration = dlintegration;
        this.dlsystem = dlsystem;
        this.hostname = hostname;
    }

    public void sync() {
        JDialog d6 = new JDialog((Window)this, "", Dialog.ModalityType.DOCUMENT_MODAL);
        d6.setTitle("Saleculator SumUp Services");
        this.outText = new JTextArea();
        this.outText.setEditable(false);
        Font font = this.outText.getFont();
        float size = (float)font.getSize() + 1.0f;
        this.outText.setFont(font.deriveFont(size));
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.outText);
        this.btnSync = new JButton("Sync");
        this.btnSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SumupSync.this.sumupsync();
            }
        });
        this.btnCancel = new JButton("Close");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SumupSync.this.dispose();
            }
        });
        this.outText.setText("Make sure Saleculator is connected to the network before proceding.\n");
        this.outText.setEditable(false);
        this.btnSync.setHorizontalAlignment(4);
        this.btnCancel.setHorizontalAlignment(4);
        Container cp6 = d6.getContentPane();
        cp6.setLayout(new BorderLayout());
        cp6.add((Component)new JScrollPane(this.outText), "Center");
        JPanel p6 = new JPanel();
        p6.setLayout(new FlowLayout(0));
        p6.add(this.btnSync);
        p6.add(this.btnCancel);
        cp6.add((Component)p6, "South");
        this.outText.setFocusable(false);
        d6.pack();
        d6.setSize(500, 400);
        d6.setModal(true);
        d6.setLocationRelativeTo(null);
        d6.setVisible(true);
    }

    @Override
    public MessageInf execute() throws BasicException {
        this.sync();
        return null;
    }

    private void sumupsync() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                SumupSync.this.btnSync.setEnabled(false);
                try {
                    AppConfig config = new AppConfig(new String[0]);
                    config.load();
                    String sumupscript = config.getProperty("sumup.script");
                    if (sumupscript == null || sumupscript.equals("")) {
                        String inputLine;
                        SumupSync.this.outText.setText("Contacting SumUp server...");
                        String syncUrl = SumupSync.this.getsynclink();
                        String MAC = ActivationCheck.getMacAddress();
                        String SERIAL = ActivationCheck.getSerialKey();
                        String urlParameters = "/" + MAC + "/" + SERIAL + "/" + SumupSync.this.hostname.replace(" ", "") + "/" + "1.0";
                        SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nSigning in...");
                        URL url = new URL(syncUrl + urlParameters);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                        StringBuilder buffer = new StringBuilder("");
                        while ((inputLine = in.readLine()) != null) {
                            buffer.append(inputLine);
                        }
                        in.close();
                        connection.disconnect();
                        String msg = buffer.toString();
                        SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\n" + msg.substring(msg.indexOf("[MESSAGE]") + 9, msg.indexOf("[/MESSAGE]")));
                        String status = msg.substring(msg.indexOf("[STATUS]") + 8, msg.indexOf("[/STATUS]"));
                        if (Integer.parseInt(status) == 1) {
                            String ftphost = msg.substring(msg.indexOf("[HOST]") + 6, msg.indexOf("[/HOST]"));
                            String ftpuser = msg.substring(msg.indexOf("[USER]") + 6, msg.indexOf("[/USER]"));
                            String ftppwd = msg.substring(msg.indexOf("[PWD]") + 5, msg.indexOf("[/PWD]"));
                            String ftpfolder = msg.substring(msg.indexOf("[FOLDER]") + 8, msg.indexOf("[/FOLDER]"));
                            String orgid = msg.substring(msg.indexOf("[ORG]") + 5, msg.indexOf("[/ORG]"));
                            String etlid = msg.substring(msg.indexOf("[ETL]") + 5, msg.indexOf("[/ETL]"));
                            String query = msg.substring(msg.indexOf("[QUERY]") + 7, msg.indexOf("[/QUERY]"));
                            String[] sqllines = query.split(";");
                            int i = sqllines.length;
                            boolean sqlExe = true;
                            SumupSync.this.datafiles = new ArrayList();
                            for (int j = 0; j < i; ++j) {
                                File fd = new File(System.getProperty("java.io.tmpdir"), "data" + j + "_" + SERIAL + ".data");
                                if (fd.exists()) {
                                    fd.delete();
                                }
                                String path = fd.getAbsolutePath().replace("\\", "\\\\");
                                String[] sqllines2 = sqllines[j].split("#");
                                if (SumupSync.this.generatesumupdatafiles(sqllines2[1] + " INTO OUTFILE '" + path + "' FIELDS TERMINATED BY '\t' ENCLOSED BY '\"' LINES TERMINATED BY '\n';")) {
                                    SumupSync.this.datafiles.add(fd.getName() + '#' + sqllines2[0]);
                                    continue;
                                }
                                sqlExe = false;
                            }
                            if (sqlExe) {
                                SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nUploading data...");
                                SumupSync.this.uploadfiles(ftphost, ftpuser, ftppwd, ftpfolder);
                                SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nLoading data...");
                                SumupSync.this.loaddata(syncUrl + "load");
                                SumupSync.this.deletefiles();
                                SumupSync.this.loaddata(syncUrl + "finish/" + etlid);
                                SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nFinished.");
                            } else {
                                SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nData extraction failed.");
                            }
                        }
                    } else {
                        Runtime runtime = Runtime.getRuntime();
                        Process proc = runtime.exec(sumupscript);
                        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        System.out.println("Executing SumUp script:\n");
                        String s = null;
                        while ((s = stdInput.readLine()) != null) {
                            SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\n" + s);
                        }
                        System.out.println("Errors:\n");
                        while ((s = stdError.readLine()) != null) {
                            SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\n" + s);
                        }
                    }
                }
                catch (UnknownHostException ex) {
                    System.out.println(ex.getMessage());
                    SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nInternet not available. Please check your connection and try again.");
                    SumupSync.this.ETLSTATUS = false;
                }
                catch (Exception ex) {
                    SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\n" + ex.getMessage() + "\n");
                    SumupSync.this.outText.setText(SumupSync.this.outText.getText() + "\nSyncing failed.");
                    SumupSync.this.ETLSTATUS = false;
                }
                SumupSync.this.btnSync.setEnabled(true);
            }
        });
        this.worker.start();
    }

    private boolean generatesumupdatafiles(String query) {
        try {
            this.dlintegration.executeSumupQueries(query);
            return true;
        }
        catch (BasicException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void generatedatafiles() {
        try {
            String tables = this.dlsystem.getResourceAsXML("Sync.Tables");
            if (tables != null) {
                tables = tables.replace("\n", "");
                String[] lines = tables.split(";");
                this.datafiles = new ArrayList();
                for (int j = 0; j < lines.length; ++j) {
                    File fd = new File(System.getProperty("java.io.tmpdir"), lines[j] + ".data");
                    if (fd.exists()) {
                        fd.delete();
                    }
                    String path = fd.getAbsolutePath().replace("\\", "\\\\");
                    this.dlintegration.generateDataFile(path, lines[j]);
                    this.datafiles.add(fd.getAbsoluteFile());
                }
            }
        }
        catch (BasicException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadfiles(String host, String user, String pwd, String folder) {
        FTPClient client = new FTPClient();
        FileInputStream fis = null;
        File fd = null;
        try {
            client.connect(host);
            int reply = client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.outText.setText(this.outText.getText() + "\nConnection refused.");
                return;
            }
            client.login(user, pwd);
            client.enterLocalPassiveMode();
            for (int i = 0; i < this.datafiles.size(); ++i) {
                String[] dfile = this.datafiles.get(i).toString().split("#");
                fd = new File(System.getProperty("java.io.tmpdir"), dfile[0]);
                fis = new FileInputStream(fd);
                client.deleteFile(fd.getName());
                client.storeFile(folder + "/" + fd.getName(), (InputStream)fis);
                fis.close();
            }
            client.logout();
        }
        catch (SocketException e) {
            System.out.println(e.getMessage());
            this.outText.setText(this.outText.getText() + "\nData upload error.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.outText.setText(this.outText.getText() + "\nData upload error.");
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deletefiles() {
        for (int i = 0; i < this.datafiles.size(); ++i) {
            try {
                String[] dlines = this.datafiles.get(i).toString().split("#");
                File fd = new File(System.getProperty("java.io.tmpdir"), dlines[0]);
                if (!fd.exists()) continue;
                fd.delete();
                continue;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    private void loaddata(String loadurl) {
        try {
            for (int i = 0; i < this.datafiles.size(); ++i) {
                String inputLine;
                String[] dlines = this.datafiles.get(i).toString().split("#");
                String urlParameters = "/" + dlines[0] + "/" + dlines[1];
                URL url = new URL(loadurl + urlParameters);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder buffer = new StringBuilder("");
                while ((inputLine = in.readLine()) != null) {
                    buffer.append(inputLine);
                }
                in.close();
                connection.disconnect();
                String string = buffer.toString();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private String getsynclink() throws MalformedURLException, IOException {
        URL url = new URL(SYNC_URL);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        return buffer.substring(buffer.indexOf("[url]") + 5, buffer.indexOf("[/url]"));
    }
}

